/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.items.gun;

import com.chocolate.chocolateQuest.entity.EntityHumanBase;
import com.chocolate.chocolateQuest.entity.npc.EntityGolemMecha;
import com.chocolate.chocolateQuest.entity.projectile.EntityBaseBall;
import com.chocolate.chocolateQuest.items.gun.ItemPistol;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemGolemWeapon
extends ItemPistol {
    final int projectileDamage;
    final int ammoCapacity;

    public ItemGolemWeapon() {
        this(10, 16.0f, 5.0f);
    }

    public ItemGolemWeapon(int cooldown, float range, float accuracy) {
        this(cooldown, range, accuracy, 1, 16);
    }

    public ItemGolemWeapon(int cooldown, float range, float accuracy, int lvl, int capacity) {
        super(cooldown, range * range, accuracy);
        this.projectileDamage = lvl;
        this.ammoCapacity = capacity;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
    }

    @Override
    public void shootFromEntity(EntityLivingBase shooter, ItemStack is, int angle, Entity target) {
        this.shootFromGolem(shooter, is, angle, target);
    }

    public void shootFromGolem(EntityLivingBase shooter, ItemStack is, int angle, Entity target) {
        if (!shooter.field_70170_p.field_72995_K) {
            EntityBaseBall ball;
            double armDist = shooter.field_70130_N * 2.0f;
            double posX = shooter.field_70165_t - Math.sin(Math.toRadians(shooter.field_70759_as + (float)angle)) * armDist;
            double posY = shooter.field_70163_u + 1.6;
            double posZ = shooter.field_70161_v + Math.cos(Math.toRadians(shooter.field_70759_as + (float)angle)) * armDist;
            if (target != null) {
                ball = this.getBall(shooter.field_70170_p, shooter, target.field_70165_t - posX, target.field_70163_u + (double)target.field_70131_O - posY, target.field_70161_v - posZ);
            } else {
                double ry = Math.toRadians(shooter.field_70759_as - 180.0f);
                double x = Math.sin(ry);
                double z = -Math.cos(ry);
                double y = -Math.sin(Math.toRadians(shooter.field_70125_A * 2.0f - 1.0f));
                ball = this.getBall(shooter.field_70170_p, shooter, x, y, z);
                ball.field_70163_u -= (double)(shooter.field_70131_O / 2.0f);
            }
            ball.func_70107_b(posX, posY, posZ);
            shooter.field_70170_p.func_72838_d((Entity)ball);
        }
    }

    @Override
    public EntityBaseBall getBall(World world, EntityLivingBase shooter, double x, double y, double z) {
        float accuracy = this.accuracy;
        int projectile = 1;
        if (shooter instanceof EntityHumanBase) {
            accuracy += ((EntityHumanBase)shooter).accuracy;
            if (shooter instanceof EntityGolemMecha) {
                projectile = 2;
            }
        }
        return new EntityBaseBall(shooter.field_70170_p, shooter, x, y, z, projectile, 0, accuracy);
    }

    @Override
    public void func_77663_a(ItemStack is, World world, Entity entity, int par4, boolean par5) {
        super.func_77663_a(is, world, entity, par4, par5);
    }

    @Override
    public int getCooldown(EntityLivingBase shooter, ItemStack is) {
        if (shooter instanceof EntityGolemMecha) {
            return Math.max(this.cooldownBase - 10, 0);
        }
        return this.cooldownBase;
    }

    @Override
    public int getAmmoLoaderStackSize(ItemStack is) {
        return this.ammoCapacity;
    }
}

