/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.items;

import com.chocolate.chocolateQuest.API.DungeonBase;
import com.chocolate.chocolateQuest.API.DungeonRegister;
import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.EntityHumanBase;
import com.chocolate.chocolateQuest.entity.boss.EntityBull;
import com.chocolate.chocolateQuest.entity.boss.EntityGiantBoxer;
import com.chocolate.chocolateQuest.entity.boss.EntitySlimeBoss;
import com.chocolate.chocolateQuest.entity.boss.EntitySpiderBoss;
import com.chocolate.chocolateQuest.entity.boss.EntityTurtle;
import com.chocolate.chocolateQuest.entity.boss.EntityWyvern;
import com.chocolate.chocolateQuest.entity.mob.EntityHumanGremlin;
import com.chocolate.chocolateQuest.entity.mob.EntityHumanPirate;
import com.chocolate.chocolateQuest.entity.mob.EntityHumanSkeleton;
import com.chocolate.chocolateQuest.entity.mob.EntityHumanSpecter;
import com.chocolate.chocolateQuest.entity.mob.EntityHumanWalker;
import com.chocolate.chocolateQuest.entity.mob.EntityHumanZombie;
import com.chocolate.chocolateQuest.entity.mob.EntityLich;
import com.chocolate.chocolateQuest.entity.mob.EntityNecromancer;
import com.chocolate.chocolateQuest.entity.mob.EntityPirateBoss;
import com.chocolate.chocolateQuest.entity.mob.EntitySpecterBoss;
import com.chocolate.chocolateQuest.entity.mob.EntityWalkerBoss;
import com.chocolate.chocolateQuest.entity.npc.EntityHumanDummy;
import com.chocolate.chocolateQuest.items.MobData;
import com.chocolate.chocolateQuest.misc.EquipementHelper;
import com.chocolate.chocolateQuest.utils.BDHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ItemEggBD
extends Item
implements IBehaviorDispenseItem {
    final int unequipped = 0;
    final int leather = 1;
    final int chain = 2;
    final int gold = 3;
    final int iron = 4;
    final int diamond = 5;
    int OFF_BOSS_HUMAN = 700;
    int OFF_BOSS = 800;
    int OFF_DUNGEON = 900;
    public static final int MICROPHONE = 499;
    int cooldown = 0;
    String[] name;
    String[] bossName;
    IIcon[] bossIcon;
    IIcon[] dungeonIcon;
    MobData[] mobs = new MobData[]{new MobData(EntityHumanDummy.class, "Dummy", 0), new MobData(EntityHumanSkeleton.class, "Skeleton", 8), new MobData(EntityHumanZombie.class, "Zombie", 7), new MobData(EntityHumanSpecter.class, "Specter", 12), new MobData(EntityHumanWalker.class, "Abyss Walker", 10), new MobData(EntityHumanGremlin.class, "Gremlin", 11), new MobData(EntityHumanPirate.class, "Pirate", 9)};
    MobData[] humanBosses = new MobData[]{new MobData(EntityNecromancer.class, "Necromancer", 8), new MobData(EntityLich.class, "Lich", 7), new MobData(EntityPirateBoss.class, "Pirate Boss", 9), new MobData(EntityWalkerBoss.class, "Abyss Walker Boss", 10), new MobData(EntitySpecterBoss.class, "Specter Boss", 12)};
    MobData[] bosses = new MobData[]{new MobData(EntityTurtle.class, "Turtle", 3), new MobData(EntityGiantBoxer.class, "Giant", 2), new MobData(EntityBull.class, "Bull", 4), new MobData(EntitySlimeBoss.class, "Slime", 1), new MobData(EntitySpiderBoss.class, "Spider", 0), new MobData(EntityWyvern.class, "Dragon", 5)};

    public ItemEggBD() {
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)this);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        int i;
        this.bossIcon = new IIcon[7];
        for (i = 0; i < this.bossIcon.length; ++i) {
            this.bossIcon[i] = iconRegister.func_94245_a("chocolatequest:b" + i);
        }
        this.dungeonIcon = new IIcon[12];
        for (i = 0; i < this.dungeonIcon.length; ++i) {
            this.dungeonIcon[i] = iconRegister.func_94245_a("chocolatequest:d" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemId, CreativeTabs table, List list) {
        int i;
        for (i = 0; i < this.mobs.length; ++i) {
            for (int l = 0; l < 6; ++l) {
                list.add(new ItemStack(itemId, 1, i + 100 * l));
            }
        }
        for (i = 0; i < this.humanBosses.length; ++i) {
            list.add(new ItemStack(itemId, 1, i + this.OFF_BOSS_HUMAN));
        }
        for (i = 0; i < this.bosses.length; ++i) {
            list.add(new ItemStack(itemId, 1, i + this.OFF_BOSS));
        }
        if (DungeonRegister.dungeonList != null) {
            for (i = 0; i < DungeonRegister.dungeonList.size(); ++i) {
                list.add(new ItemStack(itemId, 1, this.OFF_DUNGEON + i));
            }
        }
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        MovingObjectPosition movingobjectposition = this.playerPick(entityplayer, world);
        if (movingobjectposition != null) {
            int k;
            int j;
            int i;
            if (movingobjectposition.field_72308_g != null) {
                i = MathHelper.func_76128_c((double)movingobjectposition.field_72308_g.field_70165_t);
                j = MathHelper.func_76128_c((double)movingobjectposition.field_72308_g.field_70163_u) + 1;
                k = MathHelper.func_76128_c((double)movingobjectposition.field_72308_g.field_70161_v);
            } else {
                i = movingobjectposition.field_72311_b;
                j = movingobjectposition.field_72312_c;
                k = movingobjectposition.field_72309_d;
                switch (movingobjectposition.field_72310_e) {
                    case 1: {
                        ++j;
                        break;
                    }
                    case 0: {
                        --j;
                        break;
                    }
                    case 2: {
                        --k;
                        break;
                    }
                    case 3: {
                        ++k;
                        break;
                    }
                    case 5: {
                        ++i;
                        break;
                    }
                    case 4: {
                        --i;
                    }
                }
            }
            this.onItemUse(itemstack, entityplayer, world, i, j, k, 0);
        }
        return super.func_77659_a(itemstack, world, entityplayer);
    }

    public MovingObjectPosition playerPick(EntityPlayer player, World world) {
        int dist = 80;
        Vec3 vec3d = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e()), (double)player.field_70161_v);
        Vec3 vec3d1 = Vec3.func_72443_a((double)(player.field_70165_t + player.func_70040_Z().field_72450_a * (double)dist), (double)(player.field_70163_u + player.func_70040_Z().field_72448_b * (double)dist), (double)(player.field_70161_v + player.func_70040_Z().field_72449_c * (double)dist));
        MovingObjectPosition movingobjectposition = world.func_72933_a(vec3d, vec3d1);
        List list = world.func_72839_b((Entity)player, player.field_70121_D.func_72321_a(player.func_70040_Z().field_72450_a * 40.0, player.func_70040_Z().field_72448_b * 40.0, player.func_70040_Z().field_72449_c * 40.0).func_72314_b(1.0, 1.0, 1.0));
        double d = 0.0;
        for (int j = 0; j < list.size(); ++j) {
            float f2;
            AxisAlignedBB axisalignedbb;
            MovingObjectPosition movingobjectposition1;
            Entity entity1 = (Entity)list.get(j);
            if (!entity1.func_70067_L() || (movingobjectposition1 = (axisalignedbb = entity1.field_70121_D.func_72314_b((double)(f2 = 0.3f), (double)f2, (double)f2)).func_72327_a(vec3d, vec3d1)) == null) continue;
            movingobjectposition1.field_72308_g = entity1;
            return movingobjectposition1;
        }
        return movingobjectposition;
    }

    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l) {
        int itemDamage = itemstack.func_77960_j();
        if (itemDamage >= this.OFF_DUNGEON && !world.field_72995_K) {
            DungeonBase dungeon;
            if (this.cooldown <= 0 && (dungeon = DungeonRegister.dungeonList.get(itemDamage - this.OFF_DUNGEON)) != null) {
                File file = new File(BDHelper.getAppDir(), "Chocolate/DungeonConfig/" + dungeon.getName());
                dungeon = dungeon.readData(file);
                Random random = new Random();
                int x = i / 16;
                int z = k / 16;
                i -= Math.abs(i % 16);
                k -= Math.abs(k % 16);
                random.setSeed((long)(x + z) + world.func_72905_C());
                dungeon.getBuilder().generate(random, world, i, j, k, dungeon.getMobID());
                this.cooldown = 100;
            }
            return true;
        }
        Entity e = this.getEntity(world, i, j, k, itemDamage);
        if (e != null) {
            if (itemDamage < this.OFF_BOSS_HUMAN) {
                EntityHumanBase entityLiving = (EntityHumanBase)e;
                int armorType = itemDamage / 100;
                if (armorType != 0) {
                    EquipementHelper.equipHumanRandomly(entityLiving, armorType - 1, EquipementHelper.getRandomType(entityLiving, 5));
                }
            }
            e.func_70107_b((double)i + 0.5, (double)(j + 1), (double)k + 0.5);
            if (!world.field_72995_K) {
                world.func_72838_d(e);
            }
            return true;
        }
        return false;
    }

    public Entity getEntity(World world, int i, int j, int k, int itemDamage) {
        EntityHumanBase e = null;
        Class currentClass = EntityHumanBase.class;
        MobData data = this.getDataFromDamage(itemDamage);
        if (data != null) {
            currentClass = data.mobClass;
        }
        try {
            Constructor c = currentClass.getDeclaredConstructor(World.class);
            c.setAccessible(true);
            e = (Entity)c.newInstance(world);
        }
        catch (Exception ex) {
            e = new EntityHumanBase(world);
        }
        return e;
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        super.func_77663_a(par1ItemStack, par2World, par3Entity, par4, par5);
    }

    public String func_77653_i(ItemStack itemstack) {
        MobData data;
        DungeonBase dungeon;
        int i = itemstack.func_77960_j();
        if (i >= this.OFF_DUNGEON && (dungeon = DungeonRegister.dungeonList.get(i - this.OFF_DUNGEON)) != null) {
            return dungeon.getName();
        }
        int itemDamage = itemstack.func_77960_j();
        String info = "";
        if (i < this.OFF_BOSS) {
            int armorType = itemDamage / 100;
            switch (armorType) {
                case 1: {
                    info = " Leather";
                    break;
                }
                case 2: {
                    info = " Chain";
                    break;
                }
                case 3: {
                    info = " Gold";
                    break;
                }
                case 4: {
                    info = " Iron";
                    break;
                }
                case 5: {
                    info = " Diamond";
                    break;
                }
            }
        }
        if ((data = this.getDataFromDamage(itemDamage)) != null) {
            return data.name + info;
        }
        return "????";
    }

    public IIcon func_77617_a(int itemDamage) {
        DungeonBase dungeon;
        if (itemDamage == 499) {
            return this.dungeonIcon[11];
        }
        if (itemDamage >= this.OFF_DUNGEON && (dungeon = DungeonRegister.dungeonList.get(itemDamage - this.OFF_DUNGEON)) != null) {
            if (dungeon.getIcon() < this.dungeonIcon.length) {
                // empty if block
            }
            return this.dungeonIcon[dungeon.getIcon()];
        }
        MobData data = this.getDataFromDamage(itemDamage);
        if (data != null) {
            if (itemDamage < this.OFF_BOSS) {
                return ChocolateQuest.shield.func_77617_a(data.color);
            }
            return this.bossIcon[data.color];
        }
        return this.dungeonIcon[0];
    }

    public MobData getDataFromDamage(int itemDamage) {
        if (itemDamage >= this.OFF_BOSS) {
            if ((itemDamage -= this.OFF_BOSS) < this.bosses.length) {
                return this.bosses[itemDamage];
            }
        } else if (itemDamage >= this.OFF_BOSS_HUMAN) {
            if ((itemDamage -= this.OFF_BOSS_HUMAN) < this.bosses.length) {
                return this.humanBosses[itemDamage];
            }
        } else if ((itemDamage %= 100) < this.mobs.length) {
            return this.mobs[itemDamage];
        }
        return null;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (stack.field_77990_d != null) {
            Entity e = player.field_70170_p.func_73045_a(stack.field_77990_d.func_74762_e("EntityID"));
            if (e instanceof EntityLiving) {
                if (entity instanceof EntityLiving) {
                    ((EntityLiving)e).func_70624_b((EntityLivingBase)((EntityLiving)entity));
                }
            } else {
                if (!player.field_70170_p.field_72995_K) {
                    player.func_145747_a((IChatComponent)new ChatComponentText("Assigned entity not found, left click to assign a new entity"));
                }
                stack.field_77990_d = null;
            }
            return true;
        }
        if (entity instanceof EntityLiving) {
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74768_a("EntityID", entity.func_145782_y());
            stack.field_77990_d.func_74778_a("name", entity.func_70005_c_());
            if (!player.field_70170_p.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Assigned " + BDHelper.StringColor("2") + entity.func_70005_c_() + BDHelper.StringColor("f") + " to this item"));
                player.func_145747_a((IChatComponent)new ChatComponentText("Left click to another entity to start a fight!"));
            }
            return true;
        }
        return false;
    }

    public ItemStack func_82482_a(IBlockSource iblocksource, ItemStack itemstack) {
        EnumFacing enumfacing = BlockDispenser.func_149937_b((int)iblocksource.func_82620_h());
        double d0 = iblocksource.func_82615_a() + (double)enumfacing.func_82601_c();
        double d1 = (float)iblocksource.func_82622_e() + 0.2f;
        double d2 = iblocksource.func_82616_c() + (double)enumfacing.func_82599_e();
        Entity e = this.getEntity(iblocksource.func_82618_k(), (int)d0, (int)d1, (int)d2, itemstack.func_77960_j());
        if (e != null) {
            e.func_70107_b(d0, d1, d2);
            if (!iblocksource.func_82618_k().field_72995_K) {
                iblocksource.func_82618_k().func_72838_d(e);
            }
        }
        --itemstack.field_77994_a;
        return itemstack;
    }
}

