/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.gui;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.gui.InventoryBag;
import com.chocolate.chocolateQuest.items.ItemArmorHelmetScouter;
import com.chocolate.chocolateQuest.items.gun.ILoadableGun;
import com.chocolate.chocolateQuest.magic.IElementWeak;
import com.chocolate.chocolateQuest.utils.BDHelper;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class GuiInGameStats
extends Gui {
    private Minecraft mc;
    private int xPos;
    private int yPos;
    private static final int ICON_SIZE = 16;
    private static final int ICON_SPACING = 18;
    private static final int ICONS_PER_ROW = 16;
    private static final int COLOR = 0xFFFFFF;
    DamageSource physic = new DamageSource("");
    DamageSource fire = new DamageSource("").func_76361_j();
    DamageSource blast = new DamageSource("").func_94540_d();
    DamageSource magic = new DamageSource("").func_82726_p();
    DamageSource projectile = new DamageSource("").func_76349_b();

    public GuiInGameStats(Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderExperienceBar(RenderGameOverlayEvent event) {
        ItemStack itemstack;
        if (event.isCancelable() || event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_71045_bC() != null && (itemstack = player.func_71045_bC()).func_77973_b() instanceof ILoadableGun) {
            ItemStack[] cargo = InventoryBag.getCargo(itemstack);
            int despX = 0;
            for (int i = 0; i < cargo.length; ++i) {
                if (cargo[i] == null) continue;
                ItemStack cargoItem = cargo[i];
                GL11.glPushMatrix();
                float scale = 16.0f;
                GL11.glTranslatef((float)(scale + (float)despX), (float)scale, (float)0.0f);
                GL11.glScalef((float)(-scale), (float)(-scale), (float)0.0f);
                IIcon icon = cargoItem.func_77954_c();
                ResourceLocation resourcelocation = this.mc.field_71446_o.func_130087_a(cargoItem.func_94608_d());
                this.mc.field_71446_o.func_110577_a(resourcelocation);
                ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
                GL11.glPopMatrix();
                if (cargoItem.field_77994_a > 1) {
                    this.func_73731_b(this.mc.field_71466_p, cargoItem.field_77994_a + "", despX + 8, 8, 0xFFFFFF);
                }
                despX = (int)((float)despX + scale);
            }
            GL11.glTranslatef((float)0.0f, (float)16.0f, (float)0.0f);
        }
        if (ItemArmorHelmetScouter.target != null) {
            this.drawScouterInfo();
        }
        GL11.glPopMatrix();
    }

    public int drawScouterInfo() {
        int i;
        GL11.glPushMatrix();
        float scale = 1.0f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        this.xPos = 2;
        this.yPos = 2;
        this.mc.field_71446_o.func_110577_a(BDHelper.guiButtonsTexture);
        int iconBar = 25;
        for (i = 0; i < 4; ++i) {
            this.func_73729_b(this.xPos, this.yPos + 16 * i, iconBar % 16 * 16, iconBar / 16 * 16, 64, 16);
        }
        for (i = 0; i < 3; ++i) {
            this.drawIcon(iconBar + 4 + i, this.xPos, this.yPos + 16 * (i + 1));
        }
        int TEXT_OFFSET = 3;
        int xResist = this.xPos + 16;
        int yResist = this.yPos + 64;
        int icon = 9;
        this.drawIcon(icon + 1, this.xPos, yResist);
        this.drawIcon(icon + 2, this.xPos + 32, yResist);
        this.drawIcon(icon + 3, this.xPos, yResist + 16);
        this.drawIcon(icon + 4, this.xPos + 32, yResist + 16);
        this.drawIcon(icon + 5, this.xPos, yResist + 32);
        this.drawIcon(icon + 6, this.xPos + 32, yResist + 32);
        this.drawIcon(icon, xResist, yResist);
        this.drawIcon(icon, xResist + 32, yResist);
        this.drawIcon(icon, xResist, yResist + 16);
        this.drawIcon(icon, xResist + 32, yResist + 16);
        this.drawIcon(icon, xResist, yResist + 32);
        this.drawIcon(icon, xResist + 32, yResist + 32);
        EntityLivingBase el = ItemArmorHelmetScouter.target;
        String s = el.func_70005_c_();
        this.drawStat(s);
        this.drawStat("   " + this.toString(el.func_110143_aJ()) + "/" + this.toString(el.func_110138_aP()));
        double damage = 0.0;
        int baseDamage = 0;
        IAttributeInstance attribute = el.func_110148_a(SharedMonsterAttributes.field_111264_e);
        if (attribute != null) {
            damage = attribute.func_111126_e();
            baseDamage = (int)attribute.func_111125_b();
            ItemStack weapon = el.func_71124_b(0);
            if (weapon != null) {
                damage += BDHelper.getWeaponDamage(weapon);
            }
        }
        this.drawStat("   " + damage + " (" + baseDamage + ")");
        this.drawStat("     " + el.func_70658_aO());
        this.yPos += 16;
        int protection = this.getEnchantmentProtection(Enchantment.field_77332_c, el, this.physic);
        int fireProtection = this.getEnchantmentProtection(Enchantment.field_77329_d, el, this.fire);
        int projectileProtection = this.getEnchantmentProtection(Enchantment.field_77328_g, el, this.projectile);
        int blastProtection = this.getEnchantmentProtection(Enchantment.field_77327_f, el, this.blast);
        int magicProtection = this.getEnchantmentProtection(ChocolateQuest.enchantmentMagicDefense, el, this.magic);
        int physicProtection = 0;
        if (el instanceof IElementWeak) {
            projectileProtection += ((IElementWeak)el).getProjectileDefense();
            fireProtection += ((IElementWeak)el).getFireDefense();
            blastProtection += ((IElementWeak)el).getBlastDefense();
            magicProtection += ((IElementWeak)el).getMagicDefense();
            physicProtection += ((IElementWeak)el).getPhysicDefense();
        }
        String text = protection + "";
        this.func_73731_b(this.mc.field_71466_p, text, xResist + TEXT_OFFSET, yResist + TEXT_OFFSET, 0xFFFFFF);
        text = projectileProtection + "";
        this.func_73731_b(this.mc.field_71466_p, text, xResist + 32 + TEXT_OFFSET, yResist + TEXT_OFFSET, 0xFFFFFF);
        text = physicProtection + "";
        this.func_73731_b(this.mc.field_71466_p, text, xResist + TEXT_OFFSET, yResist + 16 + TEXT_OFFSET, 0xFFFFFF);
        text = fireProtection + "";
        this.func_73731_b(this.mc.field_71466_p, text, xResist + 32 + TEXT_OFFSET, yResist + 16 + TEXT_OFFSET, 0xFFFFFF);
        text = blastProtection + "";
        this.func_73731_b(this.mc.field_71466_p, text, xResist + TEXT_OFFSET, yResist + 32 + TEXT_OFFSET, 0xFFFFFF);
        text = magicProtection + "";
        this.func_73731_b(this.mc.field_71466_p, text, xResist + 32 + TEXT_OFFSET, yResist + 32 + TEXT_OFFSET, 0xFFFFFF);
        if (--ItemArmorHelmetScouter.targetTimer == 0) {
            ItemArmorHelmetScouter.target = null;
        }
        GL11.glPopMatrix();
        return 0;
    }

    public int getEnchantmentProtection(Enchantment enchantment, EntityLivingBase el, DamageSource ds) {
        int f = 0;
        for (int i = 1; i <= 4; ++i) {
            int lvl;
            ItemStack is = el.func_71124_b(i);
            if (is == null || (lvl = EnchantmentHelper.func_77506_a((int)enchantment.field_77352_x, (ItemStack)is)) <= 0) continue;
            f += enchantment.func_77318_a(lvl, ds);
        }
        return f;
    }

    public void drawIcon(int icon, int xPos, int yPos) {
        this.func_73729_b(xPos, yPos, icon % 16 * 16, icon / 16 * 16, 16, 16);
    }

    public void drawStat(String text) {
        if (text.length() > 14) {
            text = text.substring(0, 12);
        }
        this.func_73731_b(this.mc.field_71466_p, text, this.xPos + 3, this.yPos + 3, 0xFFFFFF);
        this.yPos += 16;
    }

    public String toString(double d) {
        String value = Double.toString(d);
        int index = value.indexOf(".");
        if (index < 3) {
            index += 2;
        }
        value = value.substring(0, index);
        return value;
    }
}

