/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.projectile;

import com.chocolate.chocolateQuest.entity.projectile.EntityBaseBall;
import com.chocolate.chocolateQuest.entity.projectile.ProjectileBase;
import com.chocolate.chocolateQuest.particles.EffectManager;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class ProjectileWindBall
extends ProjectileBase {
    int maxLifeTime = 80;
    Random rand = new Random();

    public ProjectileWindBall(EntityBaseBall entity) {
        super(entity);
    }

    @Override
    public int getTextureIndex() {
        return this.entity.field_70173_aa % 2 == 0 ? 235 : 236;
    }

    @Override
    public void onImpact(MovingObjectPosition par1MovingObjectPosition) {
        if (this.entity.field_70170_p.field_72995_K || par1MovingObjectPosition.field_72308_g instanceof EntityLivingBase) {
            // empty if block
        }
    }

    @Override
    public void onUpdateInAir() {
        if (this.entity.field_70173_aa % 30 == 0) {
            this.entity.field_70170_p.func_72956_a((Entity)this.entity, "chocolatequest:wind", 1.0f, 1.0f);
        }
        if (this.entity.field_70173_aa >= this.maxLifeTime) {
            this.entity.func_70106_y();
        }
        this.entity.field_70159_w *= 0.9;
        this.entity.field_70181_x *= 0.9;
        this.entity.field_70179_y *= 0.9;
        double dist = 5 + this.entity.getlvl();
        AxisAlignedBB var3 = this.entity.field_70121_D.func_72314_b(dist - 1.0, 2.0 + dist / 10.0, dist - 1.0);
        List list = this.entity.field_70170_p.func_72872_a(Entity.class, var3);
        for (Entity e : list) {
            if (e == this.entity || e == this.entity.func_85052_h()) continue;
            Vec3 d = Vec3.func_72443_a((double)(this.entity.field_70165_t - e.field_70165_t), (double)(this.entity.field_70163_u - e.field_70163_u), (double)(this.entity.field_70161_v - e.field_70161_v));
            double distToEntity = Math.max(15.0, (d.field_72450_a * d.field_72450_a + d.field_72449_c * d.field_72449_c) * 10.0);
            d.func_72432_b();
            double x = d.field_72450_a / distToEntity * dist / 5.0;
            double y = d.field_72448_b / Math.max(15.0, d.field_72448_b * d.field_72448_b * 10.0);
            double z = d.field_72449_c / distToEntity * dist / 5.0;
            if (this.rand.nextInt(10) == 0) {
                y += (dist - distToEntity) / 40.0;
            }
            if (e instanceof EntityLivingBase) {
                EntityLivingBase eLiving = (EntityLivingBase)e;
                ItemStack boots = eLiving.func_71124_b(1);
                boolean canBePushed = true;
                if (boots == null || boots.func_77973_b() != null) {
                    // empty if block
                }
                if (e.func_70104_M() && canBePushed) {
                    e.func_70024_g(x, y, z);
                }
                if (this.entity.func_70068_e(e) <= 3.0 && !this.entity.field_70170_p.field_72995_K) {
                    float damage = 1.0f * this.entity.getDamageMultiplier();
                    damage = this.entity.getElement().onHitEntity((Entity)this.entity.func_85052_h(), e, damage);
                    e.func_70097_a(this.entity.getElement().getDamageSourceIndirect((Entity)this.entity, (Entity)this.entity.func_85052_h()), damage);
                }
                e.field_70143_R = 0.0f;
                continue;
            }
            if (e instanceof EntityBaseBall && e != this.entity && ((EntityBaseBall)e).getType() == 10) {
                if (((EntityBaseBall)e).func_85052_h() != this.entity.func_85052_h()) {
                    if (this.entity.field_70170_p.field_72995_K || this.rand.nextInt(30) == 0) {
                        // empty if block
                    }
                    EntityLightningBolt lightning = new EntityLightningBolt(this.entity.field_70170_p, this.entity.field_70165_t, this.entity.field_70163_u - 1.0, this.entity.field_70161_v);
                    this.entity.field_70170_p.func_72838_d((Entity)lightning);
                    e.func_70024_g(x, y, z);
                    continue;
                }
                if (this.entity.field_70173_aa > e.field_70173_aa) {
                    this.entity.func_70106_y();
                    continue;
                }
                this.entity.field_70173_aa -= e.field_70173_aa / 2;
                continue;
            }
            e.func_70024_g(x, y, z);
        }
        if (this.entity.field_70170_p.field_72995_K) {
            Block id = this.entity.field_70170_p.func_147439_a((int)this.entity.field_70165_t, (int)this.entity.field_70163_u - 2, (int)this.entity.field_70161_v);
            if (id == Blocks.field_150350_a) {
                id = Blocks.field_150359_w;
            }
            for (int i = 0; i < 4; ++i) {
                EffectManager.spawnElementParticle(1, this.entity.field_70170_p, this.entity.field_70165_t + (double)this.rand.nextFloat() - 0.5, this.entity.field_70163_u + (double)this.rand.nextFloat() - 0.5, this.entity.field_70161_v + (double)this.rand.nextFloat() - 0.5, dist, 0.0, 0.0, this.entity.getElement());
                this.entity.field_70170_p.func_72869_a("blockcrack_" + Block.func_149682_b((Block)id) + "_" + 0, this.entity.field_70165_t + (double)this.rand.nextFloat() - 0.5, this.entity.field_70163_u + (double)this.rand.nextFloat() - 0.5, this.entity.field_70161_v + (double)this.rand.nextFloat() - 0.5, (double)(this.rand.nextFloat() - 0.5f), (double)(2.0f + this.rand.nextFloat() * 2.0f), (double)(this.rand.nextFloat() - 0.5f));
            }
        }
    }

    @Override
    public float getSize() {
        return 0.6f;
    }

    @Override
    public float getSizeBB() {
        return 0.01f;
    }

    @Override
    public boolean canBounce() {
        return false;
    }

    @Override
    public void onSpawn() {
        this.entity.setInmuneToFire(false);
    }

    @Override
    public boolean longRange() {
        return false;
    }
}

