/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.projectile;

import com.chocolate.chocolateQuest.entity.projectile.EntityBaseBall;
import com.chocolate.chocolateQuest.entity.projectile.ProjectileBase;
import com.chocolate.chocolateQuest.utils.HelperDamageSource;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;

public class ProjectileEarthQuakeArea
extends ProjectileBase {
    int lifeTime = 10;
    int deathTime = 100;
    Random rand = new Random();

    public ProjectileEarthQuakeArea(EntityBaseBall entity) {
        super(entity);
    }

    @Override
    public int getTextureIndex() {
        return -3;
    }

    @Override
    public void onImpact(MovingObjectPosition par1MovingObjectPosition) {
    }

    @Override
    public void onUpdateInAir() {
        ++this.lifeTime;
        if (this.lifeTime >= this.deathTime) {
            this.entity.func_70106_y();
        }
        double dist = (float)this.lifeTime / 10.0f;
        AxisAlignedBB var3 = this.entity.field_70121_D.func_72314_b(dist, 0.0, dist);
        List list = this.entity.field_70170_p.func_72872_a(EntityLivingBase.class, var3);
        for (Entity e : list) {
            if (!(e instanceof EntityLivingBase) || e == this.entity.func_85052_h() || (int)e.func_70032_d((Entity)this.entity) != this.lifeTime / 10 || !e.field_70122_E || this.entity.field_70170_p.field_72995_K) continue;
            e.func_70097_a(HelperDamageSource.causeIndirectMagicDamage((Entity)this.entity, (Entity)this.entity.func_85052_h()), 1.0f);
        }
        if (this.entity.field_70170_p.field_72995_K) {
            double x = Math.sin((float)this.lifeTime / 10.0f);
            double z = Math.cos((float)this.lifeTime / 10.0f);
            double step = 0.39269908169872414;
            for (int i = 0; i < 16; ++i) {
                x = Math.sin((double)((float)this.lifeTime / 10.0f) + step * (double)i) * (double)((float)this.lifeTime / 10.0f);
                z = Math.cos((double)((float)this.lifeTime / 10.0f) + step * (double)i) * (double)((float)this.lifeTime / 10.0f);
                int blockX = MathHelper.func_76128_c((double)(this.entity.field_70165_t + x));
                int blockY = MathHelper.func_76128_c((double)this.entity.field_70163_u) - 1;
                int blockZ = MathHelper.func_76128_c((double)(this.entity.field_70161_v + z));
                Block id = this.entity.field_70170_p.func_147439_a(blockX, blockY, blockZ);
                int md = this.entity.field_70170_p.func_72805_g(blockX, blockY, blockZ);
                if (id == null || id == Blocks.field_150350_a) {
                    id = Blocks.field_150359_w;
                }
                for (int a = 0; a < 5; ++a) {
                    this.entity.field_70170_p.func_72869_a("blockcrack_" + Block.func_149682_b((Block)id) + "_" + md, this.entity.field_70165_t + x, this.entity.field_70163_u - 0.5 + (double)this.rand.nextFloat() - 0.5, this.entity.field_70161_v + z, 0.0, 1.0, 0.0);
                }
            }
        }
        this.entity.field_70181_x = 0.0;
        this.entity.field_70179_y = 0.0;
        this.entity.field_70159_w = 0.0;
        if (!this.entity.field_70122_E) {
            if (this.entity.field_70170_p.func_147439_a((int)this.entity.field_70165_t, (int)this.entity.field_70163_u, (int)this.entity.field_70161_v) != Blocks.field_150350_a) {
                this.entity.field_70122_E = true;
            }
            this.entity.field_70181_x -= 0.1;
        }
    }

    @Override
    public float getSize() {
        return 0.1f;
    }

    @Override
    public boolean canBounce() {
        return false;
    }

    @Override
    public void onSpawn() {
        this.deathTime = 50 + this.entity.getlvl() * 50;
        this.entity.field_70163_u = this.entity.shootingEntity.field_70121_D.field_72338_b + 0.5;
        this.entity.setInmuneToFire(true);
    }

    @Override
    public boolean longRange() {
        return false;
    }
}

