/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.projectile;

import com.chocolate.chocolateQuest.magic.Elements;
import com.chocolate.chocolateQuest.particles.EffectManager;
import com.chocolate.chocolateQuest.utils.HelperPlayer;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityProjectileBeam
extends Entity
implements IEntityAdditionalSpawnData {
    Elements element;
    int elementID;
    EntityLivingBase mainBody;
    public float rotationYawOffset = 0.0f;
    public float distanceToMainBody = 0.0f;
    public float heightOffset = 0.0f;
    int ownerID = 0;
    public float maxRange = 16.0f;
    public float range = 16.0f;

    public EntityProjectileBeam(World world) {
        super(world);
        this.field_70178_ae = true;
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntityProjectileBeam(World world, EntityLivingBase main, float rotationYawOffset, float distanceToMainBody, Elements element) {
        this(world);
        this.rotationYawOffset = rotationYawOffset;
        this.distanceToMainBody = distanceToMainBody;
        if (main != null) {
            this.func_70107_b(main.field_70165_t, main.field_70163_u, main.field_70161_v);
        }
        this.mainBody = main;
        this.element = element;
        this.elementID = element.ordinal();
    }

    public EntityProjectileBeam(World world, EntityLivingBase main, float rotationYawOffset, float distanceToMainBody, float heightOffset, Elements element) {
        this(world, main, rotationYawOffset, distanceToMainBody, element);
        this.heightOffset = heightOffset;
    }

    public void func_70105_a(float par1, float par2) {
        super.func_70105_a(par1, par2);
    }

    public void func_70071_h_() {
        Elements element = this.getElement();
        super.func_70071_h_();
        if (this.mainBody != null) {
            double hx = -Math.sin(Math.toRadians(this.mainBody.field_70759_as + this.rotationYawOffset)) * (double)this.distanceToMainBody;
            double hz = Math.cos(Math.toRadians(this.mainBody.field_70759_as + this.rotationYawOffset)) * (double)this.distanceToMainBody;
            this.func_70080_a(this.mainBody.field_70165_t + hx + this.field_70159_w, this.mainBody.field_70163_u + (double)this.heightOffset + this.field_70181_x, this.mainBody.field_70161_v + hz + this.field_70179_y, this.mainBody.field_70759_as, this.mainBody.field_70125_A);
            if (this.mainBody instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)this.mainBody;
                if (!player.func_71039_bw()) {
                    this.func_70106_y();
                }
            } else if (this.field_70173_aa > 30) {
                this.func_70106_y();
            }
            EntityLivingBase shooter = this.mainBody;
            MovingObjectPosition mop = EntityProjectileBeam.getMovingObjectPositionFromPlayer(shooter, shooter.field_70170_p, this.maxRange, 0.0);
            if (mop != null) {
                double x = mop.field_72311_b;
                double y = mop.field_72312_c;
                double z = mop.field_72309_d;
                double dist = this.func_70011_f(x, y, z);
                this.range = (float)dist;
                if (mop.field_72308_g != null) {
                    float damage = 2.0f;
                    damage = element.onHitEntity((Entity)this.mainBody, mop.field_72308_g, damage);
                    mop.field_72308_g.func_70097_a(element.getDamageSource((Entity)this.mainBody).func_76349_b(), damage);
                }
                if (this.field_70170_p.field_72995_K) {
                    switch (mop.field_72310_e) {
                        case 2: {
                            x += 0.5;
                            break;
                        }
                        case 3: {
                            z += 1.5;
                            break;
                        }
                        case 4: {
                            x += -0.5;
                            break;
                        }
                        case 5: {
                            z += 0.5;
                            x += 1.2;
                        }
                    }
                    float s = 0.2f;
                    double ry = Math.cos(Math.toRadians(this.field_70125_A));
                    double rx = -Math.sin(Math.toRadians(this.field_70177_z)) * dist * ry;
                    double rz = Math.cos(Math.toRadians(this.field_70177_z)) * dist * ry;
                    ry = -Math.sin(Math.toRadians(this.field_70125_A)) * dist;
                    EffectManager.spawnElementParticle(0, this.field_70170_p, this.field_70165_t + rx, this.field_70163_u + ry, this.field_70161_v + rz, (this.field_70146_Z.nextFloat() - 0.5f) * s, 0.1, (this.field_70146_Z.nextFloat() - 0.5f) * s, element);
                }
            } else {
                this.range = this.maxRange;
            }
        } else {
            this.func_70106_y();
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    protected void func_70037_a(NBTTagCompound var1) {
        this.func_70106_y();
    }

    protected void func_70014_b(NBTTagCompound var1) {
    }

    public void readSpawnData(ByteBuf additionalData) {
        if (additionalData.readBoolean()) {
            return;
        }
        int id = additionalData.readInt();
        Entity e = this.field_70170_p.func_73045_a(id);
        if (e instanceof EntityLivingBase) {
            this.mainBody = (EntityLivingBase)e;
        }
        this.distanceToMainBody = additionalData.readFloat();
        this.rotationYawOffset = additionalData.readFloat();
        this.heightOffset = additionalData.readFloat();
        this.elementID = additionalData.readInt();
        this.maxRange = additionalData.readInt();
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.mainBody == null);
        if (this.mainBody != null) {
            buffer.writeInt(this.mainBody.func_145782_y());
            buffer.writeFloat(this.distanceToMainBody);
            buffer.writeFloat(this.rotationYawOffset);
            buffer.writeFloat(this.heightOffset);
            buffer.writeInt(this.elementID);
            buffer.writeInt((int)this.maxRange);
        }
    }

    protected void func_70088_a() {
    }

    public static MovingObjectPosition getMovingObjectPositionFromPlayer(EntityLivingBase ep, World world, double dist, double removeMe) {
        MovingObjectPosition mop = null;
        float yOffset = ep.func_70047_e();
        Vec3 playerPos = Vec3.func_72443_a((double)ep.field_70165_t, (double)(ep.field_70163_u + (double)yOffset), (double)ep.field_70161_v);
        Vec3 look = ep.func_70040_Z();
        mop = ep instanceof EntityPlayer ? HelperPlayer.getBlockMovingObjectPositionFromPlayer(world, ep, dist, true) : HelperPlayer.getBlockMovingObjectPositionFromPlayer(world, ep, dist, true);
        if (mop != null) {
            Vec3 v = Vec3.func_72443_a((double)(ep.field_70165_t - (double)mop.field_72311_b), (double)(ep.field_70163_u - (double)mop.field_72312_c), (double)(ep.field_70161_v - (double)mop.field_72309_d));
            dist = v.func_72433_c();
        }
        Vec3 playerView = playerPos.func_72441_c(look.field_72450_a * dist, look.field_72448_b * dist, look.field_72449_c * dist);
        List list = world.func_72839_b((Entity)ep, ep.field_70121_D.func_72321_a(ep.func_70040_Z().field_72450_a * dist, ep.func_70040_Z().field_72448_b * dist, ep.func_70040_Z().field_72449_c * dist).func_72314_b(1.0, 1.0, 1.0));
        MovingObjectPosition tempMop = null;
        double prevDist = dist * dist;
        for (int j = 0; j < list.size(); ++j) {
            Entity entity1 = (Entity)list.get(j);
            if (!entity1.func_70067_L() || entity1 == ep.field_70154_o || ep == ep.field_70153_n || !(entity1 instanceof EntityLivingBase)) continue;
            float f2 = 0.4f;
            AxisAlignedBB axisalignedbb = entity1.field_70121_D;
            MovingObjectPosition movingobjectposition1 = axisalignedbb.func_72327_a(playerPos, playerView);
            if (movingobjectposition1 == null) continue;
            movingobjectposition1.field_72308_g = entity1;
            movingobjectposition1.field_72311_b = MathHelper.func_76128_c((double)entity1.field_70165_t);
            movingobjectposition1.field_72312_c = MathHelper.func_76128_c((double)(entity1.field_70163_u + (double)(entity1.field_70131_O / 2.0f)));
            movingobjectposition1.field_72309_d = MathHelper.func_76128_c((double)entity1.field_70161_v);
            double entityDist = entity1.func_70068_e((Entity)ep);
            if (!(entityDist < prevDist)) continue;
            tempMop = movingobjectposition1;
            prevDist = entityDist;
        }
        if (tempMop != null) {
            return tempMop;
        }
        return mop;
    }

    public Elements getElement() {
        if (this.element == null) {
            this.element = Elements.values()[this.elementID];
        }
        return this.element;
    }
}

