/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.boss;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.ai.AIBossAttack;
import com.chocolate.chocolateQuest.entity.ai.AITargetHurtBy;
import com.chocolate.chocolateQuest.entity.boss.EntityBaseBoss;
import com.chocolate.chocolateQuest.entity.boss.EntityPart;
import com.chocolate.chocolateQuest.entity.boss.EntityTurtlePart;
import com.chocolate.chocolateQuest.entity.projectile.EntityBaseBall;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class EntityTurtle
extends EntityBaseBoss {
    private EntityTurtlePart[] body;
    double tempRYaw;
    double tempRPich;
    int rotAccel = 0;
    boolean rotDir = true;
    boolean bubbleAttack = false;
    int bubbleCD = 0;
    boolean hurt;
    int[] healPart;
    boolean hurtOnPartSoundFlag = false;
    double tempmx;
    double tempmz;
    double tempmy;

    public EntityTurtle(World par1World) {
        super(par1World);
        this.field_70728_aV = 5;
        this.body = new EntityTurtlePart[5];
        this.fireDefense = 20;
        this.blastDefense = 20;
        this.limitRotation = true;
    }

    @Override
    protected void scaleAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2 + (double)this.lvl * 0.005);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)(6.0f + this.lvl));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(400.0);
    }

    @Override
    public void addAITasks() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 1.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIBossAttack(this, 1.0f, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AITargetHurtBy(this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 0, true));
    }

    @Override
    public float getMinSize() {
        return 2.0f;
    }

    @Override
    public float getSizeVariation() {
        return 0.4f;
    }

    @Override
    protected void resize() {
        this.func_70105_a(this.size, this.size * 0.4f);
    }

    @Override
    public void initBody() {
        super.initBody();
        float dist = this.size - this.size / 4.0f;
        if (!this.field_70170_p.field_72995_K) {
            this.body[0] = new EntityTurtlePart(this.field_70170_p, 0, 0.0f, this.size - this.size / 3.0f, this.size / 10.0f);
            this.body[0].setMainBody(this);
            this.body[0].setHead();
            this.scalePart(this.body[0]);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)this.body[0]);
            }
            int[] pos = new int[]{45, -45, 135, -135};
            for (int i = 1; i <= 4; ++i) {
                this.body[i] = new EntityTurtlePart(this.field_70170_p, i, pos[i - 1], dist);
                this.body[i].setMainBody(this);
                this.body[i].func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)this.body[i]);
            }
        }
    }

    @Override
    protected boolean func_70650_aV() {
        return !this.isAttacking() && !this.isHealing();
    }

    public void func_70071_h_() {
        int i;
        if (!this.field_70170_p.field_72995_K && this.func_110143_aJ() < 50.0f && !this.isHealing() && this.body[0] != null) {
            for (i = 0; i < 5; ++i) {
                if (this.body[i] == null) continue;
                this.body[i].setHeartsLife(this.body[i].getMaxHealth());
            }
            this.setHealing(true);
        }
        for (i = 0; i < this.body.length; ++i) {
            if (this.body[i] == null || this.body[i].func_70089_S()) continue;
            this.body[i] = null;
        }
        if (this.isHealing()) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72869_a("heart", this.field_70165_t + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.field_70163_u + 1.0 + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v + this.field_70146_Z.nextDouble() * 2.0 - 1.0, 0.0, 1.0, 0.0);
            }
            this.func_70691_i(1.0f);
            if (this.func_110143_aJ() >= this.func_110138_aP()) {
                this.setHealing(false);
            }
        }
        if (this.func_70638_az() != null) {
            if (this.field_70171_ac || this.func_70058_J()) {
                if (this.field_70163_u + 3.0 < this.func_70638_az().field_70163_u && this.field_70181_x < 0.2) {
                    this.field_70181_x += 0.03;
                } else if (this.field_70163_u + 3.0 > this.func_70638_az().field_70163_u && this.field_70181_x > -0.2) {
                    this.field_70181_x -= 0.03;
                }
            }
        } else if (this.field_70171_ac && this.field_70181_x < 0.1) {
            this.field_70181_x -= 0.03;
        }
        super.func_70071_h_();
        if (this.isAttacking()) {
            this.doAttack();
        }
        if (this.bubbleAttack) {
            this.bubbleRay();
        }
        if (this.isAttacking() || this.isHealing()) {
            this.hidePartsInShell();
            this.hideHeadInShell();
        } else {
            for (i = 0; i < 5; ++i) {
                if (this.body[i] == null) continue;
                this.body[i].staticPart = true;
            }
        }
    }

    private void hidePartsInShell() {
        for (int i = 1; i < 5; ++i) {
            if (this.body[i] == null) continue;
            this.body[i].staticPart = false;
            this.body[i].func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    private void hideHeadInShell() {
        if (this.body[0] != null) {
            this.body[0].staticPart = false;
            this.body[0].func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    @Override
    public void func_70785_a(Entity entity, float f) {
        if (!(this.isAttacking() || this.bubbleAttack || this.isHealing())) {
            float width = this.size * 0.3f;
            int attackChance = (int)(f - (width = width * width + this.field_70130_N * this.field_70130_N) - entity.field_70130_N * entity.field_70130_N);
            int n = attackChance < 40 ? 40 : (attackChance = attackChance > 80 ? 80 : attackChance);
            if (this.field_70146_Z.nextInt(attackChance) == 0) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.setAttacking(true);
                    this.rotDir = true;
                } else {
                    double d = this.field_70165_t - entity.field_70165_t;
                    double d1 = this.field_70163_u - (entity.field_70163_u + (double)(entity.field_70131_O / 2.0f));
                    double d2 = this.field_70161_v - entity.field_70161_v;
                    float angle = (float)Math.atan2(d, d2);
                    for (angle = this.field_70177_z - entity.field_70177_z; angle > 360.0f; angle -= 360.0f) {
                    }
                    while (angle < 0.0f) {
                        angle += 360.0f;
                    }
                    if ((angle = Math.abs(angle - 180.0f)) < 60.0f) {
                        this.startBubble();
                    }
                }
            }
        }
    }

    @Override
    protected boolean limitRotation() {
        return !this.isAttacking();
    }

    public void doAttack() {
        if (this.func_70638_az() == null) {
            return;
        }
        if (this.rotDir) {
            ++this.rotAccel;
        } else {
            --this.rotAccel;
            if (this.rotAccel > 80) {
                this.field_70159_w = this.tempmx;
                this.field_70179_y = this.tempmz;
                this.field_70181_x = this.tempmy;
            }
        }
        this.field_70177_z += (float)(this.rotAccel / 2);
        if (this.rotAccel >= 100) {
            this.rotDir = false;
        }
        if (this.rotAccel == 50 && this.func_110143_aJ() < 200.0f) {
            this.startBubble();
        }
        if (this.rotAccel == 80) {
            EntityLivingBase e = this.func_70638_az();
            double px = this.field_70165_t - e.field_70165_t;
            double pz = this.field_70161_v - e.field_70161_v;
            double py = this.field_70163_u - (e.field_70163_u + (double)(e.field_70131_O / 2.0f));
            this.tempRYaw = Math.atan2(px, pz);
            this.tempRPich = Math.atan2(py, MathHelper.func_76133_a((double)(px * px + pz * pz)));
            this.tempmy = -Math.sin(this.tempRPich);
            this.tempmx = -Math.sin(this.tempRYaw);
            this.tempmz = -Math.cos(this.tempRYaw);
        }
        if (this.rotAccel >= 20) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(1.0, 1.0, 1.0));
            double d = 0.0;
            for (int j = 0; j < list.size(); ++j) {
                Entity entity1 = (Entity)list.get(j);
                if (!entity1.func_70067_L() || entity1.func_70028_i((Entity)this) || entity1 == this.field_70153_n) continue;
                AxisAlignedBB axisalignedbb = entity1.field_70121_D;
                this.func_70652_k(entity1);
            }
        }
        if (this.rotAccel == 0) {
            this.setAttacking(false);
        }
    }

    public void startBubble() {
        EntityLivingBase e = this.func_70638_az();
        double px = this.field_70165_t - e.field_70165_t;
        double pz = this.field_70161_v - e.field_70161_v;
        double py = this.field_70163_u - e.field_70163_u;
        this.tempRYaw = Math.atan2(px, pz);
        this.tempRPich = Math.atan2(py, MathHelper.func_76133_a((double)(px * px + pz * pz)));
        this.tempmy = -Math.sin(this.tempRPich);
        this.tempmx = -Math.sin(this.tempRYaw);
        this.tempmz = -Math.cos(this.tempRYaw);
        this.bubbleAttack = true;
    }

    public void bubbleRay() {
        if (this.bubbleCD >= 20) {
            this.bubbleCD = 0;
            this.field_70170_p.func_72838_d((Entity)new EntityBaseBall(this.field_70170_p, (EntityLivingBase)this, 7));
            this.bubbleAttack = false;
            this.bubbleCD = 0;
            if (!this.isAttacking() && this.field_70146_Z.nextInt(3) == 0) {
                this.bubbleAttack = true;
            }
        } else {
            ++this.bubbleCD;
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        boolean flag = super.func_70097_a(par1DamageSource, par2);
        if (this.body != null) {
            for (int i = 0; i < 5; ++i) {
                if (this.body[i] != null) {
                    if (!this.body[i].field_70128_L) continue;
                    this.hurt = true;
                    this.body[i] = null;
                    continue;
                }
                this.hurt = true;
            }
        }
        return flag;
    }

    @Override
    public boolean attackFromPart(DamageSource par1DamageSource, float par2, EntityPart part) {
        this.hurtOnPartSoundFlag = true;
        return this.func_70097_a(par1DamageSource, par2);
    }

    public int func_70658_aO() {
        return 0;
    }

    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        if (!this.field_70170_p.field_72995_K) {
            int scalesDropped = 2;
            int partsLeft = 0;
            if (this.body[0] == null) {
                scalesDropped += 6;
                ++partsLeft;
            }
            for (int k = 1; k < this.body.length; ++k) {
                if (this.body[k] != null) continue;
                scalesDropped += 4;
                ++partsLeft;
            }
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(ChocolateQuest.material, scalesDropped, 1)));
        }
        if (flag && (this.field_70146_Z.nextInt(5) == 0 || this.field_70146_Z.nextInt(1 + i) > 0)) {
            this.func_145779_a(Items.field_151045_i, 2);
        }
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70028_i(Entity par1Entity) {
        boolean flag = false;
        if (this.body != null) {
            for (int i = 0; i < this.body.length && !flag; ++i) {
                flag = this.body[i] == par1Entity;
            }
        }
        return this == par1Entity || flag;
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected boolean isValidLightLevel() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72972_b(EnumSkyBlock.Sky, i, j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v)) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int l = this.field_70170_p.func_72957_l(i, j, k);
        if (this.field_70170_p.func_72911_I()) {
            int i1 = this.field_70170_p.field_73008_k;
            this.field_70170_p.field_73008_k = 10;
            l = this.field_70170_p.func_72957_l(i, j, k);
            this.field_70170_p.field_73008_k = i1;
        }
        return l <= this.field_70146_Z.nextInt(8);
    }

    protected String func_70621_aR() {
        if (this.hurtOnPartSoundFlag) {
            this.hurtOnPartSoundFlag = false;
            return super.func_70621_aR();
        }
        return "mob.blaze.hit";
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    public boolean isHealing() {
        return this.field_70180_af.func_75683_a(16) == 0;
    }

    public void setHealing(boolean healing) {
        this.field_70180_af.func_75692_b(16, (Object)(healing ? Byte.valueOf((byte)0) : Byte.valueOf((byte)1)));
    }

    @Override
    public void setPart(EntityPart entityTurtlePart, int partID) {
        this.body[partID] = (EntityTurtlePart)entityTurtlePart;
        this.scalePart(entityTurtlePart);
    }

    protected void scalePart(EntityPart part) {
        float scale = this.size * 0.3f;
        part.func_70105_a(scale, scale);
        part.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public boolean shouldMoveToEntity(double d1, Entity target) {
        return !this.isAttacking();
    }

    public EntityTurtlePart[] getBossParts() {
        return this.body;
    }
}

