/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.DummyChocolate;
import com.chocolate.chocolateQuest.entity.EntityReferee;
import com.chocolate.chocolateQuest.entity.ai.AIAnimalMountedByEntity;
import com.chocolate.chocolateQuest.entity.ai.AIControlledFollowOwner;
import com.chocolate.chocolateQuest.entity.ai.AIControlledFormation;
import com.chocolate.chocolateQuest.entity.ai.AIControlledPath;
import com.chocolate.chocolateQuest.entity.ai.AIControlledSit;
import com.chocolate.chocolateQuest.entity.ai.AIControlledWardPosition;
import com.chocolate.chocolateQuest.entity.ai.AIHumanAttackAggressive;
import com.chocolate.chocolateQuest.entity.ai.AIHumanAttackAggressiveBackstab;
import com.chocolate.chocolateQuest.entity.ai.AIHumanAttackDefensive;
import com.chocolate.chocolateQuest.entity.ai.AIHumanAttackEvasive;
import com.chocolate.chocolateQuest.entity.ai.AIHumanAttackHeal;
import com.chocolate.chocolateQuest.entity.ai.AIHumanFlee;
import com.chocolate.chocolateQuest.entity.ai.AIHumanGoToPoint;
import com.chocolate.chocolateQuest.entity.ai.AIHumanIdleSit;
import com.chocolate.chocolateQuest.entity.ai.AIHumanIdleTalkClosest;
import com.chocolate.chocolateQuest.entity.ai.AIHumanMount;
import com.chocolate.chocolateQuest.entity.ai.AIHumanPotion;
import com.chocolate.chocolateQuest.entity.ai.AITargetNearestHurtAlly;
import com.chocolate.chocolateQuest.entity.ai.AITargetOwner;
import com.chocolate.chocolateQuest.entity.ai.AITargetParty;
import com.chocolate.chocolateQuest.entity.ai.EntityParty;
import com.chocolate.chocolateQuest.entity.ai.EnumAiCombat;
import com.chocolate.chocolateQuest.entity.ai.EnumAiState;
import com.chocolate.chocolateQuest.entity.ai.HumanSelector;
import com.chocolate.chocolateQuest.entity.handHelper.HandEmpty;
import com.chocolate.chocolateQuest.entity.handHelper.HandHelper;
import com.chocolate.chocolateQuest.items.ItemArmorBase;
import com.chocolate.chocolateQuest.items.mobControl.ItemController;
import com.chocolate.chocolateQuest.items.swords.ItemBaseDagger;
import com.chocolate.chocolateQuest.items.swords.ItemBaseSpear;
import com.chocolate.chocolateQuest.magic.ElementsHelper;
import com.chocolate.chocolateQuest.magic.IElementWeak;
import com.chocolate.chocolateQuest.packets.PacketEntityAnimation;
import com.chocolate.chocolateQuest.packets.PacketSpawnParticlesAround;
import com.chocolate.chocolateQuest.packets.PacketUpdateHumanData;
import com.chocolate.chocolateQuest.utils.BDHelper;
import com.chocolate.chocolateQuest.utils.MobTeam;
import com.chocolate.chocolateQuest.utils.Vec4I;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.command.IEntitySelector;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityHumanBase
extends EntityCreature
implements IEntityAdditionalSpawnData,
IEntityOwnable,
IElementWeak {
    public static final byte ANIM = 16;
    public static final byte HUMAN = 0;
    public static final byte ORC = 1;
    public static final byte GOBLIN = 2;
    public static final byte DWARF = 3;
    public static final byte TRITON = 4;
    public int maxStamina = 60;
    private float randomHeightVariation;
    public int leftHandSwing = 0;
    public float moveForwardHuman = 0.0f;
    protected int sprintTime;
    protected int exhaustion;
    public int potionCount = 1;
    public ItemStack leftHandItem;
    public float leftHandDropChances = 0.0f;
    public short parryRate = 0;
    public short blockRate = 0;
    protected final float shiedBlockDefense = 0.8f;
    public float accuracy;
    public String entityTeam = "npc";
    public int shieldID = 0;
    protected String ownerName;
    private EntityLivingBase owner;
    public EntityParty party;
    public int partyPositionAngle;
    public int partyDistanceToLeader = 2;
    public boolean partyPositionPersistance = false;
    public boolean addedToParty = false;
    protected EntityAIBase attackAI;
    protected EntityAIBase controlledAI;
    protected EntityAIBase supportAI;
    protected EntityAIBase supportAITarget;
    public int AIMode = EnumAiState.FORMATION.ordinal();
    public int AICombatMode = EnumAiCombat.OFFENSIVE.ordinal();
    public Vec4I currentPos;
    public Vec4I standingPosition;
    public Vec4I[] path;
    public HandHelper leftHand;
    public HandHelper rightHand;
    private static final AttributeModifier slowDownModifier = new AttributeModifier("Human speed mod", -0.2, 1).func_111168_a(false);
    public EntityPlayer playerSpeakingTo;
    public boolean updateOwner = false;
    protected int physicDefense = 0;
    protected int magicDefense = 0;
    protected int blastDefense = 0;
    protected int fireDefense = 0;
    protected int projectileDefense = 0;

    public EntityHumanBase(World world) {
        super(world);
        this.addAITasks();
        this.field_70138_W = 1.0f;
        this.updateHands();
        for (int i = 0; i < this.field_82174_bp.length; ++i) {
            this.field_82174_bp[i] = 0.0f;
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_70105_a(0.6f, 1.8f);
        this.randomHeightVariation = 1.0f + (this.field_70146_Z.nextFloat() - 0.6f) / 5.0f;
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected void addAITasks() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIHumanPotion(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIHumanGoToPoint(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIHumanMount(this, 1.0f, false));
        this.setAIForCurrentMode();
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AIHumanIdleTalkClosest(this, EntityHumanBase.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIHumanIdleSit(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AITargetParty(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new AITargetOwner(this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, (IEntitySelector)new HumanSelector(this)));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityHumanBase.class, 0, true, false, (IEntitySelector)new HumanSelector(this)));
    }

    public void updateHands() {
        this.rightHand = HandHelper.getHandHelperForItem(this, this.func_71124_b(0));
        this.leftHand = HandHelper.getHandHelperForItem(this, this.getLeftHandItem());
        if (this.rightHand instanceof HandEmpty) {
            this.rightHand = new HandHelper(this, null);
        }
    }

    public void setAIForCurrentMode() {
        this.updateHands();
        if (this.supportAI != null) {
            this.field_70714_bg.func_85156_a(this.supportAI);
            this.field_70715_bh.func_85156_a(this.supportAITarget);
        }
        if (this.isHealer()) {
            this.supportAI = new AIHumanAttackHeal(this, 1.0f, false);
            this.field_70714_bg.func_75776_a(2, this.supportAI);
            this.supportAITarget = new AITargetNearestHurtAlly(this, EntityLivingBase.class);
            this.field_70715_bh.func_75776_a(0, this.supportAITarget);
        }
        if (this.controlledAI != null) {
            this.field_70714_bg.func_85156_a(this.controlledAI);
        }
        int priority = 4;
        if (this.AIMode == EnumAiState.FOLLOW.ordinal()) {
            this.controlledAI = new AIControlledFollowOwner(this, 8.0f, 50.0f);
        } else if (this.AIMode == EnumAiState.FORMATION.ordinal()) {
            this.controlledAI = new AIControlledFormation(this);
        } else if (this.AIMode == EnumAiState.PATH.ordinal()) {
            this.controlledAI = new AIControlledPath(this);
        } else if (this.AIMode == EnumAiState.WARD.ordinal()) {
            this.controlledAI = new AIControlledWardPosition(this);
        } else if (this.AIMode == EnumAiState.SIT.ordinal()) {
            this.controlledAI = new AIControlledSit(this);
            priority = 2;
        }
        if (this.controlledAI != null) {
            this.field_70714_bg.func_75776_a(priority, this.controlledAI);
        }
        if (this.attackAI != null) {
            this.field_70714_bg.func_85156_a(this.attackAI);
        }
        if (this.AICombatMode == EnumAiCombat.OFFENSIVE.ordinal()) {
            this.attackAI = new AIHumanAttackAggressive(this, EntityLivingBase.class, 1.0f, false);
        } else if (this.AICombatMode == EnumAiCombat.DEFENSIVE.ordinal()) {
            this.attackAI = new AIHumanAttackDefensive(this, 1.0f);
        } else if (this.AICombatMode == EnumAiCombat.EVASIVE.ordinal()) {
            this.attackAI = new AIHumanAttackEvasive(this, 1.0f);
        } else if (this.AICombatMode == EnumAiCombat.FLEE.ordinal()) {
            this.attackAI = new AIHumanFlee(this, 1.0f);
        } else if (this.AICombatMode == EnumAiCombat.BACKSTAB.ordinal()) {
            this.attackAI = new AIHumanAttackAggressiveBackstab(this, 1.0f, false);
        }
        if (this.attackAI != null) {
            this.field_70714_bg.func_75776_a(3, this.attackAI);
        }
    }

    public void func_70636_d() {
        if (this.party != null && this.party.getLeader() == this) {
            this.party.update();
        }
        if (this.haveShied()) {
            IAttributeInstance attributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            attributeinstance.func_111124_b(slowDownModifier);
            if (this.isDefending()) {
                attributeinstance.func_111121_a(slowDownModifier);
            }
        }
        if (this.func_70051_ag()) {
            --this.sprintTime;
            if (this.sprintTime <= 0) {
                this.func_70031_b(false);
            }
            this.exhaustion = 20;
        } else if (this.exhaustion > 0) {
            --this.exhaustion;
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack is = this.func_71124_b(i + 1);
            if (is == null || !(is.func_77973_b() instanceof ItemArmorBase)) continue;
            ((ItemArmorBase)is.func_77973_b()).onUpdateEquiped(is, this.field_70170_p, (EntityLivingBase)this);
        }
        this.rightHand.onUpdate();
        this.leftHand.onUpdate();
        this.func_82168_bl();
        super.func_70636_d();
    }

    protected void func_82168_bl() {
        super.func_82168_bl();
        if (this.leftHandSwing > 0) {
            --this.leftHandSwing;
        }
    }

    public void swingLeftHand() {
        if (this.leftHandSwing <= 0) {
            this.leftHandSwing = 10;
            if (this.field_70170_p instanceof WorldServer) {
                PacketEntityAnimation packet = new PacketEntityAnimation(this.func_145782_y(), 1);
                ChocolateQuest.channel.sendToAllAround((Entity)this, packet);
            }
        }
    }

    public void swingHand(HandHelper hand) {
        if (hand == this.rightHand) {
            this.func_71038_i();
        } else {
            this.swingLeftHand();
        }
    }

    public boolean isSwingInProgress(HandHelper hand) {
        if (hand == this.rightHand) {
            return this.field_82175_bq;
        }
        return this.leftHandSwing > 0;
    }

    public void setAiming(HandHelper hand, boolean aiming) {
        if (hand.isAiming() != aiming) {
            if (hand == this.rightHand) {
                this.toogleAimRight();
            } else {
                this.toogleAimLeft();
            }
        }
    }

    public boolean isAiming() {
        return this.rightHand.isAiming() || this.leftHand.isAiming();
    }

    public void stopAiming() {
        if (this.rightHand.isAiming()) {
            this.toogleAimRight();
        }
        if (this.leftHand.isAiming()) {
            this.toogleAimLeft();
        }
    }

    public void toogleAimRight() {
        this.rightHand.setAiming(!this.rightHand.isAiming());
        if (this.field_70170_p instanceof WorldServer) {
            PacketEntityAnimation packet = new PacketEntityAnimation(this.func_145782_y(), 2);
            ChocolateQuest.channel.sendToAllAround((Entity)this, packet);
        }
    }

    public void toogleAimLeft() {
        this.leftHand.setAiming(!this.leftHand.isAiming());
        if (this.field_70170_p instanceof WorldServer) {
            PacketEntityAnimation packet = new PacketEntityAnimation(this.func_145782_y(), 3);
            ChocolateQuest.channel.sendToAllAround((Entity)this, packet);
        }
    }

    public boolean func_70039_c(NBTTagCompound nbttagcompound) {
        if (this.party != null && !this.writePartyToNBT(nbttagcompound)) {
            return false;
        }
        return super.func_70039_c(nbttagcompound);
    }

    public boolean writePartyToNBT(NBTTagCompound nbttagcompound) {
        if (this.party != null && this.party.getLeader().func_70028_i((Entity)this)) {
            this.party.saveToNBT(nbttagcompound);
            return true;
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74768_a("PotionCount", this.potionCount);
        if (this.getLeftHandItem() != null) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            nbttagcompound.func_74782_a("leftHand", (NBTBase)this.getLeftHandItem().func_77955_b(itemNBT));
        }
        nbttagcompound.func_74776_a("dropLeft", this.leftHandDropChances);
        if (this.owner instanceof EntityPlayer) {
            nbttagcompound.func_74778_a("ownerName", this.ownerName);
        } else if (this.ownerName != null) {
            nbttagcompound.func_74778_a("ownerName", this.ownerName);
        }
        nbttagcompound.func_74778_a("team", this.entityTeam);
        if (this.partyPositionPersistance) {
            nbttagcompound.func_74768_a("leaderDist", this.partyDistanceToLeader);
            nbttagcompound.func_74768_a("partyPos", this.partyPositionAngle);
        }
        nbttagcompound.func_74768_a("AIMode", this.AIMode);
        if (this.standingPosition != null) {
            nbttagcompound.func_74757_a("standing", true);
            nbttagcompound.func_74768_a("standX", this.standingPosition.xCoord);
            nbttagcompound.func_74768_a("standY", this.standingPosition.yCoord);
            nbttagcompound.func_74768_a("standZ", this.standingPosition.zCoord);
            nbttagcompound.func_74768_a("standRotation", this.standingPosition.rot);
        }
        if (this.path != null) {
            nbttagcompound.func_74768_a("pathPoints", this.path.length);
            for (int p = 0; p < this.path.length; ++p) {
                nbttagcompound.func_74768_a("pathX" + p, this.path[p].xCoord);
                nbttagcompound.func_74768_a("pathY" + p, this.path[p].yCoord);
                nbttagcompound.func_74768_a("pathZ" + p, this.path[p].zCoord);
            }
        }
        nbttagcompound.func_74768_a("AIMode", this.AIMode);
        nbttagcompound.func_74768_a("AICombat", this.AICombatMode);
        nbttagcompound.func_74757_a("addedToParty", this.addedToParty);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        int points;
        super.func_70037_a(nbttagcompound);
        this.potionCount = nbttagcompound.func_74762_e("PotionCount");
        this.leftHandDropChances = nbttagcompound.func_74760_g("dropLeft");
        NBTTagCompound item = (NBTTagCompound)nbttagcompound.func_74781_a("leftHand");
        this.leftHandItem = item != null ? ItemStack.func_77949_a((NBTTagCompound)item) : null;
        this.ownerName = nbttagcompound.func_74779_i("ownerName");
        this.entityTeam = nbttagcompound.func_74779_i("team");
        if (this.ownerName == "") {
            this.ownerName = null;
        }
        if (this.ownerName != null) {
            this.setOwner((EntityLivingBase)this.field_70170_p.func_72924_a(this.ownerName));
        }
        if (nbttagcompound.func_74764_b("leaderDist")) {
            this.partyPositionPersistance = true;
            this.partyDistanceToLeader = nbttagcompound.func_74762_e("leaderDist");
            this.partyPositionAngle = nbttagcompound.func_74762_e("partyPos");
        }
        this.AIMode = nbttagcompound.func_74762_e("AIMode");
        if (nbttagcompound.func_74767_n("standing")) {
            int x = nbttagcompound.func_74762_e("standX");
            int y = nbttagcompound.func_74762_e("standY");
            int z = nbttagcompound.func_74762_e("standZ");
            int rotY = nbttagcompound.func_74762_e("standRotation");
            this.standingPosition = new Vec4I(x, y, z, rotY);
        }
        if ((points = nbttagcompound.func_74762_e("pathPoints")) > 0) {
            this.path = new Vec4I[points];
            for (int p = 0; p < points; ++p) {
                this.path[p] = new Vec4I(nbttagcompound.func_74762_e("pathX" + p), nbttagcompound.func_74762_e("pathY" + p), nbttagcompound.func_74762_e("pathZ" + p), 0);
            }
        }
        if (nbttagcompound.func_74764_b("AIMode")) {
            this.AIMode = nbttagcompound.func_74762_e("AIMode");
        }
        if (nbttagcompound.func_74764_b("AICombat")) {
            this.AICombatMode = nbttagcompound.func_74762_e("AICombat");
        }
        this.setAIForCurrentMode();
        if (nbttagcompound.func_74781_a("Party") != null && this.party == null) {
            this.party = new EntityParty();
            this.party.tryToAddNewMember(this);
            this.party.readFromNBT(nbttagcompound);
        }
        this.addedToParty = nbttagcompound.func_74767_n("addedToParty");
    }

    public void writeEntityToSpawnerNBT(NBTTagCompound nbttagcompound, int spawnerX, int spawnerY, int spawnerZ) {
        this.writePartyToNBT(nbttagcompound);
        Vec4I currentStand = this.standingPosition;
        Vec4I[] currentPath = this.path;
        double tempPosX = this.field_70165_t;
        double tempPosY = this.field_70163_u;
        double tempPosZ = this.field_70161_v;
        this.field_70165_t -= (double)spawnerX;
        this.field_70163_u -= (double)spawnerY;
        this.field_70161_v -= (double)spawnerZ;
        if (this.standingPosition != null) {
            this.standingPosition = new Vec4I(currentStand.xCoord - spawnerX, currentStand.yCoord - spawnerY, currentStand.zCoord - spawnerZ, currentStand.rot);
        }
        if (this.path != null) {
            this.path = new Vec4I[this.path.length];
            for (int p = 0; p < this.path.length; ++p) {
                this.path[p] = new Vec4I(currentPath[p].xCoord - spawnerX, currentPath[p].yCoord - spawnerY, currentPath[p].zCoord - spawnerZ, currentPath[p].rot);
            }
        }
        this.func_70014_b(nbttagcompound);
        if (this.field_70154_o != null) {
            this.func_98035_c(nbttagcompound);
        }
        this.field_70165_t += (double)spawnerX;
        this.field_70163_u += (double)spawnerY;
        this.field_70161_v += (double)spawnerZ;
        this.standingPosition = currentStand;
        this.path = currentPath;
        this.saveMappingsToNBT(nbttagcompound);
    }

    public void saveMappingsToNBT(NBTTagCompound nbttagcompound) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < 5; ++i) {
            String s = "";
            if (this.func_71124_b(i) != null) {
                s = Item.field_150901_e.func_148750_c((Object)this.func_71124_b(i).func_77973_b());
            }
            list.func_74742_a((NBTBase)new NBTTagString(s));
        }
        String s = "";
        if (this.getLeftHandItem() != null) {
            s = Item.field_150901_e.func_148750_c((Object)this.getLeftHandItem().func_77973_b());
        }
        list.func_74742_a((NBTBase)new NBTTagString(s));
        nbttagcompound.func_74782_a("EquipementMap", (NBTBase)list);
    }

    public void readEntityFromSpawnerNBT(NBTTagCompound nbttagcompound, int spawnerX, int spawnerY, int spawnerZ) {
        NBTBase equipementTag;
        NBTBase equipementMap = nbttagcompound.func_74781_a("EquipementMap");
        if (equipementMap != null && (equipementTag = nbttagcompound.func_74781_a("Equipment")) != null) {
            Item item;
            short id;
            NBTTagList list = (NBTTagList)equipementTag;
            NBTTagList listMap = (NBTTagList)equipementMap;
            for (int i = 0; i < list.func_74745_c(); ++i) {
                Item item2;
                short id2 = list.func_150305_b(i).func_74765_d("id");
                if (id2 == 0 || (item2 = (Item)Item.field_150901_e.func_82594_a(listMap.func_150307_f(i))) == null) continue;
                short newID = (short)Item.func_150891_b((Item)item2);
                list.func_150305_b(i).func_74777_a("id", newID);
            }
            int LEFT_HAND = 5;
            NBTTagCompound itemNBT = (NBTTagCompound)nbttagcompound.func_74781_a("leftHand");
            if (itemNBT != null && (id = itemNBT.func_74765_d("id")) != 0 && (item = (Item)Item.field_150901_e.func_82594_a(listMap.func_150307_f(5))) != null) {
                short newID = (short)Item.func_150891_b((Item)item);
                itemNBT.func_74777_a("id", newID);
            }
        }
        this.func_70020_e(nbttagcompound);
        if (this.standingPosition != null) {
            Vec4I current = this.standingPosition;
            this.standingPosition = new Vec4I(current.xCoord + spawnerX, current.yCoord + spawnerY, current.zCoord + spawnerZ, current.rot);
        }
        if (this.path != null) {
            for (int p = 0; p < this.path.length; ++p) {
                Vec4I current = this.path[p];
                this.path[p] = new Vec4I(current.xCoord + spawnerX, current.yCoord + spawnerY, current.zCoord + spawnerZ, current.rot);
            }
        }
        this.field_70165_t += (double)spawnerX;
        this.field_70163_u += (double)spawnerY;
        this.field_70161_v += (double)spawnerZ;
    }

    public void func_70624_b(EntityLivingBase par1EntityLivingBase) {
        if (par1EntityLivingBase != null) {
            if (!this.func_142014_c(par1EntityLivingBase)) {
                if (this.party != null) {
                    this.party.addAggroToTarget(par1EntityLivingBase, 1);
                }
            } else if (!this.isHealer()) {
                return;
            }
        }
        super.func_70624_b(par1EntityLivingBase);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_70623_bb() {
        super.func_70623_bb();
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEFINED;
    }

    public double func_70042_X() {
        if (this.field_70154_o instanceof EntityHorse) {
            return -0.4;
        }
        return super.func_70042_X();
    }

    public ItemStack getLeftHandItem() {
        return this.leftHandItem;
    }

    public void setLeftHandItem(ItemStack is) {
        this.leftHandItem = is;
    }

    public void func_70612_e(float par1, float par2) {
        if (this.moveForwardHuman != 0.0f) {
            par2 = this.moveForwardHuman;
        }
        super.func_70612_e(par1, par2);
    }

    public float getSizeModifier() {
        return this.randomHeightVariation;
    }

    public boolean func_70097_a(DamageSource damagesource, float damage) {
        boolean rangedAttack = damagesource.func_76352_a();
        damage = ElementsHelper.getAmmountDecreased(this, damage, damagesource);
        if (this.isDefending()) {
            double angle = 0.0;
            if (damagesource.func_76346_g() != null) {
                for (angle = (double)(damagesource.func_76346_g().field_70177_z - this.field_70177_z); angle > 360.0; angle -= 360.0) {
                }
                while (angle < 0.0) {
                    angle += 360.0;
                }
                angle = Math.abs(angle - 180.0);
            }
            if (!damagesource.func_76363_c() && angle < 120.0) {
                if (this.field_70737_aN == 0) {
                    this.field_70170_p.func_72956_a((Entity)this, "mob.blaze.hit", 1.0f, 1.0f);
                }
                if (damagesource.func_76352_a()) {
                    return true;
                }
                if (this.field_70146_Z.nextInt(100) < this.blockRate) {
                    if (this.field_70146_Z.nextInt(100) < this.parryRate && !damagesource.func_76352_a() && !damagesource.func_94541_c() && damagesource.func_76346_g() instanceof EntityLivingBase && !rangedAttack) {
                        this.func_70652_k(damagesource.func_76346_g());
                        this.swingLeftHand();
                    }
                    this.field_70737_aN = 10;
                    return false;
                }
                damage *= 0.8f;
            }
        } else if (this.haveShied()) {
            this.toogleBlocking();
        }
        if (!this.field_70170_p.field_72995_K && damagesource.func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)damagesource.func_76346_g();
            if (!this.func_142014_c(entity) && !this.field_70170_p.field_72995_K) {
                if (this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) > this.func_70032_d((Entity)entity)) {
                    this.func_70624_b(entity);
                }
                if (this.party != null) {
                    this.party.addAggroToTarget(entity, (int)damage);
                }
            }
            if (this.isAiming() && this.canAimBeCanceled() && !damagesource.func_76352_a()) {
                this.field_70724_aR = this.getAttackSpeed();
                this.stopAiming();
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(slowDownModifier);
            }
        }
        return super.func_70097_a(damagesource, damage);
    }

    public void func_70108_f(Entity par1Entity) {
        if (!this.field_70170_p.field_72995_K && this.getLeader() != null && par1Entity instanceof EntityHumanBase && !((EntityHumanBase)par1Entity).func_142014_c((EntityLivingBase)this)) {
            this.func_70624_b((EntityLivingBase)par1Entity);
        }
        super.func_70108_f(par1Entity);
    }

    public boolean attackEntityWithRangedAttack(Entity entity, float f) {
        boolean flagRight = false;
        boolean flagLeft = false;
        if (this.leftHand.isRanged()) {
            flagLeft = this.leftHand.attackWithRange(entity, f);
        }
        if (this.rightHand.isRanged()) {
            flagRight = this.rightHand.attackWithRange(entity, f);
        }
        return flagLeft || flagRight;
    }

    public void attackEntity(EntityLivingBase entity) {
        if (entity.field_70737_aN <= 0) {
            if (this.rightHand.attackTime <= 0) {
                this.rightHand.attackEntity((Entity)entity);
            } else if (this.leftHand.attackTime <= 0) {
                this.leftHand.attackEntity((Entity)entity);
            }
            if (this.haveShied() && this.isDefending()) {
                this.setDefending(false);
            }
        }
    }

    public boolean func_70652_k(Entity entity) {
        return this.attackEntityAsMob(entity, this.func_71124_b(0));
    }

    public boolean attackEntityAsMob(Entity entity, ItemStack weapon) {
        boolean flag;
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (weapon != this.func_71124_b(0)) {
            damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
            damage = (float)((double)damage + BDHelper.getWeaponDamage(weapon));
        }
        if (entity instanceof EntityCreeper) {
            damage += 1000.0f;
        }
        float knockBackAmount = 0.0f;
        if (weapon != null) {
            if (weapon.func_77973_b() instanceof ItemBaseDagger) {
                double d = this.field_70165_t - entity.field_70165_t;
                double d1 = this.field_70163_u - entity.field_70163_u;
                double d2 = this.field_70161_v - entity.field_70161_v;
                float angle = (float)Math.atan2(d, d2);
                for (angle = this.field_70177_z - entity.field_70177_z; angle > 360.0f; angle -= 360.0f) {
                }
                while (angle < 0.0f) {
                    angle += 360.0f;
                }
                if (Math.abs(angle = Math.abs(angle - 180.0f)) > 130.0f) {
                    damage *= 2.5f;
                    if (!this.field_70170_p.field_72995_K) {
                        PacketSpawnParticlesAround packet = new PacketSpawnParticlesAround(1, entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v);
                        ChocolateQuest.channel.sendToAllAround(entity, packet, 64);
                    }
                }
            }
            if (weapon.func_77973_b() instanceof ItemBaseSpear) {
                knockBackAmount = 1.3f;
                if (entity.field_70154_o != null && this.field_70146_Z.nextInt(10) == 0) {
                    entity.func_70078_a(null);
                }
            }
        }
        if ((flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage)) && weapon != null) {
            int k;
            int j = EnchantmentHelper.func_77506_a((int)Enchantment.field_77337_m.field_77352_x, (ItemStack)weapon);
            if (j > 0) {
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)j * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)j * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((k = EnchantmentHelper.func_77506_a((int)Enchantment.field_77334_n.field_77352_x, (ItemStack)weapon)) > 0) {
                entity.func_70015_d(k * 4);
            }
        }
        if (knockBackAmount > 0.0f) {
            entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * knockBackAmount * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * knockBackAmount * 0.5f));
        }
        return flag;
    }

    public boolean func_70686_a(Class par1Class) {
        return EntityGhast.class != par1Class && par1Class != EntityReferee.class;
    }

    public float func_70047_e() {
        if (this.isSitting()) {
            return super.func_70047_e() - 0.5f;
        }
        return super.func_70047_e();
    }

    public double getDistanceToAttack() {
        return Math.max(this.rightHand.getDistanceToStopAdvancing(), this.leftHand.getDistanceToStopAdvancing());
    }

    protected boolean func_70085_c(EntityPlayer player) {
        ItemStack is;
        if (player.func_71045_bC() != null && ((is = player.func_71045_bC()).func_77973_b() == Items.field_151057_cb || is.func_77973_b() instanceof ItemController)) {
            return super.func_70085_c(player);
        }
        if (this.playerSpeakingTo == null) {
            this.playerSpeakingTo = player;
            if (this.field_70170_p instanceof WorldServer) {
                PacketUpdateHumanData packet = new PacketUpdateHumanData(this);
                ChocolateQuest.channel.sendToAllAround((Entity)this, packet);
            }
            if (!this.field_70170_p.field_72995_K) {
                player.openGui((Object)ChocolateQuest.instance, 0, this.field_70170_p, this.func_145782_y(), 0, 0);
            }
            return true;
        }
        return false;
    }

    public boolean func_110176_b(int par1, int par2, int par3) {
        if (this.ownerName != null) {
            return true;
        }
        return super.func_110176_b(par1, par2, par3);
    }

    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        if (this.party != null) {
            this.party.removeMember(this);
        }
    }

    public void onSpawn() {
        this.updateHands();
    }

    public int getHandAngle(HandHelper hand) {
        if (hand == this.leftHand) {
            return -30;
        }
        return 30;
    }

    public boolean canSee(EntityLivingBase entity) {
        boolean flag = true;
        if (flag) {
            if (entity.field_70154_o != null || entity.func_70051_ag()) {
                flag = true;
            } else {
                double rotDiff = Math.abs(BDHelper.getAngleBetweenEntities((Entity)this, (Entity)entity));
                double rot = rotDiff - Math.abs(MathHelper.func_76138_g((double)this.field_70759_as));
                rot = Math.abs(rot);
                float lightLevel = entity.field_70170_p.func_72801_o(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70163_u), MathHelper.func_76128_c((double)entity.field_70161_v));
                double dist = entity.func_70068_e((Entity)this) / 16.0;
                double value = (rot + dist + (double)(entity.func_70093_af() ? 30 : 0)) * (2.2 - (double)lightLevel);
                flag = value < 100.0;
            }
        }
        return flag;
    }

    public boolean isSuitableTargetAlly(EntityLivingBase entity) {
        if (entity == null) {
            return false;
        }
        if (this.func_142014_c(entity)) {
            return true;
        }
        if (entity.field_70153_n == null && this.isSuitableMount((Entity)entity)) {
            return true;
        }
        if (entity.field_70153_n instanceof EntityLivingBase) {
            return this.func_142014_c((EntityLivingBase)entity.field_70153_n);
        }
        return false;
    }

    public void startSprinting() {
        if (!this.func_70051_ag() && this.exhaustion <= 0) {
            this.func_70031_b(true);
            this.sprintTime = this.maxStamina;
        }
    }

    public boolean canSprint() {
        return true;
    }

    public boolean canBlock() {
        return this.haveShied();
    }

    public boolean haveShied() {
        return this.leftHand.canBlock();
    }

    public void toogleBlocking() {
        if (this.haveShied()) {
            this.setDefending(!this.isDefending());
        } else {
            this.setDefending(false);
        }
    }

    public boolean canAimBeCanceled() {
        return false;
    }

    public boolean isHealer() {
        return this.rightHand.isHealer() || this.leftHand.isHealer();
    }

    public boolean isRanged() {
        return this.rightHand.isRanged() || this.leftHand.isRanged();
    }

    public boolean isTwoHanded() {
        return this.rightHand.isTwoHanded();
    }

    public void setCaptain(boolean captain) {
        this.setAnimFlag(0, captain);
    }

    public boolean isCaptain() {
        return this.getAnimFlag(0);
    }

    public boolean isDefending() {
        return this.getAnimFlag(2);
    }

    public void setDefending(boolean flag) {
        if (this.haveShied()) {
            this.setAnimFlag(2, flag);
        }
    }

    public boolean isSitting() {
        return this.getAnimFlag(3);
    }

    public void setSitting(boolean flag) {
        this.setAnimFlag(3, flag);
    }

    public boolean isSpeaking() {
        return this.getAnimFlag(4);
    }

    public void setSpeaking(boolean flag) {
        this.setAnimFlag(4, flag);
    }

    public boolean func_70113_ah() {
        return this.getAnimFlag(5);
    }

    public void func_70019_c(boolean flag) {
        this.setAnimFlag(5, flag);
    }

    public boolean func_70093_af() {
        return this.getAnimFlag(6);
    }

    public void func_70095_a(boolean flag) {
        this.setAnimFlag(6, flag);
    }

    protected boolean getAnimFlag(int index) {
        return (this.field_70180_af.func_75683_a(16) & 1 << index) != 0;
    }

    protected void setAnimFlag(int index, boolean result) {
        byte b = this.field_70180_af.func_75683_a(16);
        if (result) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b | 1 << index)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(b & ~(1 << index))));
        }
    }

    public double getAttackRangeBonus() {
        return this.rightHand.getAttackRangeBonus();
    }

    public double getMaxRangeForAttack() {
        return this.rightHand.getAttackRangeBonus();
    }

    public EntityLivingBase getOwner() {
        if (this.owner == null && this.ownerName != null) {
            this.setOwner((EntityLivingBase)this.field_70170_p.func_72924_a(this.ownerName));
        }
        return this.owner;
    }

    public void setOwner(EntityLivingBase entity) {
        if (entity instanceof EntityHumanBase) {
            EntityHumanBase human = (EntityHumanBase)entity;
            if (human.getOwner() == this) {
                return;
            }
        } else if (entity instanceof EntityPlayer) {
            this.ownerName = ((EntityPlayer)entity).func_70005_c_();
            if (entity.func_96124_cp() != null) {
                this.entityTeam = entity.func_96124_cp().func_96661_b();
            }
        } else if (entity == null) {
            this.ownerName = null;
        }
        this.owner = entity;
    }

    public EntityLivingBase getLeader() {
        if (this.party != null && this.party.getLeader() != this) {
            return this.party.getLeader();
        }
        return this.owner;
    }

    public boolean tryPutIntoPArty(EntityHumanBase newMember) {
        if (this.party == null) {
            this.party = new EntityParty();
            this.party.tryToAddNewMember(this);
        }
        return this.party.tryToAddNewMember(newMember);
    }

    public void setInParty(EntityParty party, int angle, int dist) {
        this.party = party;
        if (!this.partyPositionPersistance) {
            this.partyPositionAngle = angle;
            this.partyDistanceToLeader = dist;
            if (this.isCaptain()) {
                this.AICombatMode = EnumAiCombat.OFFENSIVE.ordinal();
            }
            if (this.isRanged() || this.isHealer()) {
                if (this.isRanged()) {
                    this.partyDistanceToLeader += 2;
                }
                this.AICombatMode = EnumAiCombat.EVASIVE.ordinal();
            } else if (this.haveShied() || angle < 45 && angle > -45) {
                this.AICombatMode = EnumAiCombat.DEFENSIVE.ordinal();
            }
            this.setAIForCurrentMode();
        }
    }

    public void setOutOfParty() {
        this.party = null;
    }

    public Team func_96124_cp() {
        EntityLivingBase entitylivingbase = this.getOwner();
        if (entitylivingbase instanceof EntityPlayer) {
            return entitylivingbase.func_96124_cp();
        }
        return new MobTeam(this.entityTeam);
    }

    public boolean func_142014_c(EntityLivingBase entity) {
        if (this.getOwner() != null) {
            EntityLivingBase owner = this.getOwner();
            if (entity == owner) {
                return true;
            }
            if (owner.func_96124_cp() != null && entity.func_96124_cp() != null) {
                return owner.func_96124_cp().func_96661_b().equals(entity.func_96124_cp().func_96661_b());
            }
        }
        return super.func_142014_c(entity);
    }

    public int getInteligence() {
        return 4;
    }

    public int getAttackSpeed() {
        return 30;
    }

    public int getLeadershipValue() {
        return 0;
    }

    public int getTeamID() {
        return this.shieldID;
    }

    public ItemStack getDiamondArmorForSlot(int slot) {
        switch (slot) {
            case 3: {
                return new ItemStack((Item)Items.field_151163_ad);
            }
            case 2: {
                return new ItemStack((Item)Items.field_151173_ae);
            }
            case 1: {
                return new ItemStack((Item)Items.field_151175_af);
            }
        }
        return new ItemStack((Item)Items.field_151161_ac);
    }

    public boolean shouldRenderCape() {
        return false;
    }

    public ItemStack func_70694_bm() {
        if (this.func_70113_ah()) {
            return new ItemStack(ChocolateQuest.potion);
        }
        if (this.rightHand != null) {
            return this.rightHand.getItem();
        }
        return super.func_70694_bm();
    }

    public ItemStack getHeldItemLeft() {
        if (this.leftHand != null) {
            return this.leftHand.getItem();
        }
        return super.func_70694_bm();
    }

    public void func_70078_a(Entity e) {
        super.func_70078_a(e);
        if (this.field_70154_o != null && this.isSuitableMount(this.field_70154_o) && e instanceof EntityAnimal) {
            EntityLiving entityTarget = (EntityLiving)this.field_70154_o;
            boolean hasRiddenTask = false;
            for (Object task : entityTarget.field_70714_bg.field_75782_a) {
                if (!(task instanceof AIAnimalMountedByEntity)) continue;
                hasRiddenTask = true;
            }
            if (!hasRiddenTask) {
                entityTarget.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIAnimalMountedByEntity(entityTarget, 1.0f));
            }
        }
    }

    public boolean isSuitableMount(Entity entity) {
        return entity instanceof EntityHorse;
    }

    protected Entity getMount() {
        return new EntityHorse(this.field_70170_p);
    }

    public void setMountAI() {
        if (this.field_70154_o != null && this.isSuitableMount(this.field_70154_o)) {
            if (this.field_70154_o instanceof EntityHorse) {
                EntityHorse horse = (EntityHorse)this.field_70154_o;
                horse.func_110263_g((EntityPlayer)new DummyChocolate(this.field_70170_p));
            }
            EntityCreature entityTarget = (EntityCreature)this.field_70154_o;
            boolean hasRiddenTask = false;
            for (Object task : entityTarget.field_70714_bg.field_75782_a) {
                if (!(task instanceof AIAnimalMountedByEntity)) continue;
                hasRiddenTask = true;
            }
            if (!hasRiddenTask) {
                entityTarget.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIAnimalMountedByEntity((EntityLiving)entityTarget, 1.0f));
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    public int func_70627_aG() {
        return 450;
    }

    public void readSpawnData(ByteBuf additionalData) {
        NBTTagCompound data = null;
        try {
            this.AICombatMode = additionalData.readInt();
            this.AIMode = additionalData.readInt();
            this.partyPositionAngle = additionalData.readInt();
            this.partyDistanceToLeader = additionalData.readInt();
            byte length = additionalData.readByte();
            if (length > 0) {
                byte[] bData = new byte[length];
                additionalData.readBytes(bData);
                data = CompressedStreamTools.func_74792_a((byte[])bData);
                ItemStack is = ItemStack.func_77949_a((NBTTagCompound)data);
                if (is != null) {
                    this.leftHandItem = is;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.updateHands();
    }

    public void writeSpawnData(ByteBuf buffer) {
        try {
            buffer.writeInt(this.AICombatMode);
            buffer.writeInt(this.AIMode);
            buffer.writeInt(this.partyPositionAngle);
            buffer.writeInt(this.partyDistanceToLeader);
            NBTTagCompound data = new NBTTagCompound();
            if (this.getLeftHandItem() != null) {
                this.getLeftHandItem().func_77955_b(data);
            }
            byte[] bData = CompressedStreamTools.func_74798_a((NBTTagCompound)data);
            buffer.writeByte(bData.length);
            buffer.writeBytes(bData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.onSpawn();
    }

    public void func_70062_b(int par1, ItemStack par2ItemStack) {
        super.func_70062_b(par1, par2ItemStack);
        if (par1 == 0) {
            this.updateHands();
        }
    }

    public String func_70905_p() {
        return this.ownerName;
    }

    @Override
    public int getPhysicDefense() {
        return this.physicDefense;
    }

    @Override
    public int getMagicDefense() {
        return this.magicDefense;
    }

    @Override
    public int getBlastDefense() {
        return this.blastDefense;
    }

    @Override
    public int getFireDefense() {
        return this.fireDefense;
    }

    @Override
    public int getProjectileDefense() {
        return this.projectileDefense;
    }
}

