/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.client.itemsRender;

import com.chocolate.chocolateQuest.client.ClientProxy;
import com.chocolate.chocolateQuest.client.itemsRender.RenderItemBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderItemModel
extends RenderItemBase {
    public final ResourceLocation texture;
    ModelBase model;
    int armorType;

    public RenderItemModel(ItemArmor item) {
        ItemStack is = new ItemStack((Item)item);
        this.armorType = item.field_77881_a;
        this.texture = new ResourceLocation(item.getArmorTexture(is, null, this.armorType, ""));
        this.model = item.getArmorModel(null, is, this.armorType);
        if (this.model == null) {
            this.model = ClientProxy.defaultArmor;
        }
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || type == IItemRenderer.ItemRenderType.ENTITY;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        EntityLivingBase p;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            p = (EntityLivingBase)data[1];
            this.renderEquipped(p, item);
        }
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            p = (Entity)data[1];
            this.render((Entity)p, item);
        }
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.renderInventory(item);
        }
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            p = (EntityLivingBase)data[1];
            this.renderFP(p, item);
        }
    }

    @Override
    protected void renderInventory(ItemStack itemstack) {
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int armorOffset = this.armorType * 6;
        if (this.armorType == 2) {
            armorOffset += 2;
        }
        GL11.glTranslatef((float)8.0f, (float)(10 - armorOffset), (float)0.0f);
        GL11.glScalef((float)15.0f, (float)15.0f, (float)15.0f);
        GL11.glRotatef((float)-25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)220.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.model.func_78088_a(null, (float)this.armorType, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GL11.glEnable((int)2884);
    }

    protected void render(Entity entity, ItemStack itemstack) {
        GL11.glDisable((int)2884);
        float armorOffset = (float)this.armorType * 1.2f;
        if (this.armorType == 3) {
            armorOffset = 3.2f;
        }
        GL11.glTranslatef((float)0.0f, (float)armorOffset, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        this.model.func_78088_a(entity, (float)this.armorType, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GL11.glEnable((int)2884);
    }

    @Override
    protected void renderEquipped(EntityLivingBase entity, ItemStack itemstack) {
        float armorOffset = 0.4f - (float)this.armorType * 0.6f;
        if (this.armorType == 2) {
            armorOffset += 0.2f;
        }
        GL11.glTranslatef((float)0.5f, (float)(armorOffset * 0.5f), (float)(0.4f + armorOffset));
        GL11.glRotatef((float)-6.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)16.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)24.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        this.model.func_78088_a((Entity)entity, (float)this.armorType, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
    }

    protected void renderFP(EntityLivingBase entity, ItemStack itemstack) {
    }
}

