/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.builder.schematic;

import com.chocolate.chocolateQuest.utils.BDHelper;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ReportedException;
import net.minecraft.world.World;

public class Schematic {
    public short width;
    public short height;
    public short length;
    short[] blocks;
    byte[] metadata;
    String schematicName = "ChocolateQuest_Schematic";
    int posX;
    int posY;
    int posZ;
    public NBTTagList entities;
    public NBTTagList tileEntities;
    Map<String, Integer> idMap;

    public Schematic() {
        this(new File(BDHelper.getAppDir(), BDHelper.getInfoDir() + "Building/test.schematic"));
        this.save(new File(Minecraft.func_71410_x().field_71412_D, "/Chocolate/Building/test/saveTest"));
        int a = 0;
        byte A = (byte)(a & 0xFF);
        byte B = (byte)((a & 0xF00) >> 8);
        System.out.println((A & 0xFF) + " " + (B & 0xFF) + " " + ((A & 0xFF) + (B << 8)));
    }

    public Schematic(File file) {
        this.load(Schematic.getNBTMap(file));
    }

    public Schematic(int width, int height, int length) {
        this.width = (short)width;
        this.height = (short)height;
        this.length = (short)length;
        int total = width * length * height;
        this.blocks = new short[total];
        this.metadata = new byte[total];
    }

    public Schematic(int width, int height, int length, int posX, int posY, int posZ, String name) {
        this(width, height, length);
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.schematicName = name;
    }

    public void setPosition(int posX, int posY, int posZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public Block getBlock(int x, int y, int z) {
        int index = y * this.width * this.length + z * this.width + x;
        return Block.func_149729_e((int)this.blocks[index]);
    }

    public int getBlockMetadata(int x, int y, int z) {
        int index = y * this.width * this.length + z * this.width + x;
        return this.metadata[index];
    }

    public List<TileEntity> getTileEntities() {
        if (this.tileEntities != null) {
            ArrayList<TileEntity> list = new ArrayList<TileEntity>();
            for (int i = 0; i < this.tileEntities.func_74745_c(); ++i) {
                NBTTagCompound tag = this.tileEntities.func_150305_b(i);
                TileEntity te = TileEntity.func_145827_c((NBTTagCompound)tag);
                int x = te.field_145851_c;
                int y = te.field_145848_d;
                int z = te.field_145849_e;
                te.field_145851_c = x + this.posX;
                te.field_145848_d = y + this.posY;
                te.field_145849_e = z + this.posZ;
                list.add(te);
            }
            return list;
        }
        return null;
    }

    public NBTTagList getTileEntitiesTag() {
        return this.tileEntities;
    }

    public List<Entity> getEntities(World world) {
        if (this.entities != null) {
            ArrayList<Entity> list = new ArrayList<Entity>();
            for (int i = 0; i < this.entities.func_74745_c(); ++i) {
                EntityPainting ep;
                EntityEgg e = new EntityEgg(world);
                int entityID = e.func_145782_y();
                e = null;
                NBTTagCompound tag = this.entities.func_150305_b(i);
                e = EntityList.func_75615_a((NBTTagCompound)tag, (World)world);
                if (e == null) continue;
                if (e instanceof EntityPainting) {
                    ep = (EntityPainting)e;
                    e = new EntityPainting(world, ep.field_146063_b + this.posX, ep.field_146064_c + this.posY, ep.field_146062_d + this.posZ, ep.field_82332_a);
                    ((EntityPainting)e).field_70522_e = ep.field_70522_e;
                } else if (e instanceof EntityItemFrame) {
                    ep = (EntityItemFrame)e;
                    e = new EntityItemFrame(world, ep.field_146063_b + this.posX, ep.field_146064_c + this.posY, ep.field_146062_d + this.posZ, ep.field_82332_a);
                    if (ep.func_82335_i() != null) {
                        ((EntityItemFrame)e).func_82334_a(ep.func_82335_i());
                    }
                } else {
                    e.func_70107_b(e.field_70165_t + (double)this.posX, e.field_70163_u + (double)this.posY, e.field_70161_v + (double)this.posZ);
                }
                e.field_70176_ah = MathHelper.func_76128_c((double)(e.field_70165_t % 16.0));
                e.field_70162_ai = MathHelper.func_76128_c((double)(e.field_70163_u % 16.0));
                e.field_70164_aj = MathHelper.func_76128_c((double)(e.field_70161_v % 16.0));
                e.func_145769_d(entityID);
                list.add((Entity)e);
            }
            return list;
        }
        return null;
    }

    public void setBlock(int x, int y, int z, Block block) {
        int index = (y -= this.posY) * this.width * this.length + (z -= this.posZ) * this.width + (x -= this.posX);
        this.blocks[index] = (short)GameData.blockRegistry.getId((Object)block);
    }

    public void setBlockMetadata(int x, int y, int z, byte metaData) {
        int index = (y -= this.posY) * this.width * this.length + (z -= this.posZ) * this.width + (x -= this.posX);
        this.metadata[index] = metaData;
    }

    public void setBlockAndMetadata(int x, int y, int z, Block block, byte metaData) {
        int index = (y -= this.posY) * this.width * this.length + (z -= this.posZ) * this.width + (x -= this.posX);
        this.blocks[index] = (short)GameData.blockRegistry.getId((Object)block);
        this.metadata[index] = metaData;
    }

    public void addTileEntity(TileEntity te) {
        if (this.tileEntities == null) {
            this.tileEntities = new NBTTagList();
        }
        int x = te.field_145851_c;
        int y = te.field_145848_d;
        int z = te.field_145849_e;
        te.field_145851_c = x - this.posX;
        te.field_145848_d = y - this.posY;
        te.field_145849_e = z - this.posZ;
        NBTTagCompound data = new NBTTagCompound();
        te.func_145841_b(data);
        this.tileEntities.func_74742_a((NBTBase)data);
        te.field_145851_c = x;
        te.field_145848_d = y;
        te.field_145849_e = z;
    }

    public void addEntity(Entity e) {
        if (this.entities == null) {
            this.entities = new NBTTagList();
        }
        if (e instanceof EntityHanging) {
            EntityHanging ef = (EntityHanging)e;
            ef.field_146063_b -= this.posX;
            ef.field_146064_c -= this.posY;
            ef.field_146062_d -= this.posZ;
        } else {
            e.func_70107_b(e.field_70165_t - (double)this.posX, e.field_70163_u - (double)this.posY, e.field_70161_v - (double)this.posZ);
        }
        NBTTagCompound data = new NBTTagCompound();
        e.func_70039_c(data);
        this.entities.func_74742_a((NBTBase)data);
        if (e instanceof EntityHanging) {
            EntityHanging ef = (EntityHanging)e;
            ef.field_146063_b += this.posX;
            ef.field_146064_c += this.posY;
            ef.field_146062_d += this.posZ;
        } else {
            e.func_70107_b(e.field_70165_t + (double)this.posX, e.field_70163_u + (double)this.posY, e.field_70161_v + (double)this.posZ);
        }
    }

    public void load(NBTTagCompound schematic) {
        this.width = schematic.func_74765_d("Width");
        this.height = schematic.func_74765_d("Height");
        this.length = schematic.func_74765_d("Length");
        int total = this.width * this.length * this.height;
        this.blocks = new short[total];
        this.metadata = new byte[total];
        byte[] blockBytes = schematic.func_74770_j("Blocks");
        byte[] addedBytes = null;
        if (schematic.func_74764_b("Add")) {
            addedBytes = schematic.func_74770_j("Add");
        }
        for (int i = 0; i < total; ++i) {
            short currentID = (short)(blockBytes[i] & 0xFF);
            if (addedBytes != null) {
                currentID = (short)(currentID ^ addedBytes[i] << 8);
            }
            this.blocks[i] = currentID;
        }
        this.metadata = schematic.func_74770_j("Data");
        this.entities = schematic.func_150295_c("Entities", (int)schematic.func_74732_a());
        this.tileEntities = schematic.func_150295_c("TileEntities", (int)schematic.func_74732_a());
        NBTTagList idMappingNBT = schematic.func_150295_c("IDMapping", (int)schematic.func_74732_a());
        if (idMappingNBT != null && idMappingNBT.func_74745_c() > 0) {
            this.loadMappings(idMappingNBT);
            this.translateToLocal();
        }
    }

    public void save(File file) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74777_a("Width", this.width);
        data.func_74777_a("Height", this.height);
        data.func_74777_a("Length", this.length);
        data.func_74778_a("Materials", "Alpha");
        data.func_74778_a("Name", this.schematicName);
        byte[] vanilaBlockIds = new byte[this.blocks.length];
        byte[] addedBits = new byte[this.blocks.length];
        for (int i = 0; i < this.blocks.length; ++i) {
            vanilaBlockIds[i] = (byte)(this.blocks[i] & 0xFF);
            addedBits[i] = (byte)((this.blocks[i] & 0xF00) >> 8);
        }
        data.func_74773_a("Blocks", vanilaBlockIds);
        data.func_74773_a("Add", addedBits);
        data.func_74773_a("Data", this.metadata);
        if (this.tileEntities != null) {
            data.func_74782_a("TileEntities", (NBTBase)this.tileEntities);
        }
        if (this.entities != null) {
            data.func_74782_a("Entities", (NBTBase)this.entities);
        }
        data.func_74782_a("IDMapping", this.saveMappings());
        try {
            FileOutputStream fos = new FileOutputStream(file);
            Schematic.writeCompressed((NBTBase)data, fos);
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCompressed(NBTBase tagCompound, FileOutputStream file) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new GZIPOutputStream(file));
        try {
            Method method = ReflectionHelper.findMethod(NBTTagCompound.class, null, (String[])new String[]{"func_150298_a", "a"}, (Class[])new Class[]{String.class, NBTBase.class, DataOutput.class});
            method.invoke(null, "Schematic", tagCompound, dataOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            dataOutputStream.close();
        }
    }

    public static NBTTagCompound getNBTMap(File file) {
        try {
            FileInputStream fos = new FileInputStream(file);
            NBTTagCompound base = CompressedStreamTools.func_74796_a((InputStream)fos);
            if (base instanceof NBTTagCompound) {
                fos.close();
                return base;
            }
            BDHelper.println("Found corrupted better dungeons template :" + file.getPath() + ", Skipping generation.");
            return null;
        }
        catch (FileNotFoundException e) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)("File not found at better dungeons mod, file: " + file.getPath()));
            throw new ReportedException(crashreport);
        }
        catch (IOException e) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)("Error reading file at better dungeons mod, file: " + file.getPath()));
            throw new ReportedException(crashreport);
        }
    }

    public void translateToLocal() {
        HashMap<Integer, String> tMap = new HashMap<Integer, String>();
        for (String key : this.idMap.keySet()) {
            tMap.put(this.idMap.get(key), key);
        }
        for (int i = 0; i < this.blocks.length; ++i) {
            short currentID;
            if (this.blocks[i] == 0 || !this.idMap.containsValue(currentID = this.blocks[i])) continue;
            Block block = Block.func_149684_b((String)((String)tMap.get(currentID)));
            this.blocks[i] = block != null ? (short)Block.func_149682_b((Block)block) : (short)0;
        }
    }

    public void loadMappings(NBTTagList list) {
        this.idMap = new HashMap<String, Integer>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            this.idMap.put(tag.func_74779_i("ItemType"), tag.func_74762_e("ItemId"));
        }
    }

    public NBTBase saveMappings() {
        this.idMap = new HashMap<String, Integer>();
        for (int i = 0; i < this.blocks.length; ++i) {
            if (this.idMap.containsValue(this.blocks[i])) continue;
            Block block = Block.func_149729_e((int)this.blocks[i]);
            String name = Block.field_149771_c.func_148750_c((Object)block);
            this.idMap.put(name, Integer.valueOf(this.blocks[i]));
        }
        NBTTagList list = new NBTTagList();
        for (String key : this.idMap.keySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("ItemType", key);
            tag.func_74768_a("ItemId", this.idMap.get(key).intValue());
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }
}

