/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.builder.decorator;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class DecoratorWindow {
    int floorType = 0;
    Block block = Blocks.field_150417_aV;
    Block window = Blocks.field_150410_aZ;
    public int height = 1;
    public int width = 1;
    int separation = 3;

    public DecoratorWindow(Random random) {
        this.floorType = random.nextInt(4);
        if (random.nextInt(4) == 0) {
            this.window = Blocks.field_150359_w;
        } else if (random.nextInt(4) == 0) {
            this.window = Blocks.field_150411_aY;
        }
        this.width = 1 + random.nextInt(4);
        this.separation = 1 + random.nextInt(5);
        this.height = 1 + random.nextInt(3);
    }

    public void generateWindowX(World world, int x, int y, int z) {
        this.generateWindow(world, x, y, z, true);
    }

    public void generateWindowZ(World world, int x, int y, int z) {
        this.generateWindow(world, x, y, z, false);
    }

    public void generateWindow(World world, int x, int y, int z, boolean aroundX) {
        switch (this.floorType) {
            case 1: {
                if (this.width < 2) {
                    this.simple(world, x, y, z, aroundX);
                    break;
                }
                this.framed(world, x, y, z, aroundX);
                break;
            }
            case 2: {
                this.open(world, x, y, z, aroundX);
                break;
            }
            default: {
                this.simple(world, x, y, z, aroundX);
            }
        }
    }

    public void simple(World world, int x, int y, int z, boolean aroundX) {
        int pos = Math.abs(aroundX ? x : z);
        boolean posX = false;
        boolean posZ = false;
        pos %= this.separation + this.width;
        for (int i = 1; i < 1 + this.height; ++i) {
            if (pos >= this.width) continue;
            world.func_147449_b(x, y + i, z, this.window);
        }
    }

    public void open(World world, int x, int y, int z, boolean aroundX) {
        int pos = Math.abs(aroundX ? x : z);
        boolean posX = false;
        boolean posZ = false;
        if ((pos %= this.separation + this.width) < this.width) {
            world.func_147468_f(x, y + 1, z);
            world.func_147449_b(x, y + 2, z, this.window);
        }
    }

    public void framed(World world, int x, int y, int z, boolean aroundX) {
        int pos = Math.abs(aroundX ? x : z);
        boolean posX = false;
        boolean posZ = false;
        pos %= this.separation + this.width;
        for (int i = 1; i < 1 + this.height; ++i) {
            if (pos == this.width || pos == 0) {
                world.func_147449_b(x, y + i, z, this.block);
                continue;
            }
            if (pos >= this.width) continue;
            world.func_147449_b(x, y + i, z, this.window);
        }
    }
}

