/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.builder;

import com.chocolate.chocolateQuest.API.RegisterChestItem;
import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.block.BlockBannerStandTileEntity;
import com.chocolate.chocolateQuest.block.BlockMobSpawnerTileEntity;
import com.chocolate.chocolateQuest.builder.BlockData;
import com.chocolate.chocolateQuest.builder.Perlin3D;
import com.chocolate.chocolateQuest.builder.schematic.Schematic;
import com.chocolate.chocolateQuest.entity.mob.registry.RegisterDungeonMobs;
import com.chocolate.chocolateQuest.utils.BDHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.DungeonHooks;

public class BuilderHelper {
    public static BuilderHelper builderHelper = new BuilderHelper();
    static final byte DEFAULT = 0;
    static final byte FOOD = 1;
    static final byte WEAPONS = 2;
    static final byte MINERALS = 3;
    static final byte TREASURE = 4;
    List<BlockData> specialBlocks;
    List<TileEntity> tileEntities;

    public void initialize() {
        if (this.specialBlocks == null) {
            this.specialBlocks = new ArrayList<BlockData>();
        }
        this.specialBlocks.clear();
        if (this.tileEntities == null) {
            this.tileEntities = new ArrayList<TileEntity>();
        }
        this.tileEntities.clear();
    }

    public void flush(World world) {
        this.copySpecialBlocks(world);
        this.copyTileEntities(world);
    }

    public void putSchematicInWorld(Random random, World world, Schematic schematic, int i, int j, int k, int idMob) {
        schematic.setPosition(i, j, k);
        int sx = schematic.width;
        int sy = schematic.height;
        int sz = schematic.length;
        for (int y = 0; y < sy; ++y) {
            for (int x = 0; x < sx; ++x) {
                for (int z = 0; z < sz; ++z) {
                    Block block = schematic.getBlock(x, y, z);
                    int metadata = schematic.getBlockMetadata(x, y, z);
                    int posX = i + x;
                    int posY = j + y;
                    int posZ = k + z;
                    if (this.checkIfPlacedOnFirstPass(block)) {
                        if (block == ChocolateQuest.emptyBlock) continue;
                        if (block == ChocolateQuest.exporterChest) {
                            if (metadata == 4) {
                                world.func_147468_f(posX, posY, posZ);
                                Entity boss = RegisterDungeonMobs.mobList.get(idMob).getBoss(world, posX, posY, posZ);
                                if (boss == null) continue;
                                boss.func_70107_b((double)posX, (double)posY, (double)posZ);
                                world.func_72838_d(boss);
                                if (boss.field_70154_o == null) continue;
                                boss.field_70154_o.func_70107_b((double)posX, (double)posY, (double)posZ);
                                world.func_72838_d(boss.field_70154_o);
                                continue;
                            }
                            if (metadata == 1) {
                                BuilderHelper.addFoodChest(random, world, posX, posY, posZ);
                                continue;
                            }
                            if (metadata == 0) {
                                BuilderHelper.addTreasure(random, world, posX, posY, posZ);
                                continue;
                            }
                            if (metadata == 3) {
                                BuilderHelper.addMineralChest(random, world, posX, posY, posZ);
                                continue;
                            }
                            if (metadata != 2) continue;
                            BuilderHelper.addWeaponChest(random, world, posX, posY, posZ);
                            continue;
                        }
                        if (block == Blocks.field_150486_ae) {
                            BuilderHelper.addChest(random, world, posX, posY, posZ);
                            continue;
                        }
                        world.func_147465_d(posX, posY, posZ, block, metadata, 3);
                        continue;
                    }
                    this.specialBlocks.add(new BlockData(posX, posY, posZ, block, metadata));
                }
            }
        }
        List<TileEntity> list = schematic.getTileEntities();
        NBTTagList tags = schematic.getTileEntitiesTag();
        int tagCount = 0;
        for (TileEntity te : list) {
            Block block = world.func_147439_a(te.field_145851_c, te.field_145848_d, te.field_145849_e);
            if (block instanceof BlockContainer) {
                String name;
                BlockMobSpawnerTileEntity spawner;
                TileEntity tempEntity = ((BlockContainer)block).func_149915_a(world, world.func_72805_g(te.field_145851_c, te.field_145848_d, te.field_145849_e));
                NBTTagCompound tag = tags.func_150305_b(tagCount);
                tempEntity.func_145839_a(tag);
                boolean putTileEntity = true;
                if (tempEntity instanceof BlockMobSpawnerTileEntity) {
                    spawner = (BlockMobSpawnerTileEntity)tempEntity;
                    spawner.mob = idMob;
                }
                if (tempEntity instanceof BlockBannerStandTileEntity) {
                    BlockBannerStandTileEntity stand = (BlockBannerStandTileEntity)tempEntity;
                    int id = RegisterDungeonMobs.mobList.get(idMob).getFlagId();
                    stand.item = new ItemStack(ChocolateQuest.banner, 1, id);
                }
                if (tempEntity instanceof TileEntityMobSpawner && (name = (spawner = (TileEntityMobSpawner)tempEntity).func_145881_a().func_98276_e()).equals("Pig")) {
                    BuilderHelper.setMobForSpawner((TileEntityMobSpawner)spawner, idMob, te.field_145851_c, te.field_145848_d, te.field_145849_e, random);
                }
                if (block == Blocks.field_150486_ae) {
                    putTileEntity = false;
                }
                world.func_147455_a(te.field_145851_c, te.field_145848_d, te.field_145849_e, tempEntity);
            }
            ++tagCount;
        }
        List<Entity> listEntity = schematic.getEntities(world);
        for (Entity e : listEntity) {
            world.func_72838_d(e);
        }
    }

    public void addTileEntity(int x, int y, int z, TileEntity tileEntity) {
        tileEntity.field_145851_c = x;
        tileEntity.field_145848_d = y;
        tileEntity.field_145849_e = z;
        this.tileEntities.add(tileEntity);
    }

    public void copyTileEntities(World world) {
        if (this.tileEntities.size() > 0) {
            for (TileEntity tempEntity : this.tileEntities) {
                world.func_147455_a(tempEntity.field_145851_c, tempEntity.field_145848_d, tempEntity.field_145849_e, tempEntity);
            }
        }
    }

    public boolean checkIfPlacedOnFirstPass(Block id) {
        return id != Blocks.field_150488_af && id != Blocks.field_150429_aA && id != Blocks.field_150430_aB && id != Blocks.field_150471_bO && id != Blocks.field_150324_C && id != Blocks.field_150478_aa && id != Blocks.field_150468_ap && id != Blocks.field_150466_ao && id != Blocks.field_150454_av && id != Blocks.field_150442_at && id != Blocks.field_150478_aa && id != Blocks.field_150468_ap && id != Blocks.field_150324_C && id != Blocks.field_150479_bC && id != Blocks.field_150444_as;
    }

    public void copySpecialBlocks(World world) {
        BlockData b2 = null;
        Random rand = new Random();
        if (this.specialBlocks.size() > 0) {
            for (BlockData b2 : this.specialBlocks) {
                if (b2.block == Blocks.field_150466_ao || b2.block == Blocks.field_150454_av) {
                    if (b2.blockMetadata < 8) {
                        ItemDoor.func_150924_a((World)world, (int)b2.x, (int)b2.y, (int)b2.z, (int)b2.blockMetadata, (Block)(b2.block == Blocks.field_150466_ao ? Blocks.field_150466_ao : Blocks.field_150454_av));
                        continue;
                    }
                    world.func_147465_d(b2.x, b2.y, b2.z, b2.block, b2.blockMetadata, 0);
                    continue;
                }
                if (b2.block == Blocks.field_150460_al) {
                    world.func_147465_d(b2.x, b2.y, b2.z, b2.block, b2.blockMetadata, 0);
                    TileEntityFurnace tef = (TileEntityFurnace)world.func_147438_o(b2.x, b2.y, b2.z);
                    if (rand.nextInt(15) == 0) {
                        tef.func_70299_a(0, new ItemStack(Items.field_151043_k, rand.nextInt(3) + 1));
                    }
                    if (rand.nextInt(3) != 0) continue;
                    tef.func_70299_a(1, new ItemStack(Items.field_151044_h, rand.nextInt(45) + 1));
                    continue;
                }
                if (b2.block == Blocks.field_150367_z) {
                    world.func_147465_d(b2.x, b2.y, b2.z, b2.block, b2.blockMetadata, 0);
                    TileEntityDispenser ted = (TileEntityDispenser)world.func_147438_o(b2.x, b2.y, b2.z);
                    for (int v = 0; v < 9; ++v) {
                        if (rand.nextInt(20) == 0) {
                            if (rand.nextInt(50) == 0) {
                                ted.func_70299_a(v, new ItemStack(Items.field_151062_by, rand.nextInt(64) + 1));
                            }
                            ted.func_70299_a(v, new ItemStack(Items.field_151059_bz, rand.nextInt(64) + 1));
                            continue;
                        }
                        ted.func_70299_a(v, new ItemStack(Items.field_151032_g, rand.nextInt(64) + 1));
                    }
                    continue;
                }
                if (b2.block == Blocks.field_150429_aA) {
                    world.func_147465_d(b2.x, b2.y, b2.z, b2.block, b2.blockMetadata, 3);
                    continue;
                }
                world.func_147465_d(b2.x, b2.y, b2.z, b2.block, b2.blockMetadata, 3);
            }
            this.specialBlocks.clear();
        }
    }

    public static void clearArea(Random random, World world, int i, int j, int k, int sizeX, int sizeZ) {
        Perlin3D p = new Perlin3D(world.func_72905_C(), 8, random);
        Perlin3D p2 = new Perlin3D(world.func_72905_C(), 32, random);
        int wallSize = 8;
        int size = sizeX + wallSize * 2;
        int height = 32;
        i -= wallSize;
        k -= wallSize;
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                int maxHeight = world.func_72825_h(x + i, z + k) - 1 - j;
                for (int y = 0; y <= maxHeight; ++y) {
                    if (x > wallSize && z > wallSize && x < size - wallSize && z < size - wallSize) {
                        world.func_147468_f(x + i, j + y, z + k);
                        continue;
                    }
                    float noiseVar = (float)(maxHeight - y) / ((float)Math.max(1, maxHeight) * 1.5f);
                    int tWallSize = wallSize;
                    noiseVar += Math.max(0.0f, (float)(tWallSize - x) / 8.0f);
                    noiseVar += Math.max(0.0f, (float)(tWallSize - (size - x)) / 8.0f);
                    noiseVar += Math.max(0.0f, (float)(tWallSize - z) / 8.0f);
                    noiseVar += Math.max(0.0f, (float)(tWallSize - (size - z)) / 8.0f);
                    double value = (p.getNoiseAt(x + i, y, z + k) + p2.getNoiseAt(x + i, y, z + k) + (double)noiseVar) / 3.0;
                    if (!(value < 0.5)) continue;
                    world.func_147468_f(i + x, j + y, k + z);
                }
                maxHeight = world.func_72825_h(x + i, z + k);
                BiomeGenBase biome = world.func_72807_a(x + i, z + k);
                world.func_147449_b(i + x, maxHeight - 1, k + z, biome.field_76752_A);
            }
        }
    }

    public static void addSpawner(Random random, World world, int x, int y, int z, int idMob) {
        world.func_147465_d(x, y, z, Blocks.field_150474_ac, 0, 0);
        TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)world.func_147438_o(x, y, z);
        if (tileentitymobspawner != null) {
            BuilderHelper.setMobForSpawner(tileentitymobspawner, idMob, x, y, z, random);
        }
    }

    public static void setMobForSpawner(TileEntityMobSpawner spawner, int idMob, int x, int y, int z, Random random) {
        String mob = RegisterDungeonMobs.mobList.get(idMob).getSpawnerName(x, y, z, random);
        if (mob != null) {
            spawner.func_145881_a().func_98272_a(mob);
        } else {
            spawner.func_145881_a().func_98272_a(DungeonHooks.getRandomDungeonMob((Random)random));
        }
    }

    public static boolean addTreasure(Random random, World world, int x, int y, int z) {
        int slot;
        world.func_147465_d(x, y, z, (Block)Blocks.field_150486_ae, 0, 0);
        TileEntityChest tileentitychest = new TileEntityChest();
        int itemsCount = random.nextInt(4) + 2;
        ItemStack itemstack = null;
        for (int f = 1; f < itemsCount + 1; ++f) {
            itemstack = RegisterChestItem.getRandomItemStack(RegisterChestItem.treasureList, random);
            slot = random.nextInt(tileentitychest.func_70302_i_());
            tileentitychest.func_70299_a(slot, itemstack);
        }
        if (random.nextInt(3) == 0) {
            Item record;
            switch (random.nextInt(10)) {
                case 0: {
                    record = Items.field_151094_cf;
                    break;
                }
                case 1: {
                    record = Items.field_151093_ce;
                    break;
                }
                case 2: {
                    record = Items.field_151091_cg;
                    break;
                }
                case 3: {
                    record = Items.field_151092_ch;
                    break;
                }
                case 4: {
                    record = Items.field_151089_ci;
                    break;
                }
                case 5: {
                    record = Items.field_151090_cj;
                    break;
                }
                case 6: {
                    record = Items.field_151087_ck;
                    break;
                }
                case 7: {
                    record = Items.field_151088_cl;
                    break;
                }
                case 8: {
                    record = Items.field_151084_co;
                    break;
                }
                case 9: {
                    record = Items.field_151085_cm;
                    break;
                }
                default: {
                    record = Items.field_151094_cf;
                }
            }
            slot = random.nextInt(tileentitychest.func_70302_i_());
            tileentitychest.func_70299_a(slot, new ItemStack(record));
        }
        world.func_147455_a(x, y, z, (TileEntity)tileentitychest);
        return true;
    }

    public static boolean addFoodChest(Random random, World world, int x, int y, int z) {
        world.func_147465_d(x, y, z, (Block)Blocks.field_150486_ae, 0, 0);
        TileEntityChest tileentitychest = new TileEntityChest();
        int itemsCount = random.nextInt(6) + 2;
        for (int f = 0; f < itemsCount; ++f) {
            ItemStack itemstack = RegisterChestItem.getRandomItemStack(RegisterChestItem.foodList, random);
            int slot = random.nextInt(tileentitychest.func_70302_i_());
            tileentitychest.func_70299_a(slot, itemstack);
        }
        world.func_147455_a(x, y, z, (TileEntity)tileentitychest);
        return true;
    }

    public static boolean addMineralChest(Random random, World world, int x, int y, int z) {
        world.func_147465_d(x, y, z, (Block)Blocks.field_150486_ae, 0, 0);
        TileEntityChest tileentitychest = new TileEntityChest();
        int itemsCount = random.nextInt(6) + 2;
        ItemStack itemstack = null;
        for (int f = 0; f < itemsCount; ++f) {
            itemstack = RegisterChestItem.getRandomItemStack(RegisterChestItem.mineralList, random);
            int slot = random.nextInt(tileentitychest.func_70302_i_());
            tileentitychest.func_70299_a(slot, itemstack);
        }
        world.func_147455_a(x, y, z, (TileEntity)tileentitychest);
        return true;
    }

    public static boolean addWeaponChest(Random random, World world, int x, int y, int z) {
        world.func_147465_d(x, y, z, (Block)Blocks.field_150486_ae, 0, 0);
        TileEntityChest tileentitychest = new TileEntityChest();
        int itemsCount = random.nextInt(6) + 1;
        ItemStack itemstack = null;
        for (int f = 0; f < itemsCount; ++f) {
            itemstack = RegisterChestItem.getRandomItemStack(RegisterChestItem.weaponList, random);
            if (itemstack != null) {
                BDHelper.EnchantItemRandomly(itemstack, random);
            }
            int slot = random.nextInt(tileentitychest.func_70302_i_());
            tileentitychest.func_70299_a(slot, itemstack);
        }
        world.func_147455_a(x, y, z, (TileEntity)tileentitychest);
        return true;
    }

    public static boolean addChest(Random random, World world, int x, int y, int z) {
        world.func_147465_d(x, y, z, (Block)Blocks.field_150486_ae, 0, 3);
        int itemsCount = random.nextInt(8) + 1;
        TileEntityChest tileentitychest = new TileEntityChest();
        int f = 0;
        if (random.nextInt(150) == 0) {
            Item record = random.nextBoolean() ? Items.field_151086_cn : Items.field_151096_cd;
            tileentitychest.func_70299_a(f, new ItemStack(record));
            ++f;
            ++itemsCount;
        }
        while (f < itemsCount) {
            ItemStack itemstack = RegisterChestItem.getRandomItemStack(RegisterChestItem.chestList, random);
            int slot = random.nextInt(tileentitychest.func_70302_i_());
            tileentitychest.func_70299_a(slot, itemstack);
            ++f;
        }
        world.func_147455_a(x, y, z, (TileEntity)tileentitychest);
        return true;
    }

    public static Schematic getNBTMap(String mapDir) {
        return BuilderHelper.getNBTMap(new File(BDHelper.getAppDir(), BDHelper.getInfoDir() + "Building/" + mapDir));
    }

    public static Schematic getRandomNBTMap(String d, Random random) {
        File dir = new File(BDHelper.getAppDir(), BDHelper.getInfoDir() + "Building/" + d);
        File[] file = dir.listFiles();
        System.out.println(random.nextInt(file.length));
        int s = 0;
        if (file.length > 1) {
            s = random.nextInt(file.length);
        }
        return BuilderHelper.getNBTMap(file[s]);
    }

    public static Schematic getNBTMap(File file) {
        return new Schematic(file);
    }
}

