/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.builder;

import com.chocolate.chocolateQuest.API.BuilderBase;
import com.chocolate.chocolateQuest.API.HelperReadConfig;
import com.chocolate.chocolateQuest.WorldGeneratorNew;
import com.chocolate.chocolateQuest.builder.BuilderHelper;
import com.chocolate.chocolateQuest.builder.decorator.BuildingProperties;
import com.chocolate.chocolateQuest.builder.decorator.EntranceGenerator;
import com.chocolate.chocolateQuest.builder.decorator.RoomBase;
import com.chocolate.chocolateQuest.builder.decorator.RoomsHelper;
import com.chocolate.chocolateQuest.builder.decorator.TowerRound;
import com.chocolate.chocolateQuest.builder.decorator.TowerSquare;
import com.chocolate.chocolateQuest.builder.decorator.rooms.RoomBoss;
import java.util.Properties;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BuilderCastle
extends BuilderBase {
    final int MIN_ROOM_SIZE = 5;
    int roomSize = 10;
    int maxSize = 60;
    int posY = 64;
    BuildingProperties properties;

    @Override
    public BuilderBase load(Properties prop) {
        this.maxSize = Math.max(30, HelperReadConfig.getIntegerProperty(prop, "maxSize", 60));
        this.roomSize = Math.max(6, HelperReadConfig.getIntegerProperty(prop, "roomSize", 8));
        this.properties = new BuildingProperties();
        this.properties.load(prop);
        return this;
    }

    @Override
    public void generate(Random random, World world, int x, int z, int idMob) {
        this.generate(random, world, x -= this.maxSize / 2, this.posY, z -= this.maxSize / 2, idMob);
    }

    @Override
    public void generate(Random random, World world, int x, int y, int z, int idMob) {
        WorldGeneratorNew.createChunks(world, x, z, this.maxSize, this.maxSize);
        this.properties.initialize(random);
        int offset = 4;
        BuilderHelper.clearArea(random, world, x - offset, y, z - offset, this.maxSize + offset * 2, this.maxSize + offset * 2);
        this.generateCastleStructure(random, world, x, y, z, this.maxSize, this.maxSize);
    }

    public void generateCastleStructure(Random random, World world, int x, int y, int z, int maxSizeX, int maxSizeZ) {
        int sizeQuartX = maxSizeX / 4;
        int sizeQuartZ = maxSizeZ / 4;
        int sizeX = sizeQuartX + random.nextInt(sizeQuartX * 3);
        int sizeZ = sizeQuartZ + random.nextInt(sizeQuartZ * 3);
        int offsetX = random.nextInt(sizeQuartX);
        int offsetZ = random.nextInt(sizeQuartZ);
        sizeX = Math.max(this.roomSize, sizeX);
        sizeZ = Math.max(this.roomSize, sizeZ);
        x += offsetX;
        z += offsetZ;
        boolean walkableRoof = false;
        if (Math.min(sizeX, sizeZ) > this.roomSize) {
            this.generateCastleStructure(random, world, x, y + (this.properties.floorHeight + 1) * 2, z, sizeX, sizeZ);
            walkableRoof = true;
        }
        this.generateSquaredStructure(random, world, x, y, z, sizeX, sizeZ, 1, walkableRoof, false);
        this.generateStructureAtSide(random, world, x + sizeX, y, z, sizeX, offsetZ, 1, ForgeDirection.NORTH);
        this.generateStructureAtSide(random, world, x, y, z + sizeZ, sizeX, maxSizeZ - sizeZ - offsetZ, 1, ForgeDirection.SOUTH);
        this.generateStructureAtSide(random, world, x, y, z + sizeZ, offsetX, sizeZ, 1, ForgeDirection.WEST);
        this.generateStructureAtSide(random, world, x + sizeX, y, z, maxSizeX - sizeX - offsetX, sizeZ, 1, ForgeDirection.EAST);
        EntranceGenerator entranceGenerator = new EntranceGenerator(this.properties);
        entranceGenerator.generateEntance(world, x + sizeX / 2, y, z, ForgeDirection.NORTH);
        entranceGenerator.generateEntance(world, x + sizeX / 2, y, z + sizeZ, ForgeDirection.SOUTH);
        entranceGenerator.generateEntance(world, x, y, z + sizeZ / 2, ForgeDirection.WEST);
        entranceGenerator.generateEntance(world, x + sizeX, y, z + sizeZ / 2, ForgeDirection.EAST);
    }

    public void generateStructureAtSide(Random random, World world, int x, int y, int z, int maxSizeX, int maxSizeZ, int floors, ForgeDirection side) {
        if (maxSizeX <= 0 || maxSizeZ <= 0) {
            return;
        }
        int sizeX = Math.max(random.nextInt(maxSizeX), this.roomSize);
        int sizeZ = Math.max(random.nextInt(maxSizeZ), this.roomSize);
        boolean addStairs = false;
        int emptyAreaLength = 0;
        if (side.offsetX != 0) {
            emptyAreaLength = maxSizeX;
        } else if (side.offsetZ != 0) {
            emptyAreaLength = maxSizeZ;
        }
        if (emptyAreaLength > this.roomSize + this.roomSize / 2) {
            this.generateSquaredStructure(random, world, x, y, z, sizeX, sizeZ, floors, false, false, addStairs);
            emptyAreaLength = 0;
            if (side.offsetX != 0) {
                emptyAreaLength = maxSizeX - sizeX;
            } else if (side.offsetZ != 0) {
                emptyAreaLength = maxSizeZ - sizeZ;
            }
            if (side.offsetX < 0) {
                x += sizeX;
            }
            if (side.offsetZ < 0) {
                z += sizeZ;
            }
            if (emptyAreaLength > this.roomSize) {
                int offsetX = side.offsetX * sizeX;
                int offsetZ = side.offsetZ * sizeZ;
                if (side.offsetX != 0) {
                    maxSizeX -= sizeX;
                } else if (side.offsetZ != 0) {
                    maxSizeZ -= sizeZ;
                }
                this.generateStructureAtSide(random, world, x + offsetX, y, z + offsetZ, maxSizeX, maxSizeZ, floors, side);
            } else if (emptyAreaLength > 5) {
                this.generateTowersAtSide(random, world, x, y, z, sizeX, sizeZ, floors, side);
            }
        } else if (emptyAreaLength > 5) {
            this.generateTowersAtSide(random, world, x, y, z, maxSizeX, maxSizeZ, floors, side);
        } else {
            return;
        }
    }

    public void generateTowersAtSide(Random random, World world, int x, int y, int z, int maxSizeX, int maxSizeZ, int floors, ForgeDirection side) {
        int emptyAreaLength = 0;
        if (side.offsetX != 0) {
            emptyAreaLength = maxSizeX;
        } else if (side.offsetZ != 0) {
            emptyAreaLength = maxSizeZ;
        }
        int width = 0;
        if (side.offsetZ != 0) {
            width = maxSizeX;
        } else if (side.offsetX != 0) {
            width = maxSizeZ;
        }
        if (width < this.roomSize * 2) {
            width = Math.max(5, Math.min(emptyAreaLength, width));
            TowerSquare tower = random.nextBoolean() ? new TowerSquare(this.properties) : new TowerRound(this.properties);
            tower.configure(floors, width);
            int offsetX = side.offsetZ * maxSizeX / 2;
            int offsetZ = side.offsetX * maxSizeZ / 2;
            tower.buildTower(random, world, x + offsetX, y, z + offsetZ, side);
        } else {
            width = Math.max(6, Math.min(emptyAreaLength, width));
            int offsetX = side.offsetZ * (maxSizeX - 3);
            int offsetZ = side.offsetX * (maxSizeZ - 3);
            TowerSquare tower = random.nextBoolean() ? new TowerSquare(this.properties) : new TowerRound(this.properties);
            tower.configure(floors, width);
            tower.buildTower(random, world, x + offsetX, y, z + offsetZ, side);
            offsetX = side.offsetZ * 3;
            offsetZ = side.offsetX * 3;
            tower = random.nextBoolean() ? new TowerSquare(this.properties) : new TowerRound(this.properties);
            tower.configure(floors, width);
            tower.buildTower(random, world, x + offsetX, y, z + offsetZ, side);
        }
    }

    public void generatePagoda(Random random, World world, int x, int y, int z, int sizeX, int sizeZ) {
        int stepSize = 4;
        int stepSize2 = 2;
        int chapelFloors = 3;
        int xPos = x;
        int yPos = y;
        int zPos = z;
        int floorHeight = this.properties.floorHeight;
        boolean boss = true;
        for (int i = chapelFloors; i >= 0; --i) {
            if (i > 1 && (i * stepSize > sizeX - this.roomSize || i * stepSize > sizeZ - this.roomSize)) continue;
            int X = xPos + stepSize2 * i;
            int Y = yPos + (floorHeight + 1) * i;
            int Z = zPos + stepSize2 * i;
            int sX = sizeX - stepSize * i;
            int sZ = sizeZ - stepSize * i;
            this.generateSquaredStructure(random, world, X, Y, Z, sX, sZ, 0, !boss, boss);
            boss = false;
            this.properties.roof.roofPyramid(world, X - stepSize2, Y + floorHeight - 1, Z - stepSize2, sX + stepSize, sZ + stepSize, stepSize2);
        }
    }

    public void generateSquaredStructure(Random random, World world, int x, int y, int z, int sizeX, int sizeZ, int floors, boolean walkableRoof, boolean boss) {
        this.generateSquaredStructure(random, world, x, y, z, sizeX, sizeZ, floors, walkableRoof, boss, true);
    }

    public void generateSquaredStructure(Random random, World world, int x, int y, int z, int sizeX, int sizeZ, int floors, boolean walkableRoof, boolean boss, boolean addStairs) {
        int roomsX = Math.max(1, sizeX / this.roomSize);
        int roomsZ = Math.max(1, sizeZ / this.roomSize);
        int roomSizeX = sizeX / roomsX;
        int roomSizeZ = sizeZ / roomsZ;
        int lastRoomOffsetX = sizeX - roomsX * roomSizeX;
        int lastRoomOffsetZ = sizeZ - roomsZ * roomSizeZ;
        int currentY = y;
        int floorHeight = this.properties.floorHeight;
        for (int i = 0; i <= sizeX; ++i) {
            for (int j = 0; j < sizeZ; ++j) {
                this.properties.floor.generateFloor(world, x + i, currentY, z + j);
            }
        }
        for (int currentfloor = 0; currentfloor <= floors; ++currentfloor) {
            RoomBase room;
            int i;
            int j;
            int i2;
            for (i2 = 0; i2 <= sizeX; ++i2) {
                for (j = 0; j < sizeZ; ++j) {
                    world.func_147449_b(x + i2, currentY + floorHeight, z + j, this.properties.wallBlock.id);
                    if (currentfloor != floors) {
                        this.properties.floor.generateFloor(world, x + i2, currentY + floorHeight + 1, z + j);
                        continue;
                    }
                    world.func_147465_d(x + i2, currentY + floorHeight + 1, z + j, this.properties.wallBlock.id, 0, 3);
                }
            }
            ++currentY;
            for (i2 = 0; i2 <= sizeX; ++i2) {
                for (j = -1; j <= floorHeight; ++j) {
                    world.func_147449_b(x + i2, currentY + j, z, this.properties.wallBlock.id);
                    world.func_147449_b(x + i2, currentY + j, z + sizeZ, this.properties.wallBlock.id);
                }
                if (i2 <= 0 || i2 >= sizeX) continue;
                this.properties.window.generateWindowX(world, x + i2, currentY, z);
                this.properties.window.generateWindowX(world, x + i2, currentY, z + sizeZ);
            }
            for (i2 = 0; i2 <= sizeZ; ++i2) {
                for (j = -1; j <= floorHeight; ++j) {
                    world.func_147449_b(x, currentY + j, z + i2, this.properties.wallBlock.id);
                    world.func_147449_b(x + sizeX, currentY + j, z + i2, this.properties.wallBlock.id);
                }
                if (i2 <= 0 || i2 >= sizeZ) continue;
                this.properties.window.generateWindowZ(world, x, currentY, z + i2);
                this.properties.window.generateWindowZ(world, x + sizeX, currentY, z + i2);
            }
            RoomBase[][] roomsArray = new RoomBase[roomsX][roomsZ];
            roomsArray = RoomsHelper.getRoomsArray(roomsArray, this.properties, random, floorHeight, roomSizeX, roomSizeZ, addStairs);
            for (i = 0; i < roomsArray.length; ++i) {
                room = roomsArray[i][roomsArray[0].length - 1];
                if (room == null) continue;
                room.sizeZ += lastRoomOffsetZ;
            }
            for (i = 0; i < roomsArray[0].length; ++i) {
                room = roomsArray[roomsArray.length - 1][i];
                if (room == null) continue;
                room.sizeX += lastRoomOffsetX;
            }
            if (currentfloor == floors && boss) {
                roomsArray[0][0] = new RoomBoss().copyDataFrom(roomsArray[0][0]);
            }
            RoomsHelper.buildRooms(world, random, roomsArray, x, currentY, z, this.properties);
            currentY += floorHeight;
        }
        this.properties.roof.generateRoof(world, x, currentY + 1, z, sizeX, sizeZ, walkableRoof);
    }

    @Override
    public String getName() {
        return "castle";
    }
}

