/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.utils;

import com.chocolate.chocolateQuest.magic.Awakements;
import com.chocolate.chocolateQuest.utils.PlayerInfo;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.FoodStats;

public class PlayerManager {
    static PlayerInfo clientPlayerInfo;
    static Map<String, PlayerInfo> serverPlayersInfo;

    public static void setTarget(EntityPlayer player, EntityLivingBase target) {
        PlayerInfo info = PlayerManager.getPlayerInfo(player);
    }

    public static EntityLivingBase getTarget(EntityPlayer player) {
        return PlayerManager.getPlayerInfo((EntityPlayer)player).target;
    }

    public static boolean useStamina(EntityPlayer player, float ammount, boolean forceConsumition) {
        if (PlayerManager.useStamina(player, ammount)) {
            return true;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            FoodStats food = player.func_71024_bL();
            if (food.func_75116_a() < 1) {
                return false;
            }
            food.func_75113_a(ammount);
        }
        return true;
    }

    public static boolean useStamina(EntityPlayer player, float ammount) {
        if (PlayerManager.getStamina(player) - ammount < 0.0f) {
            if (!player.field_71075_bZ.field_75098_d) {
                FoodStats food = player.func_71024_bL();
                if (food.func_75116_a() <= 2) {
                    return false;
                }
                food.func_75113_a(ammount);
            }
        } else {
            PlayerManager.addStamina(player, -ammount);
        }
        return true;
    }

    public static void addStamina(EntityPlayer player, float ammount) {
        float newStamina = PlayerManager.getStamina(player);
        newStamina = Math.min(PlayerManager.getMaxStamina(player), Math.max(0.0f, newStamina + ammount));
        if (!player.field_70170_p.field_72995_K) {
            PlayerManager.getClientPlayerInfo((EntityPlayer)player).stamina = newStamina;
        } else {
            PlayerInfo info = PlayerManager.getPlayerInfo(player);
            info.stamina = newStamina;
        }
    }

    public static float getStamina(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            return PlayerManager.getClientPlayerInfo((EntityPlayer)player).stamina;
        }
        String name = PlayerManager.getPlayerName(player);
        if (!serverPlayersInfo.containsKey(name)) {
            return PlayerManager.getMaxStamina(player);
        }
        return PlayerManager.getPlayerInfo((EntityPlayer)player).stamina;
    }

    public static PlayerInfo getPlayerInfo(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            return PlayerManager.getClientPlayerInfo(player);
        }
        String name = PlayerManager.getPlayerName(player);
        if (!serverPlayersInfo.containsKey(name)) {
            serverPlayersInfo.put(name, new PlayerInfo(player));
        }
        return serverPlayersInfo.get(name);
    }

    public static PlayerInfo getClientPlayerInfo(EntityPlayer player) {
        if (clientPlayerInfo == null) {
            clientPlayerInfo = new PlayerInfo(player);
        }
        return clientPlayerInfo;
    }

    private static String getPlayerName(EntityPlayer player) {
        return player.func_70005_c_();
    }

    public static float getMaxStamina(EntityPlayer player) {
        float stamina = 50.0f;
        int staminaLevel = 0;
        for (int i = 0; i < 4; ++i) {
            ItemStack is = player.func_82169_q(i);
            if (is == null) continue;
            staminaLevel += Awakements.getEnchantLevel(is, Awakements.staminaMax);
        }
        return stamina + (float)staminaLevel * 2.5f;
    }

    public static void reset() {
        clientPlayerInfo = null;
        serverPlayersInfo = new HashMap<String, PlayerInfo>();
    }

    static {
        serverPlayersInfo = new HashMap<String, PlayerInfo>();
    }
}

