/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.quest.worldManager;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.quest.worldManager.NamedCoordinates;
import com.chocolate.chocolateQuest.quest.worldManager.WorldManagerBase;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChunkCoordinates;

public class TerrainManager
extends WorldManagerBase {
    public static TerrainManager instance;
    int territorySeparation;
    List<String> uniqueDungeonsSpawned;
    List<NamedCoordinates> teleportPoints;

    public TerrainManager(int territorySeparation) {
        this.territorySeparation = territorySeparation;
        this.uniqueDungeonsSpawned = new ArrayList<String>();
        this.teleportPoints = new LinkedList<NamedCoordinates>();
    }

    public static TerrainManager getInstance() {
        if (instance == null) {
            instance = new TerrainManager(ChocolateQuest.config.dungeonSeparation);
        }
        return instance;
    }

    public static int getTerritorySeparation() {
        return instance == null ? ChocolateQuest.config.dungeonSeparation : TerrainManager.instance.territorySeparation;
    }

    public boolean isDungeonSpawned(String name) {
        return this.uniqueDungeonsSpawned.contains(name);
    }

    public void dungeonSpawned(String name) {
        this.uniqueDungeonsSpawned.add(name);
    }

    public void addTeleportPoint(String name, ChunkCoordinates coords) {
        for (NamedCoordinates coord : this.teleportPoints) {
            if (!coord.name.equals(name)) continue;
            coord.x = coords.field_71574_a;
            coord.y = coords.field_71572_b;
            coord.z = coords.field_71573_c;
            return;
        }
        this.teleportPoints.add(new NamedCoordinates(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, name));
    }

    public ChunkCoordinates getTeleportPoint(String name) {
        for (NamedCoordinates coords : this.teleportPoints) {
            if (!coords.name.equals(name)) continue;
            return new ChunkCoordinates(coords.x, coords.y, coords.z);
        }
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        int i;
        int tags;
        this.territorySeparation = tag.func_74762_e("Separation");
        NBTTagList list = (NBTTagList)tag.func_74781_a("dungeons");
        if (list != null && (tags = list.func_74745_c()) > 0) {
            for (i = 0; i < tags; ++i) {
                this.uniqueDungeonsSpawned.add(list.func_150305_b(i).func_74779_i("name"));
            }
        }
        if (tag.func_74764_b("teleportPoints") && (list = (NBTTagList)tag.func_74781_a("teleportPoints")) != null && (tags = list.func_74745_c()) > 0) {
            for (i = 0; i < tags; ++i) {
                NBTTagCompound tempTag = list.func_150305_b(i);
                int x = tempTag.func_74762_e("x");
                int y = tempTag.func_74762_e("y");
                int z = tempTag.func_74762_e("z");
                String name = tempTag.func_74779_i("name");
                NamedCoordinates coords = new NamedCoordinates(x, y, z, name);
                this.teleportPoints.add(coords);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        int i;
        tag.func_74768_a("Separation", this.territorySeparation);
        NBTTagList list = new NBTTagList();
        for (i = 0; i < this.uniqueDungeonsSpawned.size(); ++i) {
            NBTTagCompound nameTag = new NBTTagCompound();
            nameTag.func_74778_a("name", this.uniqueDungeonsSpawned.get(i));
            list.func_74742_a((NBTBase)nameTag);
        }
        tag.func_74782_a("dungeons", (NBTBase)list);
        if (!this.teleportPoints.isEmpty()) {
            list = new NBTTagList();
            for (i = 0; i < this.teleportPoints.size(); ++i) {
                NBTTagCompound tempTag = new NBTTagCompound();
                NamedCoordinates coords = this.teleportPoints.get(i);
                tempTag.func_74778_a("name", coords.name);
                tempTag.func_74768_a("x", coords.x);
                tempTag.func_74768_a("y", coords.y);
                tempTag.func_74768_a("z", coords.z);
                list.func_74742_a((NBTBase)tempTag);
            }
            tag.func_74782_a("teleportPoints", (NBTBase)list);
        }
    }
}

