/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.quest.worldManager;

import com.chocolate.chocolateQuest.utils.BDHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class KillCounter {
    public String playerName;
    public String name;
    private String monster;
    private NBTTagCompound tags;
    public int killAmmount;

    public KillCounter() {
    }

    public KillCounter(String playerName, String name, String monster, String tags) {
        this.playerName = playerName;
        this.name = name;
        this.monster = monster;
        if (tags != null) {
            try {
                this.tags = (NBTTagCompound)BDHelper.JSONToNBT(tags);
            }
            catch (NBTException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean entityMatchesCounter(EntityLivingBase entity) {
        return KillCounter.entityMatchesNameAndTags(entity, this.monster, this.tags);
    }

    public static boolean entityMatchesNameAndTags(EntityLivingBase entity, String monsterName, NBTTagCompound tags) {
        String entityName = EntityList.func_75621_b((Entity)entity);
        if (entityName == null) {
            return false;
        }
        if (entityName.equals(monsterName)) {
            if (tags != null) {
                NBTTagCompound tagEntity = new NBTTagCompound();
                entity.func_70014_b(tagEntity);
                if (!BDHelper.compareTags(tags, tagEntity)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("name", this.name);
        tag.func_74778_a("playerName", this.playerName);
        tag.func_74778_a("monster", this.monster);
        if (this.tags != null) {
            tag.func_74782_a("data", (NBTBase)this.tags);
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.name = tag.func_74779_i("name");
        this.playerName = tag.func_74779_i("playerName");
        this.monster = tag.func_74779_i("monster");
        if (tag.func_74764_b("data")) {
            this.tags = (NBTTagCompound)tag.func_74781_a("data");
        }
    }
}

