/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.quest;

import com.chocolate.chocolateQuest.quest.DialogOption;
import com.chocolate.chocolateQuest.quest.TextEntry;
import com.chocolate.chocolateQuest.utils.BDHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DialogManager {
    static Map<String, TextEntry> currentEntries;
    static String currentFile;
    static final String nameTag = "@name:";
    static final String promptTag = "@prompt:";
    static final String endTag = "#####";

    public static void readText(String lang, DialogOption option) {
        DialogManager.loadOptions(lang, option.folder);
        TextEntry entry = currentEntries.get(option.name);
        if (entry == null) {
            entry = new TextEntry();
        }
        if (entry.text == null) {
            entry.text = new String[]{"(@name stares at you)"};
        }
        if (entry.name == null || entry.name.isEmpty()) {
            entry.name = option.name;
        }
        if (entry.prompt == null || entry.prompt.isEmpty()) {
            entry.prompt = option.name;
        }
        option.name = entry.name;
        option.prompt = entry.prompt;
        option.text = entry.text;
    }

    public static void loadOptions(String lang, String fileName) {
        if (currentFile != fileName) {
            currentFile = fileName;
            currentEntries = new HashMap<String, TextEntry>();
            File file = new File(BDHelper.getAppDir(), DialogManager.getDefaultFileName(fileName));
            DialogManager.loadTagsFromFile(file);
            file = new File(BDHelper.getAppDir(), DialogManager.getDefaultFileNameWithLang(fileName, lang));
            DialogManager.loadTagsFromFile(file);
        }
    }

    public static String[] getOptionNames(String fileName) {
        DialogManager.loadOptions("en_UK", fileName);
        if (currentEntries != null && !currentEntries.isEmpty()) {
            String[] names = new String[currentEntries.size()];
            Object[] entries = currentEntries.values().toArray();
            for (int i = 0; i < names.length; ++i) {
                names[i] = ((TextEntry)entries[i]).name;
            }
            return names;
        }
        return null;
    }

    protected static boolean loadTagsFromFile(File file) {
        try {
            BufferedReader stream;
            if (file.exists()) {
                String[] text;
                String line;
                stream = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                ArrayList<String> list = new ArrayList<String>();
                TextEntry currentEntry = null;
                while ((line = stream.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    if (line.startsWith(nameTag)) {
                        if (currentEntry != null) {
                            text = new String[list.size()];
                            list.toArray(text);
                            currentEntry.text = text;
                            currentEntries.put(currentEntry.name, currentEntry);
                            list.clear();
                        }
                        currentEntry = new TextEntry();
                        currentEntry.name = line.replace(nameTag, "");
                        continue;
                    }
                    if (line.startsWith(promptTag) && currentEntry != null) {
                        currentEntry.prompt = line.replace(promptTag, "");
                        continue;
                    }
                    if (currentEntry == null) continue;
                    list.add(line);
                }
                if (currentEntry != null) {
                    text = new String[list.size()];
                    list.toArray(text);
                    currentEntry.text = text;
                    currentEntries.put(currentEntry.name, currentEntry);
                }
            } else {
                return false;
            }
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected static String getDefaultFileName(String fileName) {
        return BDHelper.getInfoDir() + fileName + ".dialog";
    }

    protected static String getDefaultFileNameWithLang(String fileName, String lang) {
        return BDHelper.getInfoDir() + fileName + "." + lang + ".dialog";
    }

    public static void saveText(DialogOption option) {
        ArrayList list = new ArrayList();
        try {
            TextEntry current;
            File file = new File(BDHelper.getAppDir(), DialogManager.getDefaultFileName(option.folder));
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            if ((current = currentEntries.get(option.name)) == null) {
                current = new TextEntry(option.name, option.prompt, option.text);
                currentEntries.put(option.name, current);
            } else {
                current.prompt = option.prompt;
                current.text = option.text;
            }
            FileWriter writer = new FileWriter(file);
            BufferedWriter stream = new BufferedWriter(writer);
            for (TextEntry entry : currentEntries.values()) {
                stream.write(nameTag + entry.name);
                stream.newLine();
                stream.write(promptTag + entry.prompt);
                stream.newLine();
                for (String line : entry.text) {
                    stream.write(line);
                    stream.newLine();
                }
                stream.write(endTag);
                stream.newLine();
            }
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

