/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.magic;

import com.chocolate.chocolateQuest.magic.ElementDamageSource;
import com.chocolate.chocolateQuest.magic.ElementDamageSourceBlast;
import com.chocolate.chocolateQuest.magic.ElementDamageSourceDark;
import com.chocolate.chocolateQuest.magic.ElementDamageSourceFire;
import com.chocolate.chocolateQuest.magic.ElementDamageSourceLight;
import com.chocolate.chocolateQuest.magic.ElementDamageSourceMagic;
import com.chocolate.chocolateQuest.magic.ElementDamageSourceNature;
import com.chocolate.chocolateQuest.magic.IElementHolder;
import com.chocolate.chocolateQuest.utils.HelperDamageSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;

public enum Elements {
    physic("physic", new ElementDamageSourceNature(), 1.0, "2", "physic", 0x88AA88, "random.bow"),
    magic("magic", new ElementDamageSourceMagic(), 0.75, "3", "magic", 0x33CCFF, "mob.wither.shoot"),
    blast("blast", new ElementDamageSourceBlast(), 0.5, "5", "blast", 0x9999CC, "random.fizz"),
    fire("fire", new ElementDamageSourceFire(), 1.0, "6", "fire", 0xFF9900, "mob.ghast.fireball"),
    light("light", new ElementDamageSourceLight(), 1.0, "e", "light", 0xFFFF99, "mob.zombie.unfect"),
    darkness("darkness", new ElementDamageSourceDark(), 1.0, "8", "dark", 0x440044, "mob.zombie.infect"),
    water("water", new ElementDamageSourceNature(), 1.0, "8", "????", 0xAAAAFF, "");

    String name;
    public ElementDamageSource damageSource;
    public double ammountMultiplier;
    public String stringColor;
    public String particle;
    int color;
    public String sound;

    private Elements(String s, ElementDamageSource ds, double dmgMultiplier, String stringColor, String particle, int color, String sound) {
        this.name = s;
        this.damageSource = ds;
        this.ammountMultiplier = dmgMultiplier;
        this.stringColor = stringColor;
        this.particle = particle;
        this.color = color;
        this.sound = sound;
    }

    public boolean attackWithElement(EntityLivingBase target, EntityLivingBase shooter, float damage) {
        damage = this.onHitEntity((Entity)shooter, (Entity)target, damage);
        DamageSource ds = this.getDamageSource((Entity)shooter);
        return target.func_70097_a(ds, damage);
    }

    public boolean attackWithElementProjectile(EntityLivingBase target, EntityLivingBase shooter, Entity projectile, float damage) {
        return this.attackWithElementProjectile(target, shooter, projectile, damage, true);
    }

    public boolean attackWithElementProjectile(EntityLivingBase target, EntityLivingBase shooter, Entity projectile, float damage, boolean knockBack) {
        damage = this.onHitEntity((Entity)shooter, (Entity)target, damage);
        DamageSource ds = this.getDamageSourceIndirect((Entity)shooter, projectile);
        if (knockBack) {
            return target.func_70097_a(ds, damage);
        }
        return HelperDamageSource.attackEntityWithoutKnockBack((Entity)target, ds, damage);
    }

    public DamageSource getDamageSource(Entity shooter) {
        return this.damageSource.getDamageSource(shooter, this.name);
    }

    public DamageSource getDamageSourceIndirect(Entity shooter, Entity projectile) {
        return this.damageSource.getIndirectDamage(projectile, shooter, this.name);
    }

    public DamageSource getDamageSource() {
        return this.damageSource.getDamageSource(this.name);
    }

    public float onHitEntity(Entity source, Entity entityHit, float damage) {
        return this.damageSource.onHitEntity(source, entityHit, damage);
    }

    public String getTranslatedName() {
        return StatCollector.func_74838_a((String)("element." + this.name + ".name"));
    }

    public String getName() {
        return this.name;
    }

    public String getStringColor() {
        return this.stringColor;
    }

    public String getSound() {
        return this.sound;
    }

    public String getParticle() {
        return this.particle;
    }

    public float getColorX() {
        return (float)(this.color >> 16 & 0xFF) / 256.0f;
    }

    public float getColorY() {
        return (float)(this.color >> 8 & 0xFF) / 256.0f;
    }

    public float getColorZ() {
        return (float)(this.color >> 0 & 0xFF) / 256.0f;
    }

    public static int getElementValue(ItemStack is, Elements element) {
        if (!Elements.hasElements(is)) {
            return 0;
        }
        float damage = 0.0f;
        NBTBase tag = is.field_77990_d.func_74781_a("elements");
        if (tag instanceof NBTTagCompound) {
            return ((NBTTagCompound)tag).func_74771_c(element.getName());
        }
        return 0;
    }

    public static float getElementDamage(ItemStack is, Elements element) {
        float damage = Elements.getElementValue(is, element);
        if (is.func_77973_b() instanceof IElementHolder) {
            damage *= ((IElementHolder)is.func_77973_b()).getElementModifier(is, element);
        }
        return damage;
    }

    public static void setElementValue(ItemStack is, Elements element, int value) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        if (is.func_77973_b() instanceof ItemArmor) {
            value = Math.min(4, value);
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a(element.getName(), (byte)value);
        is.field_77990_d.func_74782_a("elements", (NBTBase)tag);
    }

    public static boolean hasElements(ItemStack is) {
        if (is.field_77990_d == null) {
            return false;
        }
        return is.field_77990_d.func_74764_b("elements");
    }
}

