/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.items;

import com.chocolate.chocolateQuest.client.ClientProxy;
import com.chocolate.chocolateQuest.magic.Awakements;
import com.chocolate.chocolateQuest.magic.Elements;
import com.chocolate.chocolateQuest.utils.BDHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class ItemArmorBase
extends ItemArmor {
    String name;
    boolean isEpic = false;
    public static final ItemArmor.ArmorMaterial DRAGON = EnumHelper.addArmorMaterial((String)"DRAGON", (int)55, (int[])new int[]{4, 9, 7, 4}, (int)15);
    public static final ItemArmor.ArmorMaterial TURTLE = EnumHelper.addArmorMaterial((String)"TURTLE", (int)45, (int[])new int[]{3, 8, 6, 3}, (int)25);
    public static final ItemArmor.ArmorMaterial MONSTER_FUR = EnumHelper.addArmorMaterial((String)"MONSTER_FUR", (int)45, (int[])new int[]{2, 7, 5, 2}, (int)25);
    public static final ItemArmor.ArmorMaterial MAGE_ROBE = EnumHelper.addArmorMaterial((String)"MAGE_ROBE", (int)20, (int[])new int[]{2, 4, 3, 2}, (int)25);
    public static final String[] CLOTH_OVERLAY_NAMES = new String[]{"overlay_helmet", "overlay_plate", "overlay_pants", "overlay_boots"};
    public static final int HELMET = 0;
    public static final int PLATE = 1;
    public static final int LEGS = 2;
    public static final int BOOTS = 3;
    boolean isColoreable = false;
    int defaultColor = 0xFFFFFF;
    @SideOnly(value=Side.CLIENT)
    private IIcon overlayIcon;

    public ItemArmorBase(ItemArmor.ArmorMaterial material, int renderIndex) {
        super(material, 0, renderIndex);
    }

    public ItemArmorBase(ItemArmor.ArmorMaterial material, int renderIndex, String name) {
        this(material, renderIndex);
        this.name = name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A());
        if (this.isColoreable) {
            this.overlayIcon = iconRegister.func_94245_a("chocolateQuest:" + CLOTH_OVERLAY_NAMES[this.field_77881_a]);
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String layer) {
        if (slot == 2) {
            return "chocolatequest:textures/armor/" + this.name + "_2.png";
        }
        return "chocolatequest:textures/armor/" + this.name + ".png";
    }

    public boolean func_77623_v() {
        return this.isColoreable;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        if (pass == 1) {
            return this.overlayIcon;
        }
        return this.field_77791_bV;
    }

    public int func_82790_a(ItemStack is, int i) {
        if (i == 1) {
            NBTTagCompound tag;
            NBTBase tagbase;
            if (this.func_82816_b_(is) && is.field_77990_d != null && is.field_77990_d.func_74764_b("display") && (tagbase = is.field_77990_d.func_74781_a("display")) instanceof NBTTagCompound && (tag = (NBTTagCompound)tagbase).func_74764_b("color")) {
                return tag.func_74762_e("color");
            }
            return this.defaultColor;
        }
        return 0xFFFFFF;
    }

    public boolean func_82816_b_(ItemStack is) {
        return this.isColoreable && is.field_77990_d != null && is.field_77990_d.func_74764_b("display") || super.func_82816_b_(is);
    }

    public void func_77624_a(ItemStack is, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(is, player, list, par4);
        if (is.field_77990_d != null) {
            if (is.field_77990_d.func_74764_b("tier")) {
                list.add(StatCollector.func_74838_a((String)"strings.tier") + ": " + this.getTier(is));
            }
            if (this.hasCape(is)) {
                list.add("Cape: " + this.getCape(is));
            }
            if (this.hasApron(is)) {
                list.add("Apron: " + this.getApron(is));
            }
            if (Awakements.hasEnchant(is, Awakements.elementProtection)) {
                Elements[] elements = Elements.values();
                String reduction = "";
                for (int i = 0; i < 4; ++i) {
                    float ammount = -(5.0f + (float)Elements.getElementValue(is, elements[i]) * 3.75f);
                    reduction = reduction.concat(BDHelper.StringColor(elements[i].stringColor) + " " + ammount + "%");
                }
                list.add(reduction);
            }
        }
        if (this.isEpic()) {
            for (Awakements a : Awakements.awekements) {
                if (!Awakements.hasEnchant(is, a)) continue;
                list.add(a.getDescription(is));
            }
        }
        if (this.hasFullSetBonus()) {
            list.add(EnumChatFormatting.DARK_AQUA + StatCollector.func_74838_a((String)"armorbonus.full_set.name").trim());
            list.add(" " + EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)("armorbonus." + this.getFullSetBonus() + ".name")).trim());
        }
    }

    public WeightedRandomChestContent getChestGenBase(ChestGenHooks chest, Random rnd, WeightedRandomChestContent original) {
        ItemStack is = original.field_76297_b;
        int armorType = ((ItemArmor)is.func_77973_b()).field_77881_a;
        if (rnd.nextInt(20) == 0) {
            double health = BDHelper.getRandomValue(rnd) * 10.0;
            BDHelper.addAttribute(is, SharedMonsterAttributes.field_111267_a.func_111108_a(), new AttributeModifier(field_111210_e, armorType + "Health", health, 0));
        }
        if (rnd.nextInt(20) == 0) {
            double attack = BDHelper.getRandomValue(rnd) * 2.0;
            BDHelper.addAttribute(is, SharedMonsterAttributes.field_111264_e.func_111108_a(), new AttributeModifier(field_111210_e, armorType + "Attack", attack, 0));
        }
        if (rnd.nextInt(20) == 0) {
            double knockBack = BDHelper.getRandomValue(rnd) * 0.5;
            BDHelper.addAttribute(is, SharedMonsterAttributes.field_111266_c.func_111108_a(), new AttributeModifier(field_111210_e, armorType + "KB", knockBack, 0));
        }
        if (rnd.nextInt(20) == 0) {
            double speed = BDHelper.getRandomValue(rnd) * 0.2;
            BDHelper.addAttribute(is, SharedMonsterAttributes.field_111263_d.func_111108_a(), new AttributeModifier(field_111210_e, armorType + "Speed", speed, 2));
        }
        return original;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        this.onUpdateEquiped(itemStack, world, (EntityLivingBase)player);
        if (this.isEpic()) {
            if (Awakements.hasEnchant(itemStack, Awakements.property)) {
                Awakements.property.onUpdate((Entity)player, itemStack);
            }
            if (Awakements.hasEnchant(itemStack, Awakements.autoRepair)) {
                Awakements.autoRepair.onUpdate((Entity)player, itemStack);
            }
            if (Awakements.hasEnchant(itemStack, Awakements.staminaUP)) {
                Awakements.staminaUP.onUpdate((Entity)player, itemStack);
            }
        }
    }

    public void onUpdateEquiped(ItemStack itemStack, World world, EntityLivingBase entity) {
    }

    public int func_82814_b(ItemStack par1ItemStack) {
        return 0xFFFFFF;
    }

    public ItemArmorBase setEpic() {
        this.isEpic = true;
        return this;
    }

    public boolean isEpic() {
        return this.isEpic;
    }

    public boolean hasFullSetBonus() {
        return false;
    }

    public String getFullSetBonus() {
        return "unspecified";
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (this.isEpic) {
            if (Awakements.hasEnchant(itemStack, Awakements.property)) {
                Awakements.property.onUpdate(entity, itemStack);
            }
            if (Awakements.hasEnchant(itemStack, Awakements.autoRepair)) {
                Awakements.autoRepair.onUpdate(entity, itemStack);
            }
        }
    }

    public void onHit(LivingHurtEvent event, ItemStack is, EntityLivingBase entity) {
    }

    public String func_77653_i(ItemStack itemstack) {
        return super.func_77653_i(itemstack);
    }

    public boolean isFullSet(EntityLivingBase e, ItemStack itemstack) {
        for (int i = 1; i < 5; ++i) {
            ItemStack is = e.func_71124_b(i);
            if (is == null) {
                return false;
            }
            if (is.func_77973_b().getClass() == itemstack.func_77973_b().getClass()) continue;
            return false;
        }
        return true;
    }

    public Item func_77655_b(String name) {
        this.func_111206_d("chocolateQuest:" + name);
        return super.func_77655_b(name);
    }

    public boolean hasApron(ItemStack is) {
        if (is.func_77978_p() == null) {
            return false;
        }
        return is.func_77978_p().func_74764_b("apron");
    }

    public int getApron(ItemStack is) {
        return is.func_77978_p().func_74762_e("apron");
    }

    public boolean hasCape(ItemStack is) {
        if (is.func_77978_p() == null) {
            return false;
        }
        return is.func_77978_p().func_74764_b("cape");
    }

    public int getCape(ItemStack is) {
        return is.func_77978_p().func_74762_e("cape");
    }

    public void setCape(ItemStack is, int capeID) {
        is.func_77978_p().func_74768_a("cape", capeID);
    }

    public int getTier(ItemStack is) {
        if (is.func_77978_p() == null) {
            return 0;
        }
        return is.func_77978_p().func_74762_e("tier");
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (armorSlot == 1) {
            return ClientProxy.defaultArmor;
        }
        return null;
    }
}

