/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.gui.guiParty;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.EntityHumanBase;
import com.chocolate.chocolateQuest.gui.GuiHumanBase;
import com.chocolate.chocolateQuest.gui.guiParty.ButtonAction;
import com.chocolate.chocolateQuest.gui.guiParty.PartyAction;
import com.chocolate.chocolateQuest.packets.PacketPartyMemberAction;
import com.chocolate.chocolateQuest.utils.BDHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovingObjectPosition;
import org.lwjgl.opengl.GL11;

public class GuiButtonPartyMember
extends GuiButton {
    MovingObjectPosition playerMop;
    EntityHumanBase[] entity;
    ButtonAction[] actions = new ButtonAction[4];
    ButtonAction[] allActions = null;
    boolean extended;
    boolean pressed;
    static final int ENTITY_AVATAR_SEPARATION = 8;
    static final int ICON_SIZE = 16;
    static final int ICON_SEPARATION = 2;
    static final int EXTENSION_BUTTON_X = 90;
    static final int EXTENSION_BUTTON_Y = 9;
    static final int EXTENSION_BUTTON_SIZE = 7;
    int xOffset = 0;
    int yOffset = 0;
    public boolean isSelected;
    boolean holdingButton = false;
    int buttonHeld = 0;
    boolean renderEntity = true;

    public GuiButtonPartyMember(int id, int x, int y, EntityHumanBase entity) {
        super(id, x, y, "");
        this.entity = new EntityHumanBase[]{entity};
        this.field_146120_f = 100;
        this.actions[0] = new ButtonAction(0, 0, PartyAction.move.id);
        this.actions[1] = new ButtonAction(0, 0, PartyAction.follow.id);
        this.actions[2] = new ButtonAction(0, 0, PartyAction.formation.id);
        this.actions[3] = new ButtonAction(0, 0, PartyAction.flee.id);
    }

    public GuiButtonPartyMember(int id, int x, int y, EntityHumanBase[] entities) {
        this(id, x, y, entities[0]);
        this.entity = entities;
        this.renderEntity = false;
    }

    public void init(MovingObjectPosition playerMop) {
        this.playerMop = playerMop;
        ButtonAction defaultAction = null;
        defaultAction = playerMop.field_72308_g != null ? (this.getEntity().isSuitableMount(playerMop.field_72308_g) ? new ButtonAction(0, 0, PartyAction.mount.id) : new ButtonAction(0, 0, PartyAction.attack.id)) : new ButtonAction(0, 0, PartyAction.move.id);
        this.actions[0] = defaultAction;
        this.moveActionButtons();
    }

    public void moveActionButtons() {
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i].xPosition = this.field_146128_h + 16 + i * 18;
            this.actions[i].yPosition = this.field_146129_i + 1;
        }
    }

    public void func_146112_a(Minecraft mc, int x, int y) {
        if (this.pressed) {
            this.field_146128_h = x + this.xOffset;
            this.field_146129_i = y + this.yOffset;
            this.moveActionButtons();
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(BDHelper.guiButtonsTexture);
        int textureX = 128;
        int textureY = 128;
        if (this.renderEntity) {
            this.func_73729_b(this.field_146128_h, this.field_146129_i, textureX, textureY + 20, this.field_146120_f, this.field_146121_g);
            this.func_73729_b(this.field_146128_h, this.field_146129_i, textureX, textureY, (int)((float)this.field_146120_f * this.getEntity().func_110143_aJ() / this.getEntity().func_110138_aP()), this.field_146121_g);
        } else {
            this.func_73729_b(this.field_146128_h, this.field_146129_i, textureX, textureY + 60, this.field_146120_f, this.field_146121_g);
        }
        if (this.isSelected) {
            this.func_73729_b(this.field_146128_h, this.field_146129_i, textureX, textureY + 40, this.field_146120_f, this.field_146121_g);
        }
        this.drawSubButtons(this.actions, x, y);
        if (this.isMouseOverExtensionButton(x, y)) {
            GL11.glColor4f((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        textureX = 128 + this.field_146120_f;
        textureY = 128;
        this.func_73729_b(this.field_146128_h + 90, this.field_146129_i + 9, textureX, textureY, 7, 7);
        if (this.extended) {
            this.drawSubButtons(this.allActions, x, y);
        }
        if (this.holdingButton) {
            ButtonAction button = this.allActions[this.buttonHeld];
            this.drawIcon(224 + button.getIcon(), x, y);
        }
        if (this.renderEntity) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.field_146128_h + this.field_146120_f - 8), (float)(this.field_146129_i + 3), (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(this.getEntity().potionCount + "", 0, 0, 0xFFFFFF);
            GL11.glPopMatrix();
            GuiHumanBase.drawEntity((EntityLivingBase)this.getEntity(), this.field_146128_h + 8, this.field_146129_i + this.field_146121_g - 2, 8.0f);
        }
    }

    public boolean func_146116_c(Minecraft mc, int x, int y) {
        boolean b = super.func_146116_c(mc, x, y);
        if (b) {
            boolean actionPerformed = false;
            for (int i = 0; i < this.actions.length; ++i) {
                if (!this.actions[i].isMouseOver(x, y)) continue;
                actionPerformed = true;
            }
            if (this.isMouseOverExtensionButton(x, y)) {
                actionPerformed = true;
            }
            if (!actionPerformed) {
                this.pressed = true;
                this.xOffset = this.field_146128_h - x;
                this.yOffset = this.field_146129_i - y;
            }
        } else if (this.extended) {
            for (int i = 0; i < this.allActions.length; ++i) {
                if (!this.allActions[i].isMouseOver(x, y)) continue;
                b = true;
                this.holdingButton = true;
                this.buttonHeld = i;
            }
        }
        return b;
    }

    public void func_146118_a(int x, int y) {
        super.func_146118_a(x, y);
        boolean holdingButton = this.holdingButton;
        this.holdingButton = false;
        if (this.pressed) {
            this.pressed = false;
        } else {
            int i;
            for (i = 0; i < this.actions.length; ++i) {
                if (!this.actions[i].isMouseOver(x, y)) continue;
                if (holdingButton && this.allActions != null && i != 0) {
                    ButtonAction original = this.allActions[this.buttonHeld];
                    this.actions[i] = new ButtonAction(original.xPosition, original.yPosition, original.action.id);
                    this.moveActionButtons();
                    return;
                }
                this.sendActionToServer(this.actions[i]);
            }
            if (this.extended) {
                for (i = 0; i < this.allActions.length; ++i) {
                    if (!this.allActions[i].isMouseOver(x, y)) continue;
                    this.sendActionToServer(this.allActions[i]);
                }
            }
            if (this.isMouseOverExtensionButton(x, y)) {
                boolean bl = this.extended = !this.extended;
                if (this.extended) {
                    this.allActions = new ButtonAction[PartyAction.actions.size()];
                    for (i = 0; i < this.allActions.length; ++i) {
                        int xPos = this.field_146128_h + i % 6 * 18;
                        int yPos = this.field_146129_i + 20 + 18 * (i / 6);
                        this.allActions[i] = new ButtonAction(xPos, yPos, PartyAction.actions.get((int)i).id);
                    }
                } else {
                    this.allActions = null;
                }
            }
        }
    }

    public void sendActionToServer(ButtonAction action) {
        for (EntityHumanBase e : this.entity) {
            PacketPartyMemberAction packet = new PacketPartyMemberAction(e, action.action, this.playerMop, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            ChocolateQuest.channel.sendPaquetToServer(packet);
        }
    }

    public void drawIcon(int icon, int xPos, int yPos) {
        int ICONS_PER_ROW = 16;
        this.func_73729_b(xPos, yPos, icon % ICONS_PER_ROW * 16, icon / ICONS_PER_ROW * 16, 16, 16);
    }

    public String getHoveringText(int x, int y) {
        int i;
        for (i = 0; i < this.actions.length; ++i) {
            if (!this.actions[i].isMouseOver(x, y)) continue;
            return this.actions[i].getName();
        }
        if (this.extended) {
            for (i = 0; i < this.allActions.length; ++i) {
                if (!this.allActions[i].isMouseOver(x, y)) continue;
                return this.allActions[i].getName();
            }
        }
        return null;
    }

    public boolean isMouseOverExtensionButton(int x, int y) {
        return x >= this.field_146128_h + 90 && y >= this.field_146129_i + 9 && x < this.field_146128_h + 90 + 7 && y < this.field_146129_i + 9 + 7;
    }

    public void drawSubButtons(ButtonAction[] buttons, int x, int y) {
        for (int i = 0; i < buttons.length; ++i) {
            if (buttons[i].isMouseOver(x, y)) {
                GL11.glColor4f((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
            } else {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.drawIcon(224 + buttons[i].getIcon(), buttons[i].xPosition, buttons[i].yPosition);
        }
    }

    public EntityHumanBase getEntity() {
        return this.entity[0];
    }
}

