/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.projectile;

import com.chocolate.chocolateQuest.entity.projectile.EntityBaseBall;
import com.chocolate.chocolateQuest.entity.projectile.ProjectileMagicAimed;
import com.chocolate.chocolateQuest.magic.Elements;
import com.chocolate.chocolateQuest.particles.EffectManager;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;

public class ProjectileMagicShield
extends ProjectileMagicAimed {
    final float DAMAGE = 0.33f;
    int deathTime = 0;
    final int MAX_HEALTH = 600;
    final int HEALTH_PER_LEVEL = 200;

    public ProjectileMagicShield(EntityBaseBall entity) {
        super(entity);
    }

    public ProjectileMagicShield(EntityBaseBall entity, Entity aimedTo) {
        this(entity, aimedTo, 0);
    }

    public ProjectileMagicShield(EntityBaseBall entity, Entity aimedTo, int ticksToStartAim) {
        super(entity, aimedTo);
    }

    @Override
    public void onUpdateInAir() {
        ++this.deathTime;
        this.entity.field_70181_x = 0.0;
        this.entity.field_70179_y = 0.0;
        this.entity.field_70159_w = 0.0;
        if (this.aimedTo != null && this.entity.field_70173_aa > this.ticksToStartAim && this.aimedTo != null && !this.entity.field_70170_p.field_72995_K) {
            int lifeTime = this.entity.field_70173_aa;
            double x = this.aimedTo.field_70165_t + Math.cos((float)lifeTime / 20.0f) * 2.0;
            double z = this.aimedTo.field_70161_v + Math.sin((float)lifeTime / 20.0f) * 2.0;
            this.entity.func_70107_b(x, this.aimedTo.field_70163_u, z);
            double dist = 0.3;
            AxisAlignedBB var3 = this.entity.field_70121_D.func_72314_b(dist, dist, dist);
            List list = this.entity.field_70170_p.func_72872_a(Entity.class, var3);
            for (Entity et : list) {
                EntityLivingBase e;
                if (!(et instanceof EntityLivingBase) || (e = (EntityLivingBase)et) == this.entity.func_85052_h()) continue;
                if (this.entity.func_85052_h() != null && this.entity.func_85052_h().func_96124_cp() != null && this.entity.func_85052_h().func_142014_c(e)) {
                    return;
                }
                Elements element = this.entity.getElement();
                float damage = 0.33f * this.entity.getDamageMultiplier();
                element.attackWithElementProjectile(e, this.entity.func_85052_h(), (Entity)this.entity, damage);
                this.deathTime += 30;
            }
        }
        if (this.deathTime > this.getMaxLifeTime()) {
            this.entity.func_70106_y();
        }
        if (this.entity.field_70170_p.field_72995_K) {
            Random rand = this.entity.field_70170_p.field_73012_v;
            EffectManager.spawnElementParticle(0, this.entity.field_70170_p, this.entity.field_70165_t + (double)rand.nextFloat() - 0.5, this.entity.field_70163_u + (double)rand.nextFloat() - 0.5, this.entity.field_70161_v + (double)rand.nextFloat() - 0.5, 0.0, 0.0, 0.0, this.entity.getElement());
        }
    }

    @Override
    public int getMaxLifeTime() {
        return 600 + 200 * this.entity.getlvl();
    }

    @Override
    public void onImpact(MovingObjectPosition par1MovingObjectPosition) {
    }
}

