/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.projectile;

import com.chocolate.chocolateQuest.entity.projectile.EntityBaseBall;
import com.chocolate.chocolateQuest.entity.projectile.ProjectileBase;
import com.chocolate.chocolateQuest.particles.EffectManager;
import com.chocolate.chocolateQuest.utils.HelperDamageSource;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.MovingObjectPosition;

public class ProjectileFireFalling
extends ProjectileBase {
    Random rand = new Random();

    public ProjectileFireFalling(EntityBaseBall entity) {
        super(entity);
    }

    @Override
    public int getTextureIndex() {
        int i = (int)((double)this.entity.field_70173_aa * 0.2 % 8.0);
        if (i >= 4) {
            i = 7 - i;
        }
        return (double)this.entity.field_70173_aa * 0.2 % 2.0 == 0.0 ? 242 : 243;
    }

    @Override
    public void onImpact(MovingObjectPosition mop) {
        if (!this.entity.field_70170_p.field_72995_K) {
            Entity e = mop.field_72308_g;
            if (e != null) {
                if (e instanceof EntityLivingBase) {
                    // empty if block
                }
            } else {
                if (this.entity.getlvl() >= 1 && this.entity.field_70170_p.func_147437_c(mop.field_72311_b, mop.field_72312_c + 1, mop.field_72309_d) && this.entity.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                    this.entity.field_70170_p.func_147449_b(mop.field_72311_b, mop.field_72312_c + 1, mop.field_72309_d, (Block)Blocks.field_150480_ab);
                }
                this.entity.func_70106_y();
            }
        }
    }

    @Override
    public float getGravityVelocity() {
        return 0.03f;
    }

    @Override
    public void onUpdateInAir() {
        this.entity.field_70159_w *= 0.8;
        this.entity.field_70179_y *= 0.8;
        float x = (float)Math.sin(Math.toRadians(this.entity.field_70177_z));
        float z = (float)Math.cos(Math.toRadians(this.entity.field_70177_z));
        double y = -Math.sin(Math.toRadians(this.entity.field_70125_A));
        if (this.entity.shootingEntity != null) {
            int dist = 2;
            List list = this.entity.field_70170_p.func_72839_b((Entity)this.entity.shootingEntity, this.entity.field_70121_D.func_72314_b((double)dist, (double)dist, (double)dist));
            for (Entity e : list) {
                if (!(e instanceof EntityLivingBase)) continue;
                e.func_70015_d(4);
                e.func_70097_a(HelperDamageSource.causeFireProjectileDamage((Entity)this.entity, (Entity)this.entity.shootingEntity), 1.0f);
            }
        }
        if (this.entity.field_70170_p.field_72995_K) {
            EffectManager.spawnParticle(3, this.entity.field_70170_p, this.entity.field_70165_t, this.entity.field_70163_u + 1.0, this.entity.field_70161_v, this.entity.field_70159_w + ((double)this.rand.nextFloat() - 0.5) / 8.0, this.entity.field_70181_x + ((double)this.rand.nextFloat() - 0.5) / 8.0 + 0.4, this.entity.field_70179_y + ((double)this.rand.nextFloat() - 0.5) / 8.0);
        }
    }

    @Override
    public float getSize() {
        return 1.2f;
    }

    @Override
    public boolean canBounce() {
        return false;
    }

    @Override
    public boolean longRange() {
        return false;
    }
}

