/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.mob;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.EntityHumanBase;
import com.chocolate.chocolateQuest.entity.mob.registry.DungeonMonstersBase;
import com.chocolate.chocolateQuest.gui.InventoryMedal;
import com.chocolate.chocolateQuest.items.mobControl.ItemMobToSpawner;
import com.chocolate.chocolateQuest.utils.BDHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityHumanMob
extends EntityHumanBase
implements IMob {
    DungeonMonstersBase monsterType;
    public boolean saveToSpawner = true;
    int leadership = 0;

    public EntityHumanMob(World world) {
        super(world);
        this.updateEntityAttributes();
        this.potionCount = this.field_70146_Z.nextInt(3);
        this.maxStamina = 20 + this.field_70170_p.field_73013_u.func_151525_a() * 20;
    }

    public DungeonMonstersBase getMonsterType() {
        return null;
    }

    protected void updateEntityAttributes() {
        this.monsterType = this.getMonsterType();
        if (!this.isBoss()) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.monsterType.getAttack());
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.monsterType.getHealth());
            this.func_70606_j((float)this.monsterType.getHealth());
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.monsterType.getRange());
        }
        this.entityTeam = this.monsterType.getTeamName();
        this.shieldID = this.monsterType.getFlagId();
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("isBoss", this.isBoss());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        if (nbttagcompound.func_74767_n("isBoss")) {
            this.setBoss();
        }
    }

    @Override
    public void readEntityFromSpawnerNBT(NBTTagCompound nbttagcompound, int spawnerX, int spawnerY, int spawnerZ) {
        super.readEntityFromSpawnerNBT(nbttagcompound, spawnerX, spawnerY, spawnerZ);
        this.func_110171_b(spawnerX, spawnerY, spawnerZ, 30);
        ItemStack rightHandItem = this.func_71124_b(0);
        if (rightHandItem != null && rightHandItem.func_77973_b() == ChocolateQuest.banner) {
            rightHandItem.func_77964_b(this.getTeamID());
        }
        if (this.leftHandItem != null && this.leftHandItem.func_77973_b() == ChocolateQuest.shield) {
            this.leftHandItem.func_77964_b(this.getTeamID());
        }
    }

    @Override
    protected boolean func_70085_c(EntityPlayer player) {
        if (this.func_142014_c((EntityLivingBase)player)) {
            return super.func_70085_c(player);
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        EntityPlayer p;
        if (!this.field_70170_p.field_72995_K && this.party != null && this.party.getLeader().equals(this) && !this.shouldDespawn && this.saveToSpawner && (p = this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)ChocolateQuest.config.distToDespawn)) == null) {
            int z;
            int y;
            int x;
            if (this.func_110175_bO()) {
                ChunkCoordinates coord = this.func_110172_bL();
                x = coord.field_71574_a;
                y = coord.field_71572_b;
                z = coord.field_71573_c;
            } else {
                x = MathHelper.func_76128_c((double)this.field_70165_t);
                y = MathHelper.func_76128_c((double)this.field_70163_u);
                z = MathHelper.func_76128_c((double)this.field_70161_v);
            }
            if (ItemMobToSpawner.saveToSpawner(x, y, z, this)) {
                if (this.party != null) {
                    for (int i = 0; i < this.party.getMembersLength(); ++i) {
                        EntityHumanBase e = this.party.getMember(i);
                        if (e == null) continue;
                        if (((Entity)e).field_70154_o != null) {
                            ((Entity)e).field_70154_o.func_70106_y();
                        }
                        e.func_70106_y();
                    }
                }
                if (this.field_70154_o != null) {
                    this.field_70154_o.func_70106_y();
                }
                this.func_70106_y();
            }
        }
        super.func_70636_d();
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        if (this.party == null) {
            double targetDistance = 10.0;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(targetDistance, 1.2, targetDistance));
            for (Entity entity : list) {
                EntityHumanBase human;
                if (!(entity instanceof EntityHumanBase) || !this.func_142014_c((EntityLivingBase)(human = (EntityHumanBase)entity))) continue;
                if (human.party == null) {
                    human.tryPutIntoPArty(human);
                }
                if (!human.party.tryToAddNewMember(this, false)) continue;
                return;
            }
        }
    }

    @Override
    public boolean canSprint() {
        return this.field_70170_p.field_73013_u.func_151525_a() >= EnumDifficulty.NORMAL.func_151525_a();
    }

    @Override
    public int getExhaustionOnStopSprint() {
        return 130 - this.field_70170_p.field_73013_u.func_151525_a() * 30;
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        this.field_70728_aV = (int)BDHelper.getEntityValue(this);
        if (this.isBoss()) {
            this.field_70728_aV *= 2;
        }
        super.func_70645_a(damageSource);
    }

    protected void func_70628_a(boolean killedByPlayer, int looting) {
        ItemStack mainDrop;
        super.func_70628_a(killedByPlayer, looting);
        int j = this.field_70146_Z.nextInt(3);
        if (looting > 0) {
            j += this.field_70146_Z.nextInt(looting + 1);
        }
        if ((mainDrop = this.getMainDrop()) != null) {
            for (int k = 0; k < j; ++k) {
                this.func_70099_a(mainDrop, 0.0f);
            }
        }
        if (killedByPlayer) {
            boolean flag = false;
            for (int i = 0; i < 4; ++i) {
                if (this.func_71124_b(i + 1) == null) continue;
                flag = true;
                break;
            }
            if (flag) {
                ItemStack secondDrop = this.getSecondaryDrop();
                for (int entityValue = (int)BDHelper.getEntityValue(this); entityValue > 0; entityValue -= 3) {
                    int k;
                    if (this.field_70146_Z.nextInt(10) == 0) {
                        for (k = 0; k < j; ++k) {
                            this.func_70099_a(new ItemStack(Items.field_151166_bC), 0.0f);
                        }
                        continue;
                    }
                    if (secondDrop == null || this.field_70146_Z.nextInt(10) != 0) continue;
                    for (k = 0; k < j; ++k) {
                        this.func_70099_a(secondDrop, 0.0f);
                    }
                }
            }
        }
    }

    public ItemStack getBossMedal() {
        ItemStack medal = new ItemStack(ChocolateQuest.medal);
        medal.field_77990_d = new NBTTagCompound();
        NBTTagCompound tagDisplay = new NBTTagCompound();
        tagDisplay.func_74778_a("mob", this.getEntityName());
        tagDisplay.func_74768_a("color", this.getMonsterType().getColor());
        medal.field_77990_d.func_74782_a("display", (NBTBase)tagDisplay);
        return medal;
    }

    protected ItemStack getMainDrop() {
        return null;
    }

    public ItemStack getSecondaryDrop() {
        return this.field_70146_Z.nextBoolean() ? new ItemStack(Items.field_151100_aR, 1, 4) : new ItemStack(Items.field_151074_bl);
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.field_70170_p.field_73013_u.func_151525_a() > EnumDifficulty.PEACEFUL.func_151525_a();
    }

    @Override
    public int getLeadershipValue() {
        return this.leadership;
    }

    public EntityHumanBase setBoss() {
        this.leadership = 1000;
        this.shouldDespawn = false;
        this.field_70180_af.func_75692_b(20, (Object)1);
        InventoryMedal bossDrop = new InventoryMedal((Entity)this);
        bossDrop.func_70299_a(0, this.getBossMedal());
        bossDrop.func_70305_f();
        return this;
    }

    public boolean isBoss() {
        return this.field_70180_af.func_75683_a(20) == 1;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
    }

    public String getEntityName() {
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        return "entity." + s + ".name";
    }
}

