/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.ai;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.EntityHumanBase;
import com.chocolate.chocolateQuest.items.swords.ItemCQBlade;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityParty {
    public static final int FRONT = 0;
    public static final int RIGHT = 90;
    public static final int BACK = 180;
    public static final int LEFT = -90;
    public static final int FRONT_RIGHT = 45;
    public static final int FRONT_LEFT = -45;
    public static final int BACK_RIGHT = 135;
    public static final int BACK_LEFT = -135;
    final int distanceToCaptain = 2;
    EntityHumanBase[] members = new EntityHumanBase[8];
    EntityHumanBase leader;
    EntityLivingBase[] potentialTargets = new EntityLivingBase[4];
    int[] targetsAggro = new int[4];
    NBTTagCompound partyTag = null;

    public void update() {
        int i;
        if (this.partyTag != null) {
            this.loadFromNBT(this.partyTag);
            this.partyTag = null;
        }
        for (i = 0; i < this.getMembersLength(); ++i) {
            EntityHumanBase e = this.getMember(i);
            if (e == null || !e.field_70128_L) continue;
            this.removeMember(e);
        }
        for (i = 0; i < this.targetsAggro.length; ++i) {
            if (this.potentialTargets[i] == null) continue;
            if (this.targetsAggro[i] > 1) {
                int n = i;
                this.targetsAggro[n] = this.targetsAggro[n] - 1;
            }
            if (this.potentialTargets[i].func_70089_S()) continue;
            this.setAggro(null, 0, i);
            this.sortTargets();
        }
    }

    public void addAggroToTarget(EntityLivingBase e, int aggro) {
        int i;
        for (i = 0; i < this.potentialTargets.length; ++i) {
            if (this.potentialTargets[i] != e) continue;
            int n = i;
            this.targetsAggro[n] = this.targetsAggro[n] + aggro;
            this.sortTargets();
            return;
        }
        for (i = 0; i < this.potentialTargets.length; ++i) {
            if (this.potentialTargets[i] != null) continue;
            this.setAggro(e, aggro, i);
            this.sortTargets();
            return;
        }
        for (i = this.potentialTargets.length - 1; i >= 0; --i) {
            if (this.potentialTargets[i] == null) continue;
            if (aggro < this.targetsAggro[i]) {
                this.setAggro(e, aggro, i);
                this.sortTargets();
            }
            return;
        }
        this.sortTargets();
    }

    public void setAggro(EntityLivingBase e, int aggro, int i) {
        this.potentialTargets[i] = e;
        this.targetsAggro[i] = aggro;
    }

    public void sortTargets() {
        int i;
        double[] targetsAggro = new double[this.potentialTargets.length];
        for (i = 0; i < this.potentialTargets.length; ++i) {
            if (this.potentialTargets[i] == null) continue;
            targetsAggro[i] = this.getLeader().func_70068_e((Entity)this.potentialTargets[i]);
        }
        for (i = 0; i < this.potentialTargets.length; ++i) {
            double max = 0.0;
            int index = i;
            for (int c = i; c < this.potentialTargets.length; ++c) {
                if (!(targetsAggro[c] > max) || this.potentialTargets[c] == null) continue;
                max = targetsAggro[c];
                index = c;
            }
            EntityLivingBase currentEntity = this.potentialTargets[index];
            double currentAggro = targetsAggro[index];
            this.potentialTargets[index] = this.potentialTargets[i];
            targetsAggro[index] = targetsAggro[i];
            this.potentialTargets[i] = currentEntity;
            targetsAggro[i] = currentAggro;
        }
    }

    public EntityLivingBase getTarget() {
        if (this.potentialTargets[0] == null || !this.potentialTargets[0].func_70089_S()) {
            this.sortTargets();
        }
        if (this.potentialTargets[0] == null) {
            return this.leader.func_70638_az();
        }
        return this.potentialTargets[0];
    }

    public void removeMember(EntityHumanBase entity) {
        EntityHumanBase leader;
        block3: {
            block2: {
                entity.party = null;
                if (entity != this.getLeader()) break block2;
                this.leader = null;
                entity.setCaptain(false);
                int newPos = this.getNewLeaderFromParty();
                EntityHumanBase e = this.getMember(newPos);
                if (e == null) break block3;
                this.members[newPos] = null;
                this.setLeader(e);
                break block3;
            }
            for (int i = 0; i < this.getMembersLength(); ++i) {
                if (!entity.func_70028_i((Entity)this.getMember(i))) continue;
                this.removeMember(i);
                break;
            }
        }
        if (!this.hasMembers() && (leader = this.getLeader()) != null) {
            leader.setOutOfParty();
            leader.setCaptain(false);
        }
    }

    public void cleanParty() {
        if (!this.leader.func_70089_S()) {
            this.leader = null;
            EntityHumanBase newLeader = this.getMember(this.getNewLeaderFromParty());
            if (newLeader != null) {
                this.setLeader(newLeader);
            }
        }
    }

    protected int getNewLeaderFromParty() {
        int bestEntityIndex = 0;
        int maxLevel = -9999;
        for (int i = 0; i < this.getMembersLength(); ++i) {
            int currentLevel;
            if (this.getMember(i) == null || (currentLevel = this.getEntityLevel(this.getMember(i))) <= maxLevel) continue;
            maxLevel = currentLevel;
            bestEntityIndex = i;
        }
        return bestEntityIndex;
    }

    public boolean tryToAddNewMember(EntityHumanBase newMember) {
        return this.tryToAddNewMember(newMember, false);
    }

    public boolean tryToAddNewMember(EntityHumanBase newMember, boolean replaceLeader) {
        if (!replaceLeader && this.isFull()) {
            return false;
        }
        if (this.getLeader() == null) {
            this.setLeader(newMember);
            return true;
        }
        if (newMember == this.getLeader()) {
            return false;
        }
        for (int i = 0; i < this.getMembersLength(); ++i) {
            if (!newMember.func_70028_i((Entity)this.getMember(i))) continue;
            return false;
        }
        if (newMember.party != null) {
            newMember.party.removeMember(newMember);
        }
        int newLevel = this.getEntityLevel(newMember);
        int leaderLevel = this.getEntityLevel(this.leader);
        if (replaceLeader && newLevel > leaderLevel) {
            this.setLeader(newMember);
            return true;
        }
        int skipThisOne = this.getSuggestedPosition(newMember);
        if (this.tryAddToSlot(skipThisOne, newMember, newLevel)) {
            return true;
        }
        for (int i = 0; i < this.getMembersLength(); ++i) {
            if (i == skipThisOne || !this.tryAddToSlot(i, newMember, newLevel)) continue;
            return true;
        }
        return false;
    }

    private boolean isFull() {
        for (int i = 0; i < this.getMembersLength(); ++i) {
            if (this.getMember(i) != null) continue;
            return false;
        }
        return true;
    }

    private boolean hasMembers() {
        for (int i = 0; i < this.getMembersLength(); ++i) {
            if (this.getMember(i) == null) continue;
            return true;
        }
        return false;
    }

    protected int getSuggestedPosition(EntityHumanBase e) {
        if (e.isHealer() || e.isRanged()) {
            if (this.getMember(6) == null) {
                return 6;
            }
            if (this.getMember(5) == null) {
                return 5;
            }
            if (this.getMember(7) == null) {
                return 7;
            }
            if (this.getMember(3) == null) {
                return 3;
            }
            if (this.getMember(4) == null) {
                return 4;
            }
            return 6;
        }
        if (this.getMember(1) == null) {
            return 1;
        }
        if (this.getMember(3) == null) {
            return 3;
        }
        if (this.getMember(4) == null) {
            return 4;
        }
        if (this.getMember(0) == null) {
            return 0;
        }
        if (this.getMember(2) == null) {
            return 2;
        }
        if (this.getMember(6) == null) {
            return 6;
        }
        if (this.getMember(5) == null) {
            return 5;
        }
        if (this.getMember(7) == null) {
            return 7;
        }
        return 7;
    }

    public int getAngleForSlot(int i) {
        switch (i) {
            case 0: {
                return -45;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 45;
            }
            case 3: {
                return -90;
            }
            case 4: {
                return 90;
            }
            case 5: {
                return 135;
            }
            case 6: {
                return 180;
            }
            case 7: {
                return -135;
            }
        }
        return 0;
    }

    public int getMembersLength() {
        return this.members.length;
    }

    protected void setMember(int index, EntityHumanBase newMember) {
        newMember.setInParty(this, this.getAngleForSlot(index), 2);
        this.members[index] = newMember;
    }

    public EntityHumanBase getMember(int i) {
        return this.members[i];
    }

    protected void removeMember(int i) {
        this.members[i].setOutOfParty();
        this.members[i] = null;
    }

    protected void setLeader(EntityHumanBase newLeader) {
        EntityHumanBase oldLeader = this.leader;
        this.leader = newLeader;
        this.leader.setInParty(this, 0, 2);
        newLeader.setCaptain(true);
        if (oldLeader != null) {
            oldLeader.setCaptain(false);
            oldLeader.setOutOfParty();
            this.tryToAddNewMember(oldLeader);
        }
    }

    public EntityHumanBase getLeader() {
        if (this.leader == null) {
            this.leader = this.getMember(this.getNewLeaderFromParty());
        }
        return this.leader;
    }

    protected boolean tryAddToSlot(int index, EntityHumanBase newMember, int newLevel) {
        EntityHumanBase current = this.getMember(index);
        if (current != null) {
            int memberLevel = this.getEntityLevel(current);
            if (newLevel > memberLevel) {
                current.setOutOfParty();
                this.setMember(index, newMember);
                this.tryToAddNewMember(current);
                return true;
            }
        } else {
            this.setMember(index, newMember);
            return true;
        }
        return false;
    }

    public int getEntityLevel(EntityHumanBase entity) {
        int value = EntityParty.getItemValue(entity.leftHandItem);
        for (int i = 0; i < 5; ++i) {
            value += EntityParty.getItemValue(entity.func_71124_b(i));
        }
        return value += entity.getLeadershipValue();
    }

    public static int getItemValue(ItemStack itemstack) {
        if (itemstack == null) {
            return 0;
        }
        Item item = itemstack.func_77973_b();
        if (item == ChocolateQuest.staffHeal) {
            return -20;
        }
        if (item instanceof ItemArmor) {
            return ((ItemArmor)item).func_82812_d().func_78044_b(2);
        }
        if (item instanceof ItemCQBlade) {
            return 4;
        }
        if (item instanceof ItemSword) {
            return 3;
        }
        if (item == ChocolateQuest.banner) {
            return 10;
        }
        return 0;
    }

    public String toString() {
        String name = "Leader: ";
        name = this.leader != null ? name + this.leader.func_145782_y() : name + "null";
        for (int i = 0; i < this.getMembersLength(); ++i) {
            name = name + ", " + i + ": ";
            name = this.getMember(i) != null ? name + this.getMember(i).func_145782_y() : name + "null";
        }
        return name;
    }

    public void saveToNBT(NBTTagCompound par1nbtTagCompound) {
        int x = MathHelper.func_76128_c((double)this.getLeader().field_70165_t);
        int y = MathHelper.func_76128_c((double)this.getLeader().field_70163_u);
        int z = MathHelper.func_76128_c((double)this.getLeader().field_70161_v);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.getMembersLength(); ++i) {
            EntityHumanBase e = this.getMember(i);
            if (e == null || e.field_70128_L) continue;
            NBTTagCompound eTag = new NBTTagCompound();
            eTag.func_74778_a("id", EntityList.func_75621_b((Entity)e));
            e.writeEntityToSpawnerNBT(eTag, x, y, z);
            list.func_74742_a((NBTBase)eTag);
        }
        par1nbtTagCompound.func_74782_a("Party", (NBTBase)list);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.partyTag = nbttagcompound;
    }

    private void loadFromNBT(NBTTagCompound nbttagcompound) {
        int x = MathHelper.func_76128_c((double)this.getLeader().field_70165_t);
        int y = MathHelper.func_76128_c((double)this.getLeader().field_70163_u);
        int z = MathHelper.func_76128_c((double)this.getLeader().field_70161_v);
        NBTTagList list = nbttagcompound.func_150295_c("Party", (int)nbttagcompound.func_74732_a());
        World world = this.getLeader().field_70170_p;
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound ridingNBT;
            Entity riding;
            NBTTagCompound eTag = list.func_150305_b(i);
            Entity e = EntityList.func_75615_a((NBTTagCompound)eTag, (World)world);
            if (!(e instanceof EntityHumanBase)) continue;
            EntityHumanBase human = (EntityHumanBase)EntityList.func_75615_a((NBTTagCompound)eTag, (World)world);
            human.readEntityFromSpawnerNBT(eTag, x, y, z);
            human.func_70107_b(human.field_70165_t, human.field_70163_u, human.field_70161_v);
            this.getLeader().tryPutIntoPArty(human);
            world.func_72838_d((Entity)human);
            if (eTag.func_74781_a("Riding") == null || (riding = EntityList.func_75615_a((NBTTagCompound)(ridingNBT = (NBTTagCompound)eTag.func_74781_a("Riding")), (World)world)) == null) continue;
            if (riding instanceof EntityHumanBase) {
                ((EntityHumanBase)riding).entityTeam = human.entityTeam;
            }
            riding.func_70107_b(human.field_70165_t, human.field_70163_u, human.field_70161_v);
            world.func_72838_d(riding);
            human.func_70078_a(riding);
        }
    }
}

