/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.ai;

import com.chocolate.chocolateQuest.builder.BuilderHelper;
import com.chocolate.chocolateQuest.builder.schematic.Schematic;
import com.chocolate.chocolateQuest.entity.ai.SchematicStorage;
import com.chocolate.chocolateQuest.entity.npc.EntityHumanNPC;
import com.chocolate.chocolateQuest.utils.BDHelper;
import com.chocolate.chocolateQuest.utils.Vec4I;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChunkCoordinates;

public class AIBuildSchematic
extends EntityAIBase {
    EntityHumanNPC owner;
    Schematic cachedSchematic;
    ChunkCoordinates home;
    public int buildingStep;
    boolean isFinished = false;
    int buildingDelay = 0;
    int buildSpeed = 1;
    List<SchematicStorage> buildingPlans = new ArrayList<SchematicStorage>();

    public AIBuildSchematic(EntityHumanNPC owner) {
        this.owner = owner;
        this.func_75248_a(7);
    }

    public boolean func_75250_a() {
        return this.hasBuildingPlans();
    }

    public boolean func_75253_b() {
        return this.cachedSchematic != null && !this.isFinished;
    }

    public void func_75249_e() {
        SchematicStorage currentPlans = this.buildingPlans.get(0);
        this.cachedSchematic = BuilderHelper.getNBTMap(currentPlans.name);
        if (this.cachedSchematic != null) {
            Vec4I v = this.owner.getPositionByName(currentPlans.position);
            this.home = new ChunkCoordinates(v.xCoord, v.yCoord, v.zCoord);
            this.cachedSchematic.setPosition(this.home.field_71574_a, this.home.field_71572_b, this.home.field_71573_c);
            this.buildSpeed = currentPlans.buildSpeed;
        } else {
            BDHelper.println("Can't find schematic " + currentPlans.name);
            this.buildingPlans.remove(0);
        }
    }

    public void func_75251_c() {
        this.isFinished = false;
        this.cachedSchematic = null;
        super.func_75251_c();
    }

    public void func_75246_d() {
        int speed = Math.max(1, this.buildSpeed);
        if (this.cachedSchematic != null) {
            for (int i = 0; i < speed; ++i) {
                if (this.buildingDelay > 0) {
                    --this.buildingDelay;
                    continue;
                }
                boolean blockPlaced = false;
                while (!blockPlaced) {
                    int step;
                    int schematicSize = this.cachedSchematic.width * this.cachedSchematic.length * this.cachedSchematic.height;
                    if ((step = this.buildingStep++) < schematicSize * 2) {
                        boolean isFirsPass;
                        boolean bl = isFirsPass = step < schematicSize;
                        if (!isFirsPass) {
                            step -= schematicSize;
                        }
                        if (BuilderHelper.builderHelper.buildStep(this.owner.func_70681_au(), this.owner.field_70170_p, this.cachedSchematic, step, isFirsPass, 0, false, false)) {
                            this.owner.func_71038_i();
                            this.buildingDelay = 20;
                            blockPlaced = true;
                        }
                        ++this.buildingStep;
                        continue;
                    }
                    blockPlaced = true;
                    int entityIndex = step - schematicSize * 2;
                    if (BuilderHelper.builderHelper.putEntities(this.owner.field_70170_p, this.cachedSchematic, entityIndex)) {
                        this.buildingDelay = 20;
                        continue;
                    }
                    this.isFinished = true;
                    this.buildingStep = 0;
                    this.buildingPlans.remove(0);
                    this.cachedSchematic = null;
                    return;
                }
            }
        }
    }

    public boolean hasBuildingPlans() {
        return this.buildingPlans.size() > 0;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("step", this.buildingStep);
        NBTTagList list = new NBTTagList();
        for (SchematicStorage schematic : this.buildingPlans) {
            NBTTagCompound schematicTag = new NBTTagCompound();
            schematicTag.func_74778_a("name", schematic.name);
            schematicTag.func_74778_a("pos", schematic.position);
            list.func_74742_a((NBTBase)schematicTag);
        }
        tag.func_74782_a("plans", (NBTBase)list);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.buildingStep = tag.func_74762_e("step");
        NBTTagList list = tag.func_150295_c("plans", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound t = list.func_150305_b(i);
            this.buildingPlans.add(new SchematicStorage(t.func_74779_i("name"), t.func_74779_i("pos"), t.func_74762_e("speed")));
        }
    }

    public void addBuildingPlans(String schematicName, String position, int speed) {
        this.buildingPlans.add(new SchematicStorage(schematicName, position, speed));
    }
}

