/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.quest.worldManager.TerrainManager;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityPortal
extends Entity
implements IEntityAdditionalSpawnData {
    public static final int STANDING = 0;
    public static final int ON_FLOOR = 1;
    public static final int INVISIBLE = 2;
    public int type;
    public ChunkCoordinates coords;
    public String name;

    public EntityPortal(World world) {
        super(world);
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K && this.field_70173_aa % 16 == 0) {
            this.field_70170_p.func_72869_a("portal", this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5), this.field_70163_u + (double)(this.field_70131_O / 2.0f) + (double)(this.field_70146_Z.nextFloat() - 0.5f), this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5), ((double)this.field_70146_Z.nextFloat() - 0.5) / 2.0, ((double)this.field_70146_Z.nextFloat() - 0.5) / 2.0, ((double)this.field_70146_Z.nextFloat() - 0.5) / 2.0);
        }
        super.func_70071_h_();
    }

    public boolean func_70097_a(DamageSource ds, float damage) {
        ItemStack is;
        if (ds.func_76346_g() instanceof EntityLivingBase && (is = ((EntityLivingBase)ds.func_76346_g()).func_71124_b(0)) != null && is.func_77973_b() == ChocolateQuest.magicPickaxe) {
            this.func_70106_y();
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int p_70056_9_) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.type = tag.func_74762_e("type");
        if (tag.func_74764_b("coords")) {
            NBTTagCompound tempTag = tag.func_74775_l("coords");
            int x = tempTag.func_74762_e("x");
            int y = tempTag.func_74762_e("y");
            int z = tempTag.func_74762_e("z");
            this.coords = new ChunkCoordinates(x, y, z);
        }
        if (tag.func_74764_b("name")) {
            this.name = tag.func_74779_i("name");
        }
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a("type", this.type);
        if (this.coords != null) {
            NBTTagCompound tempTag = new NBTTagCompound();
            tempTag.func_74768_a("x", this.coords.field_71574_a);
            tempTag.func_74768_a("y", this.coords.field_71572_b);
            tempTag.func_74768_a("z", this.coords.field_71573_c);
            tag.func_74782_a("coords", (NBTBase)tempTag);
        }
        if (this.name != null) {
            tag.func_74778_a("name", this.name);
        }
    }

    public void readSpawnData(ByteBuf buff) {
        this.type = buff.readInt();
        this.field_70177_z = buff.readInt();
        boolean hasName = buff.readBoolean();
        if (hasName) {
            int lenght = buff.readInt();
            byte[] nameBytes = new byte[lenght];
            this.name = "";
            for (int i = 0; i < lenght; ++i) {
                this.name = this.name + buff.readChar();
            }
        }
        this.resize();
    }

    public void writeSpawnData(ByteBuf buff) {
        buff.writeInt(this.type);
        buff.writeInt((int)this.field_70177_z);
        buff.writeBoolean(this.name != null);
        if (this.name != null) {
            buff.writeInt(this.name.length());
            for (int i = 0; i < this.name.length(); ++i) {
                buff.writeChar((int)this.name.charAt(i));
            }
        }
        this.resize();
    }

    private void resize() {
        if (this.type == 1) {
            this.func_70105_a(0.4f, 0.2f);
        } else {
            this.func_70105_a(0.4f, 1.8f);
        }
    }

    protected void func_70088_a() {
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public void func_70108_f(Entity e) {
        ChunkCoordinates coords = this.getDestCoordinates();
        if (coords != null && e.field_71088_bW == 0) {
            e.field_71088_bW = 40;
            Vec3 v = e.func_70040_Z();
            if (this.type == 1 || this.func_70040_Z().func_72430_b(v) > 0.0) {
                if (e instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)e).field_71135_a.func_147364_a((double)coords.field_71574_a + 0.5, (double)coords.field_71572_b, (double)coords.field_71573_c + 0.5, ((EntityPlayerMP)e).field_70759_as, e.field_70125_A);
                } else {
                    e.func_70107_b((double)coords.field_71574_a + 0.5, (double)coords.field_71572_b, (double)coords.field_71573_c + 0.5);
                }
            }
        }
    }

    public Vec3 func_70040_Z() {
        float rot = this.field_70177_z - 90.0f;
        double X = MathHelper.func_76134_b((float)(rot / 180.0f * (float)Math.PI));
        double Y = 0.0;
        double Z = MathHelper.func_76126_a((float)(rot / 180.0f * (float)Math.PI));
        return Vec3.func_72443_a((double)X, (double)Y, (double)Z);
    }

    protected boolean func_142008_O() {
        return false;
    }

    public void setDestCoordinates(ChunkCoordinates coorsd) {
        this.coords = coorsd;
    }

    public ChunkCoordinates getDestCoordinates() {
        if (this.name != null) {
            return TerrainManager.getInstance().getTeleportPoint(this.name);
        }
        return this.coords;
    }

    public void onSaveToSchematic(int x, int y, int z) {
        this.coords.field_71574_a -= x;
        this.coords.field_71572_b -= y;
        this.coords.field_71573_c -= z;
    }

    public void onFinishSaving(int x, int y, int z) {
        this.coords.field_71574_a += x;
        this.coords.field_71572_b += y;
        this.coords.field_71573_c += z;
    }

    public void onLoadFromSchematic(int x, int y, int z) {
        this.onFinishSaving(x, y, z);
    }
}

