/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.config;

import com.chocolate.chocolateQuest.API.RegisterChestItem;
import com.chocolate.chocolateQuest.utils.BDHelper;
import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ConfigHelper {
    public static void readChests() {
        BDHelper.println("## Chest items register ##");
        ConfigHelper.getItems("Chocolate/ChestConfig/chests.prop", RegisterChestItem.chestList, "default");
        ConfigHelper.getItems("Chocolate/ChestConfig/treasures.prop", RegisterChestItem.treasureList, "treasure");
        ConfigHelper.getItems("Chocolate/ChestConfig/weapons.prop", RegisterChestItem.weaponList, "weapon");
        ConfigHelper.getItems("Chocolate/ChestConfig/ores.prop", RegisterChestItem.mineralList, "ores");
        ConfigHelper.getItems("Chocolate/ChestConfig/food.prop", RegisterChestItem.foodList, "food");
    }

    public static void getItems(String st, ArrayList list, String listName) {
        File file = new File(BDHelper.getAppDir(), st);
        try {
            Properties prop = new Properties();
            FileReader fr = new FileReader(file);
            prop.load(fr);
            Enumeration<Object> e = prop.elements();
            int cont = 0;
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                StringTokenizer stkn = new StringTokenizer(s, ",");
                int tokens = stkn.countTokens();
                String name = ((String)stkn.nextElement()).trim();
                int numberOfItems = 1;
                int damageOfItems = 0;
                int itemsWeight = 100;
                if (tokens == 4) {
                    numberOfItems = Integer.parseInt(((String)stkn.nextElement()).trim());
                    damageOfItems = Integer.parseInt(((String)stkn.nextElement()).trim());
                    itemsWeight = Integer.parseInt(((String)stkn.nextElement()).trim());
                }
                if (tokens == 3) {
                    numberOfItems = Integer.parseInt(((String)stkn.nextElement()).trim());
                    itemsWeight = Integer.parseInt(((String)stkn.nextElement()).trim());
                }
                if (tokens == 2) {
                    itemsWeight = Integer.parseInt(((String)stkn.nextElement()).trim());
                }
                ++cont;
                FMLLog.getLogger().info("Added " + name + " to " + listName + " chests list");
                Object item = Item.field_150901_e.func_82594_a(name);
                if (item instanceof Item) {
                    ItemStack is = new ItemStack((Item)item, numberOfItems, damageOfItems);
                    RegisterChestItem.addChestItem(is, itemsWeight, list);
                    continue;
                }
                BDHelper.println("Error loading item: " + s + " into " + listName + " chests list");
            }
        }
        catch (FileNotFoundException e) {
            FMLLog.getLogger().error("Not found config file at Chocolate Quest mod: " + file.getAbsolutePath());
            e.printStackTrace();
        }
        catch (IOException e) {
            FMLLog.getLogger().error("Error reading config file at Chocolate Quest mod: " + file.getAbsolutePath());
            e.printStackTrace();
        }
    }
}

