/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.builder;

import com.chocolate.chocolateQuest.API.BuilderBase;
import com.chocolate.chocolateQuest.API.HelperReadConfig;
import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.builder.BuilderEmptyCave;
import com.chocolate.chocolateQuest.builder.BuilderHelper;
import com.chocolate.chocolateQuest.builder.schematic.Schematic;
import com.chocolate.chocolateQuest.builder.support.PlateauBuilder;
import com.chocolate.chocolateQuest.entity.EntitySchematicBuilder;
import java.util.Properties;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class BuilderTemplate
extends BuilderBase {
    String folderName;
    int posY;
    PlateauBuilder supportStructure;
    BuilderEmptyCave cave;
    boolean replaceBanners = true;

    @Override
    public BuilderBase load(Properties prop) {
        this.folderName = prop.getProperty("folder").trim();
        if (this.folderName == null) {
            return null;
        }
        this.posY = Math.max(1, HelperReadConfig.getIntegerProperty(prop, "posY", 64));
        if (HelperReadConfig.getBooleanProperty(prop, "supportStructure", false)) {
            this.supportStructure = new PlateauBuilder();
            this.supportStructure.load(prop);
        }
        if (HelperReadConfig.getBooleanProperty(prop, "emptyCave", false)) {
            this.cave = new BuilderEmptyCave();
            this.cave.load(prop);
        }
        this.replaceBanners = HelperReadConfig.getBooleanProperty(prop, "replaceBanners", this.replaceBanners);
        return this;
    }

    @Override
    public String getName() {
        return "templateFloating";
    }

    @Override
    public void generate(Random random, World world, int x, int z, int mob) {
        Schematic schematic = BuilderHelper.getRandomNBTMap(this.folderName, random, this.getDungeonName());
        short maxX = schematic.width;
        short maxY = schematic.length;
        this.generate(random, schematic, world, x - maxX / 2, this.posY, z - maxY / 2, mob);
    }

    @Override
    public void generate(Random random, World world, int i, int j, int k, int idMob) {
        Schematic schematic = BuilderHelper.getRandomNBTMap(this.folderName, random, this.getDungeonName());
        this.generate(random, schematic, world, i, this.posY, k, idMob);
    }

    public void generate(Random random, Schematic schematic, World world, int i, int j, int k, int idMob) {
        if (ChocolateQuest.config.useInstantDungeonBuilder) {
            BuilderHelper builderHelper = BuilderHelper.builderHelper;
            if (this.supportStructure != null) {
                this.supportStructure.generate(random, world, i, j, k, schematic.width, schematic.length);
            }
            if (this.cave != null) {
                this.cave.generate(random, world, i, j + this.cave.posY, k, schematic.width, schematic.length, this.cave.height <= 0 ? schematic.height : this.cave.height);
            }
            builderHelper.putSchematicInWorld(random, world, schematic, i, j, k, idMob, this.replaceBanners);
        } else {
            Schematic s;
            EntitySchematicBuilder builder = new EntitySchematicBuilder(world);
            builder.setMobID(idMob, this.replaceBanners);
            builder.func_70107_b(i, j, k);
            if (this.supportStructure != null) {
                s = this.supportStructure.getSchematic(random, world, i, j, k, schematic.width, schematic.length);
                builder.addBuildingPlans(s, i - this.supportStructure.wallSize, j, k - this.supportStructure.wallSize);
            }
            if (this.cave != null) {
                s = this.cave.getSchematic(random, world, i, j + this.cave.posY, k, schematic.width, schematic.length, this.cave.height <= 0 ? schematic.height : this.cave.height);
                builder.addBuildingPlans(s, i - this.cave.borderWidth, j, k - this.cave.borderWidth);
            }
            builder.addBuildingPlans(schematic, i, j, k);
            world.func_72838_d((Entity)builder);
        }
    }
}

