/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.builder;

import com.chocolate.chocolateQuest.API.BuilderBase;
import com.chocolate.chocolateQuest.API.BuilderBlockData;
import com.chocolate.chocolateQuest.API.HelperReadConfig;
import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.builder.Perlin3D;
import com.chocolate.chocolateQuest.builder.schematic.Schematic;
import com.chocolate.chocolateQuest.command.CommandSpawnBoss;
import com.chocolate.chocolateQuest.entity.EntitySchematicBuilder;
import com.chocolate.chocolateQuest.entity.boss.EntityBaseBoss;
import java.util.Properties;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class BuilderEmptyCave
extends BuilderBase {
    BuilderBlockData caveBlock = new BuilderBlockData(Blocks.field_150350_a);
    int size = 48;
    int height = 28;
    int posY;
    int boss = 0;
    String spawnBoss = "no";
    boolean inverted = false;
    int borderWidth = 0;

    @Override
    public BuilderBase load(Properties prop) {
        this.caveBlock = HelperReadConfig.getBlock(prop, "caveBlock", this.caveBlock);
        this.size = HelperReadConfig.getIntegerProperty(prop, "caveSize", 32);
        this.height = HelperReadConfig.getIntegerProperty(prop, "caveHeight", 28);
        this.posY = HelperReadConfig.getIntegerProperty(prop, "caveY", 20);
        this.inverted = HelperReadConfig.getBooleanProperty(prop, "inverted", this.inverted);
        this.spawnBoss = HelperReadConfig.getStringProperty(prop, "spawnBoss", this.spawnBoss);
        return this;
    }

    @Override
    public void generate(Random random, World world, int i, int j, int mob) {
        this.generate(random, world, i, this.posY, j, mob);
    }

    @Override
    public String getName() {
        return "emptyCave";
    }

    @Override
    public void generate(Random random, World world, int i, int j, int k, int idMob) {
        this.generate(random, world, i, j, k, this.size, this.size, this.height);
    }

    public void generate(Random random, World world, int i, int j, int k, int sizeX, int sizeZ, int height) {
        if (ChocolateQuest.config.useInstantDungeonBuilder || this.caveBlock.id == ChocolateQuest.emptyBlock) {
            this.generateCave(random, world, i, j, k, this.size, this.size, height);
        } else {
            EntitySchematicBuilder builder = new EntitySchematicBuilder(world);
            builder.func_70107_b(i, j, k);
            builder.addBuildingPlans(this.getSchematic(random, world, i, j, k, this.size, this.size, height), i, j, k);
            world.func_72838_d((Entity)builder);
        }
    }

    public void generateCave(Random random, World world, int i, int j, int k, int sizeX, int sizeZ, int height) {
        i -= this.borderWidth;
        k -= this.borderWidth;
        Perlin3D p = new Perlin3D(world.func_72905_C(), 4, random);
        Perlin3D p2 = new Perlin3D(world.func_72905_C(), 32, random);
        int centerX = (sizeX += this.borderWidth * 2) / 2;
        int centerY = (height += this.borderWidth * 2) / 2;
        int centerZ = (sizeZ += this.borderWidth * 2) / 2;
        int centerDistsq = centerX * centerX + centerY * centerY + centerZ * centerZ;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        float scaleZ = 1.0f;
        float maxSize = Math.max(sizeX, Math.max(height, sizeZ));
        scaleX = 1.0f + (maxSize - (float)sizeX) / maxSize;
        scaleY = 1.0f + (maxSize - (float)height) / maxSize;
        scaleZ = 1.0f + (maxSize - (float)sizeZ) / maxSize;
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    float noiseVar = (float)((x - centerX) * (x - centerX)) * scaleX * scaleX + (float)((y - centerY) * (y - centerY)) * scaleY * scaleY + (float)((z - centerZ) * (z - centerZ)) * scaleZ * scaleZ;
                    double noiseValue = (p.getNoiseAt(x + i, y + j, z + k) + p2.getNoiseAt(x + i, y + j, z + k)) / 2.0 * ((double)(noiseVar /= (float)centerDistsq) * 2.5);
                    if (this.inverted) {
                        if (!(noiseValue > 0.5)) continue;
                        this.caveBlock.placeBlock(world, i + x, j + y, k + z, random);
                        continue;
                    }
                    if (!(noiseValue < 0.5)) continue;
                    this.caveBlock.placeBlock(world, i + x, j + y, k + z, random);
                }
            }
        }
        EntityBaseBoss boss = CommandSpawnBoss.getBossByName(this.spawnBoss, world);
        if (boss != null) {
            boss.setMonsterScale(3.0f + random.nextFloat() * 4.0f);
            boss.func_70107_b(i + sizeX / 2, j + height / 2, k + sizeZ / 2);
            world.func_72838_d((Entity)boss);
        }
    }

    public Schematic getSchematic(Random random, World world, int i, int j, int k, int sizeX, int sizeZ, int height) {
        i -= this.borderWidth;
        j = j > this.borderWidth + 2 ? (j -= this.borderWidth) : 3;
        k -= this.borderWidth;
        Schematic schematic = new Schematic(sizeX += this.borderWidth * 2, height += this.borderWidth * 2, sizeZ += this.borderWidth * 2, ChocolateQuest.emptyBlock);
        Perlin3D p = new Perlin3D(world.func_72905_C(), 4, random);
        Perlin3D p2 = new Perlin3D(world.func_72905_C(), 32, random);
        int centerX = sizeX / 2;
        int centerY = height / 2;
        int centerZ = sizeZ / 2;
        int centerDistsq = centerX * centerX + centerY * centerY + centerZ * centerZ;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        float scaleZ = 1.0f;
        float maxSize = Math.max(sizeX, Math.max(height, sizeZ));
        scaleX = 1.0f + (maxSize - (float)sizeX) / maxSize;
        scaleY = 1.0f + (maxSize - (float)height) / maxSize;
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    float noiseVar = (float)((x - centerX) * (x - centerX)) * scaleX * scaleX + (float)((y - centerY) * (y - centerY)) * scaleY * scaleY + (float)((z - centerZ) * (z - centerZ)) * scaleZ * scaleZ;
                    double noiseValue = (p.getNoiseAt(x + i, y + j, z + k) + p2.getNoiseAt(x + i, y + j, z + k)) / 2.0 * ((double)(noiseVar /= (float)centerDistsq) * 2.5);
                    if (this.inverted) {
                        if (!(noiseValue > 0.5)) continue;
                        this.caveBlock.placeBlock(schematic, x, y, z, random);
                        continue;
                    }
                    if (!(noiseValue < 0.5)) continue;
                    this.caveBlock.placeBlock(schematic, x, y, z, random);
                }
            }
        }
        EntityBaseBoss boss = CommandSpawnBoss.getBossByName(this.spawnBoss, world);
        if (boss != null) {
            boss.setMonsterScale(3.0f + random.nextFloat() * 4.0f);
            boss.func_70107_b(sizeX / 2, height / 2, sizeZ / 2);
            schematic.addEntity((Entity)boss);
        }
        return schematic;
    }
}

