/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.builder;

import com.chocolate.chocolateQuest.API.BuilderBase;
import com.chocolate.chocolateQuest.API.HelperReadConfig;
import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.block.BlockMobSpawnerTileEntity;
import com.chocolate.chocolateQuest.builder.BuilderEmptyCave;
import com.chocolate.chocolateQuest.builder.schematic.Schematic;
import com.chocolate.chocolateQuest.entity.EntityHumanBase;
import com.chocolate.chocolateQuest.entity.EntitySchematicBuilder;
import com.chocolate.chocolateQuest.entity.mob.registry.DungeonMonstersBase;
import com.chocolate.chocolateQuest.entity.mob.registry.RegisterDungeonMobs;
import com.chocolate.chocolateQuest.items.mobControl.ItemMobToSpawner;
import java.util.Properties;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class BuilderCavern
extends BuilderBase {
    String folder;
    int posY = 30;
    int rooms = 3;
    int floors = 3;
    boolean replaceBanners = true;
    BuilderEmptyCave cave = new BuilderEmptyCave();

    @Override
    public BuilderBase load(Properties prop) {
        this.folder = prop.getProperty("folder");
        if (this.folder == null) {
            this.folder = "unspecified";
        }
        this.rooms = Math.max(3, HelperReadConfig.getIntegerProperty(prop, "rooms", this.rooms));
        this.floors = Math.max(1, HelperReadConfig.getIntegerProperty(prop, "floors", this.floors));
        this.replaceBanners = HelperReadConfig.getBooleanProperty(prop, "replaceBanners", this.replaceBanners);
        this.cave.size = 16;
        this.cave.height = 10;
        this.cave.inverted = true;
        return super.load(prop);
    }

    @Override
    public String getName() {
        return "cavern";
    }

    @Override
    public void generate(Random random, World world, int x, int z, int mob) {
        this.generate(random, world, x, this.posY, z, mob);
    }

    @Override
    public void generate(Random random, World world, int i, int j, int k, int mob) {
        this.cave.caveBlock.id = Blocks.field_150348_b;
        this.cave.borderWidth = 0;
        int center = this.rooms / 2;
        int height = 10;
        int roomSize = 15;
        EntitySchematicBuilder builder = new EntitySchematicBuilder(world);
        builder.setMobID(mob, this.replaceBanners);
        builder.func_70107_b(i -= center * roomSize, j, k -= center * roomSize);
        int rows = 6;
        int x = 0;
        while (x < rows) {
            int z = 0;
            while (z < rows) {
                Schematic s = this.cave.getSchematic(random, world, i, j, k, this.cave.size, this.cave.size, this.cave.height);
                builder.addBuildingPlans(s, i, j, k);
                ++z;
                k += this.cave.size + 3;
            }
            ++x;
            i += this.cave.size + 3;
            k -= (this.cave.size + 3) * rows;
        }
        world.func_72838_d((Entity)builder);
    }

    public void decorateSchematic(World world, int i, int j, int k, Schematic schematic, Random random, int mobType) {
        for (int x = 0; x < schematic.width; ++x) {
            block1: for (int z = 0; z < schematic.length; ++z) {
                for (int y = 0; y < schematic.height; ++y) {
                    if (schematic.getBlock(x, y, z) != ChocolateQuest.emptyBlock) continue;
                    schematic.setBlock(x, y, z, (Block)Blocks.field_150349_c);
                    if (y + 1 >= schematic.height) continue block1;
                    if (random.nextInt(200) == 0) {
                        schematic.setBlockAndMetadata(x, y + 1, z, (Block)Blocks.field_150328_O, (byte)random.nextInt(9));
                    }
                    if (random.nextInt(100) == 0) {
                        schematic.setBlock(x, y + 1, z, (Block)Blocks.field_150329_H);
                        continue block1;
                    }
                    if (random.nextInt(100) != 0) continue block1;
                    schematic.setBlock(x, y + 1, z, Blocks.field_150428_aP);
                    continue block1;
                }
            }
        }
    }

    public void addMobsToSchematic(World world, int i, int j, int k, Schematic schematic, Random random, int mobType) {
        int x = random.nextInt(schematic.width);
        int z = random.nextInt(schematic.length);
        int y = -1;
        for (int index = 0; index < schematic.height - 1; ++index) {
            if (schematic.getBlock(x, index, z) != Blocks.field_150350_a || schematic.getBlock(x, index + 1, z) != Blocks.field_150350_a) continue;
            y = index;
            break;
        }
        if (y > -1) {
            NBTTagCompound tag;
            DungeonMonstersBase mob = RegisterDungeonMobs.mobList.get(mobType);
            EntityHumanBase human = (EntityHumanBase)mob.getEntity(world, i, j, k);
            schematic.setBlock(x, y, z, ChocolateQuest.spawner);
            BlockMobSpawnerTileEntity te = new BlockMobSpawnerTileEntity();
            te.mobNBT = tag = ItemMobToSpawner.getHumanSaveTagAndKillIt(i, j, k, human);
            te.mob = -1;
            te.field_145851_c = x;
            te.field_145848_d = y;
            te.field_145849_e = z;
            schematic.addTileEntity(te);
        }
    }
}

