/*
 * Decompiled with CFR 0.152.
 */
package com.fabiulu.farlanders.common.worldgen.village;

import com.fabiulu.farlanders.common.FarlandersMod;
import com.fabiulu.farlanders.common.entity.EntityEnderGuardian;
import com.fabiulu.farlanders.common.entity.EntityFarlander;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class VillageBlacksmith
extends WorldGenerator {
    private static final Block planks = Blocks.field_150344_f;
    private static final Block wood = Blocks.field_150364_r;
    private static final Block thinGlass = Blocks.field_150410_aZ;
    private static final Block stoneSingleSlab = Blocks.field_150333_U;
    private static final Block whiteStone = Blocks.field_150377_bs;
    private static final Block stairsCobblestone = Blocks.field_150446_ar;
    private static final Block fenceIron = Blocks.field_150411_aY;
    private static final Block fence = Blocks.field_150422_aJ;
    private static final Block doorWood = Blocks.field_150466_ao;
    private static final Block furnaceIdle = Blocks.field_150460_al;
    private static final Block stairsWoodOak = Blocks.field_150476_ad;
    private static final Block lavaStill = Blocks.field_150353_l;
    private static final Block air = Blocks.field_150350_a;

    protected Block[] GetValidSpawnBlocks() {
        return new Block[]{Blocks.field_150433_aE, Blocks.field_150354_m, Blocks.field_150348_b, Blocks.field_150349_c};
    }

    public boolean LocationIsValidSpawn(World world, int i, int j, int k) {
        int distanceToAir = 0;
        Block checkID = world.func_147439_a(i, j, k);
        while (checkID != air) {
            checkID = world.func_147439_a(i, j + ++distanceToAir, k);
        }
        if (distanceToAir > 2) {
            return false;
        }
        Block blockID = world.func_147439_a(i, j += distanceToAir - 1, k);
        Block blockIDAbove = world.func_147439_a(i, j + 1, k);
        Block blockIDBelow = world.func_147439_a(i, j - 1, k);
        for (Block x : this.GetValidSpawnBlocks()) {
            if (blockIDAbove != air) {
                return false;
            }
            if (blockID == Blocks.field_150433_aE && blockIDBelow == x || blockID == Blocks.field_150329_H && blockIDBelow == x || blockID == Blocks.field_150328_O && blockIDBelow == x || blockID == Blocks.field_150327_N && blockIDBelow == x || blockID == Blocks.field_150330_I && blockIDBelow == x || blockID == Blocks.field_150434_aF && blockIDBelow == x || blockID == Blocks.field_150338_P && blockIDBelow == x || blockID == Blocks.field_150337_Q && blockIDBelow == x) {
                return true;
            }
            if (blockID != x) continue;
            return true;
        }
        return false;
    }

    public boolean checkAllLocations(World world, int i, int j, int k) {
        return this.LocationIsValidSpawn(world, i, j, k) && this.LocationIsValidSpawn(world, i + 7, j, k) && this.LocationIsValidSpawn(world, i + 7, j, k + 9) && this.LocationIsValidSpawn(world, i, j, k + 9) && this.AirLocationIsValidSpawn(world, i, j + 6, k) && this.AirLocationIsValidSpawn(world, i + 7, j + 6, k) && this.AirLocationIsValidSpawn(world, i + 7, j + 6, k + 9) && this.AirLocationIsValidSpawn(world, i, j + 6, k + 9);
    }

    public boolean AirLocationIsValidSpawn(World world, int i, int j, int k) {
        Block blockID = world.func_147439_a(i, j, k);
        Block blockIDAbove = world.func_147439_a(i, j + 1, k);
        return blockID == air && blockIDAbove == air;
    }

    public boolean func_76484_a(World world, Random rand, int i, int j, int k) {
        if (!(this.LocationIsValidSpawn(world, i, j, k) && this.LocationIsValidSpawn(world, i + 7, j, k) && this.LocationIsValidSpawn(world, i + 7, j, k + 9) && this.LocationIsValidSpawn(world, i, j, k + 9) && this.AirLocationIsValidSpawn(world, i, j + 6, k) && this.AirLocationIsValidSpawn(world, i + 7, j + 6, k) && this.AirLocationIsValidSpawn(world, i + 7, j + 6, k + 9) && this.AirLocationIsValidSpawn(world, i, j + 6, k + 9))) {
            return false;
        }
        world.func_147449_b(i + 0, j + 1, k + 0, air);
        world.func_147449_b(i + 0, j + 1, k + 1, air);
        world.func_147449_b(i + 0, j + 1, k + 2, air);
        world.func_147449_b(i + 0, j + 1, k + 3, air);
        world.func_147449_b(i + 0, j + 1, k + 4, air);
        world.func_147449_b(i + 0, j + 1, k + 5, air);
        world.func_147465_d(i + 0, j + 1, k + 6, stairsCobblestone, 0, 2);
        world.func_147465_d(i + 0, j + 1, k + 7, stairsCobblestone, 0, 2);
        world.func_147465_d(i + 0, j + 1, k + 8, stairsCobblestone, 0, 2);
        world.func_147449_b(i + 0, j + 1, k + 9, air);
        world.func_147449_b(i + 0, j + 2, k + 0, air);
        world.func_147449_b(i + 0, j + 2, k + 1, air);
        world.func_147449_b(i + 0, j + 2, k + 2, air);
        world.func_147449_b(i + 0, j + 2, k + 3, air);
        world.func_147449_b(i + 0, j + 2, k + 4, air);
        world.func_147449_b(i + 0, j + 2, k + 5, air);
        world.func_147449_b(i + 0, j + 2, k + 6, air);
        world.func_147449_b(i + 0, j + 2, k + 7, air);
        world.func_147449_b(i + 0, j + 2, k + 8, air);
        world.func_147449_b(i + 0, j + 2, k + 9, air);
        world.func_147449_b(i + 0, j + 3, k + 0, air);
        world.func_147449_b(i + 0, j + 3, k + 1, air);
        world.func_147449_b(i + 0, j + 3, k + 2, air);
        world.func_147449_b(i + 0, j + 3, k + 3, air);
        world.func_147449_b(i + 0, j + 3, k + 4, air);
        world.func_147449_b(i + 0, j + 3, k + 5, air);
        world.func_147449_b(i + 0, j + 3, k + 6, air);
        world.func_147449_b(i + 0, j + 3, k + 7, air);
        world.func_147449_b(i + 0, j + 3, k + 8, air);
        world.func_147449_b(i + 0, j + 3, k + 9, air);
        world.func_147449_b(i + 0, j + 4, k + 0, air);
        world.func_147449_b(i + 0, j + 4, k + 1, air);
        world.func_147449_b(i + 0, j + 4, k + 2, air);
        world.func_147449_b(i + 0, j + 4, k + 3, air);
        world.func_147449_b(i + 0, j + 4, k + 4, air);
        world.func_147449_b(i + 0, j + 4, k + 5, air);
        world.func_147449_b(i + 0, j + 4, k + 6, air);
        world.func_147449_b(i + 0, j + 4, k + 7, air);
        world.func_147449_b(i + 0, j + 4, k + 8, air);
        world.func_147449_b(i + 0, j + 4, k + 9, air);
        world.func_147449_b(i + 0, j + 5, k + 0, air);
        world.func_147449_b(i + 0, j + 5, k + 1, air);
        world.func_147449_b(i + 0, j + 5, k + 2, air);
        world.func_147449_b(i + 0, j + 5, k + 3, air);
        world.func_147449_b(i + 0, j + 5, k + 4, air);
        world.func_147449_b(i + 0, j + 5, k + 5, air);
        world.func_147449_b(i + 0, j + 5, k + 6, air);
        world.func_147449_b(i + 0, j + 5, k + 7, air);
        world.func_147449_b(i + 0, j + 5, k + 8, air);
        world.func_147449_b(i + 0, j + 5, k + 9, air);
        world.func_147449_b(i + 0, j + 6, k + 0, air);
        world.func_147449_b(i + 0, j + 6, k + 1, air);
        world.func_147449_b(i + 0, j + 6, k + 2, air);
        world.func_147449_b(i + 0, j + 6, k + 3, air);
        world.func_147449_b(i + 0, j + 6, k + 4, air);
        world.func_147449_b(i + 0, j + 6, k + 5, air);
        world.func_147449_b(i + 0, j + 6, k + 6, air);
        world.func_147449_b(i + 0, j + 6, k + 7, air);
        world.func_147449_b(i + 0, j + 6, k + 8, air);
        world.func_147449_b(i + 0, j + 6, k + 9, air);
        world.func_147465_d(i + 1, j + 1, k + 0, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 1, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 1, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 1, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 1, k + 4, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 1, k + 5, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 1, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 1, k + 7, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 1, k + 8, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 1, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 2, k + 0, wood, 0, 2);
        world.func_147465_d(i + 1, j + 2, k + 1, planks, 0, 2);
        world.func_147465_d(i + 1, j + 2, k + 2, planks, 0, 2);
        world.func_147465_d(i + 1, j + 2, k + 3, wood, 0, 2);
        world.func_147449_b(i + 1, j + 2, k + 4, air);
        world.func_147465_d(i + 1, j + 2, k + 5, fence, 0, 2);
        world.func_147449_b(i + 1, j + 2, k + 6, air);
        world.func_147449_b(i + 1, j + 2, k + 7, air);
        world.func_147449_b(i + 1, j + 2, k + 8, air);
        world.func_147465_d(i + 1, j + 2, k + 9, fence, 0, 2);
        world.func_147465_d(i + 1, j + 3, k + 0, wood, 0, 2);
        world.func_147465_d(i + 1, j + 3, k + 1, planks, 0, 2);
        world.func_147465_d(i + 1, j + 3, k + 2, planks, 0, 2);
        world.func_147465_d(i + 1, j + 3, k + 3, wood, 0, 2);
        world.func_147449_b(i + 1, j + 3, k + 4, air);
        world.func_147465_d(i + 1, j + 3, k + 5, fence, 0, 2);
        world.func_147449_b(i + 1, j + 3, k + 6, air);
        world.func_147449_b(i + 1, j + 3, k + 7, air);
        world.func_147449_b(i + 1, j + 3, k + 8, air);
        world.func_147465_d(i + 1, j + 3, k + 9, fence, 0, 2);
        world.func_147465_d(i + 1, j + 4, k + 0, wood, 0, 2);
        world.func_147465_d(i + 1, j + 4, k + 1, planks, 0, 2);
        world.func_147465_d(i + 1, j + 4, k + 2, planks, 0, 2);
        world.func_147465_d(i + 1, j + 4, k + 3, wood, 0, 2);
        world.func_147449_b(i + 1, j + 4, k + 4, air);
        world.func_147465_d(i + 1, j + 4, k + 5, fence, 0, 2);
        world.func_147449_b(i + 1, j + 4, k + 6, air);
        world.func_147449_b(i + 1, j + 4, k + 7, air);
        world.func_147449_b(i + 1, j + 4, k + 8, air);
        world.func_147465_d(i + 1, j + 4, k + 9, fence, 0, 2);
        world.func_147465_d(i + 1, j + 5, k + 0, wood, 0, 2);
        world.func_147465_d(i + 1, j + 5, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 5, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 5, k + 3, wood, 0, 2);
        world.func_147465_d(i + 1, j + 5, k + 4, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 5, k + 5, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 5, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 5, k + 7, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 5, k + 8, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 5, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 6, k + 0, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 1, j + 6, k + 1, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 1, j + 6, k + 2, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 1, j + 6, k + 3, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 1, j + 6, k + 4, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 1, j + 6, k + 5, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 1, j + 6, k + 6, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 1, j + 6, k + 7, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 1, j + 6, k + 8, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 1, j + 6, k + 9, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 2, j + 1, k + 0, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 1, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 1, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 1, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 1, k + 4, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 1, k + 5, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 1, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 1, k + 7, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 1, k + 8, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 1, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 2, k + 0, planks, 0, 2);
        world.func_147449_b(i + 2, j + 2, k + 1, air);
        world.func_147449_b(i + 2, j + 2, k + 2, air);
        world.func_147449_b(i + 2, j + 2, k + 3, air);
        world.func_147449_b(i + 2, j + 2, k + 4, air);
        world.func_147449_b(i + 2, j + 2, k + 5, air);
        world.func_147449_b(i + 2, j + 2, k + 6, air);
        world.func_147449_b(i + 2, j + 2, k + 7, air);
        world.func_147465_d(i + 2, j + 2, k + 8, (Block)Blocks.field_150334_T, 0, 2);
        world.func_147449_b(i + 2, j + 2, k + 9, air);
        world.func_147465_d(i + 2, j + 3, k + 0, planks, 0, 2);
        world.func_147449_b(i + 2, j + 3, k + 1, air);
        world.func_147449_b(i + 2, j + 3, k + 2, air);
        world.func_147449_b(i + 2, j + 3, k + 3, air);
        world.func_147449_b(i + 2, j + 3, k + 4, air);
        world.func_147449_b(i + 2, j + 3, k + 5, air);
        world.func_147449_b(i + 2, j + 3, k + 6, air);
        world.func_147449_b(i + 2, j + 3, k + 7, air);
        world.func_147449_b(i + 2, j + 3, k + 8, air);
        world.func_147449_b(i + 2, j + 3, k + 9, air);
        world.func_147465_d(i + 2, j + 4, k + 0, planks, 0, 2);
        world.func_147449_b(i + 2, j + 4, k + 1, air);
        world.func_147449_b(i + 2, j + 4, k + 2, air);
        world.func_147465_d(i + 2, j + 4, k + 3, planks, 0, 2);
        world.func_147449_b(i + 2, j + 4, k + 4, air);
        world.func_147449_b(i + 2, j + 4, k + 5, air);
        world.func_147449_b(i + 2, j + 4, k + 6, air);
        world.func_147449_b(i + 2, j + 4, k + 7, air);
        world.func_147449_b(i + 2, j + 4, k + 8, air);
        world.func_147449_b(i + 2, j + 4, k + 9, air);
        world.func_147465_d(i + 2, j + 5, k + 0, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 5, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 5, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 5, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 5, k + 4, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 5, k + 5, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 5, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 5, k + 7, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 5, k + 8, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 5, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 6, k + 0, stoneSingleSlab, 0, 2);
        world.func_147449_b(i + 2, j + 6, k + 1, air);
        world.func_147449_b(i + 2, j + 6, k + 2, air);
        world.func_147449_b(i + 2, j + 6, k + 3, air);
        world.func_147449_b(i + 2, j + 6, k + 4, air);
        world.func_147449_b(i + 2, j + 6, k + 5, air);
        world.func_147449_b(i + 2, j + 6, k + 6, air);
        world.func_147449_b(i + 2, j + 6, k + 7, air);
        world.func_147449_b(i + 2, j + 6, k + 8, air);
        world.func_147465_d(i + 2, j + 6, k + 9, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 3, j + 1, k + 0, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 1, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 1, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 1, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 1, k + 4, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 1, k + 5, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 1, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 1, k + 7, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 1, k + 8, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 1, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 2, k + 0, planks, 0, 2);
        world.func_147449_b(i + 3, j + 2, k + 1, air);
        world.func_147449_b(i + 3, j + 2, k + 2, air);
        world.func_147465_d(i + 3, j + 2, k + 3, planks, 0, 2);
        world.func_147449_b(i + 3, j + 2, k + 4, air);
        world.func_147449_b(i + 3, j + 2, k + 5, air);
        world.func_147449_b(i + 3, j + 2, k + 6, air);
        world.func_147449_b(i + 3, j + 2, k + 7, air);
        world.func_147449_b(i + 3, j + 2, k + 8, air);
        world.func_147449_b(i + 3, j + 2, k + 9, air);
        world.func_147465_d(i + 3, j + 3, k + 0, thinGlass, 0, 2);
        world.func_147449_b(i + 3, j + 3, k + 1, air);
        world.func_147449_b(i + 3, j + 3, k + 2, air);
        world.func_147465_d(i + 3, j + 3, k + 3, planks, 0, 2);
        world.func_147449_b(i + 3, j + 3, k + 4, air);
        world.func_147449_b(i + 3, j + 3, k + 5, air);
        world.func_147449_b(i + 3, j + 3, k + 6, air);
        world.func_147449_b(i + 3, j + 3, k + 7, air);
        world.func_147449_b(i + 3, j + 3, k + 8, air);
        world.func_147449_b(i + 3, j + 3, k + 9, air);
        world.func_147465_d(i + 3, j + 4, k + 0, planks, 0, 2);
        world.func_147449_b(i + 3, j + 4, k + 1, air);
        world.func_147449_b(i + 3, j + 4, k + 2, air);
        world.func_147465_d(i + 3, j + 4, k + 3, planks, 0, 2);
        world.func_147449_b(i + 3, j + 4, k + 4, air);
        world.func_147449_b(i + 3, j + 4, k + 5, air);
        world.func_147449_b(i + 3, j + 4, k + 6, air);
        world.func_147449_b(i + 3, j + 4, k + 7, air);
        world.func_147449_b(i + 3, j + 4, k + 8, air);
        world.func_147449_b(i + 3, j + 4, k + 9, air);
        world.func_147465_d(i + 3, j + 5, k + 0, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 5, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 5, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 5, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 5, k + 4, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 5, k + 5, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 5, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 5, k + 7, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 5, k + 8, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 5, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 6, k + 0, stoneSingleSlab, 0, 2);
        world.func_147449_b(i + 3, j + 6, k + 1, air);
        world.func_147449_b(i + 3, j + 6, k + 2, air);
        world.func_147449_b(i + 3, j + 6, k + 3, air);
        world.func_147449_b(i + 3, j + 6, k + 4, air);
        world.func_147449_b(i + 3, j + 6, k + 5, air);
        world.func_147449_b(i + 3, j + 6, k + 6, air);
        world.func_147449_b(i + 3, j + 6, k + 7, air);
        world.func_147449_b(i + 3, j + 6, k + 8, air);
        world.func_147465_d(i + 3, j + 6, k + 9, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 4, j + 1, k + 0, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 1, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 1, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 1, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 1, k + 4, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 1, k + 5, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 1, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 1, k + 7, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 1, k + 8, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 1, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 2, k + 0, planks, 0, 2);
        world.func_147449_b(i + 4, j + 2, k + 1, air);
        world.func_147449_b(i + 4, j + 2, k + 2, air);
        world.func_147449_b(i + 4, j + 2, k + 3, air);
        world.func_147465_d(i + 4, j + 2, k + 4, planks, 0, 2);
        world.func_147465_d(i + 4, j + 2, k + 5, planks, 0, 2);
        world.func_147465_d(i + 4, j + 2, k + 6, whiteStone, 0, 2);
        world.func_147449_b(i + 4, j + 2, k + 7, air);
        world.func_147449_b(i + 4, j + 2, k + 8, air);
        world.func_147449_b(i + 4, j + 2, k + 9, air);
        world.func_147465_d(i + 4, j + 3, k + 0, planks, 0, 2);
        world.func_147449_b(i + 4, j + 3, k + 1, air);
        world.func_147449_b(i + 4, j + 3, k + 2, air);
        world.func_147449_b(i + 4, j + 3, k + 3, air);
        world.func_147465_d(i + 4, j + 3, k + 4, planks, 0, 2);
        world.func_147465_d(i + 4, j + 3, k + 5, planks, 0, 2);
        world.func_147465_d(i + 4, j + 3, k + 6, furnaceIdle, 3, 2);
        world.func_147465_d(i + 2, j + 2, k + 3, doorWood, 3, 2);
        world.func_147465_d(i + 2, j + 3, k + 3, doorWood, 8, 2);
        world.func_147449_b(i + 4, j + 3, k + 7, air);
        world.func_147449_b(i + 4, j + 3, k + 8, air);
        world.func_147449_b(i + 4, j + 3, k + 9, air);
        world.func_147465_d(i + 4, j + 4, k + 0, planks, 0, 2);
        world.func_147449_b(i + 4, j + 4, k + 1, air);
        world.func_147449_b(i + 4, j + 4, k + 2, air);
        world.func_147449_b(i + 4, j + 4, k + 3, air);
        world.func_147465_d(i + 4, j + 4, k + 4, planks, 0, 2);
        world.func_147465_d(i + 4, j + 4, k + 5, planks, 0, 2);
        world.func_147465_d(i + 4, j + 4, k + 6, furnaceIdle, 3, 2);
        world.func_147449_b(i + 4, j + 4, k + 7, air);
        world.func_147449_b(i + 4, j + 4, k + 8, air);
        world.func_147449_b(i + 4, j + 4, k + 9, air);
        world.func_147465_d(i + 4, j + 5, k + 0, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 5, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 5, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 5, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 5, k + 4, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 5, k + 5, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 5, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 5, k + 7, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 5, k + 8, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 5, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 6, k + 0, stoneSingleSlab, 0, 2);
        world.func_147449_b(i + 4, j + 6, k + 1, air);
        world.func_147449_b(i + 4, j + 6, k + 2, air);
        world.func_147449_b(i + 4, j + 6, k + 3, air);
        world.func_147449_b(i + 4, j + 6, k + 4, air);
        world.func_147449_b(i + 4, j + 6, k + 5, air);
        world.func_147449_b(i + 4, j + 6, k + 6, air);
        world.func_147449_b(i + 4, j + 6, k + 7, air);
        world.func_147449_b(i + 4, j + 6, k + 8, air);
        world.func_147465_d(i + 4, j + 6, k + 9, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 5, j + 1, k + 0, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 1, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 1, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 1, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 1, k + 4, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 1, k + 5, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 1, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 1, k + 7, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 1, k + 8, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 1, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 2, k + 0, planks, 0, 2);
        world.func_147465_d(i + 5, j + 2, k + 1, stairsWoodOak, 3, 2);
        world.func_147465_d(i + 5, j + 2, k + 2, fence, 0, 2);
        world.func_147449_b(i + 5, j + 2, k + 3, air);
        world.func_147449_b(i + 5, j + 2, k + 4, air);
        world.func_147449_b(i + 5, j + 2, k + 5, air);
        world.func_147465_d(i + 5, j + 2, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 2, k + 7, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 2, k + 8, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 2, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 3, k + 0, thinGlass, 0, 2);
        world.func_147449_b(i + 5, j + 3, k + 1, air);
        world.func_147449_b(i + 5, j + 3, k + 3, air);
        world.func_147449_b(i + 5, j + 3, k + 4, air);
        world.func_147449_b(i + 5, j + 3, k + 5, air);
        world.func_147465_d(i + 5, j + 3, k + 6, whiteStone, 0, 2);
        world.func_147449_b(i + 5, j + 3, k + 7, air);
        world.func_147449_b(i + 5, j + 3, k + 8, air);
        world.func_147465_d(i + 5, j + 3, k + 9, fenceIron, 0, 2);
        world.func_147465_d(i + 5, j + 4, k + 0, planks, 0, 2);
        world.func_147449_b(i + 5, j + 4, k + 1, air);
        world.func_147449_b(i + 5, j + 4, k + 2, air);
        world.func_147449_b(i + 5, j + 4, k + 3, air);
        world.func_147449_b(i + 5, j + 4, k + 4, air);
        world.func_147449_b(i + 5, j + 4, k + 5, air);
        world.func_147465_d(i + 5, j + 4, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 4, k + 7, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 4, k + 8, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 4, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 5, k + 0, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 5, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 5, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 5, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 5, k + 4, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 5, k + 5, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 5, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 5, k + 7, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 5, k + 8, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 5, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 5, j + 6, k + 0, stoneSingleSlab, 0, 2);
        world.func_147449_b(i + 5, j + 6, k + 1, air);
        world.func_147449_b(i + 5, j + 6, k + 2, air);
        world.func_147449_b(i + 5, j + 6, k + 3, air);
        world.func_147449_b(i + 5, j + 6, k + 4, air);
        world.func_147449_b(i + 5, j + 6, k + 5, air);
        world.func_147449_b(i + 5, j + 6, k + 6, air);
        world.func_147449_b(i + 5, j + 6, k + 7, air);
        world.func_147449_b(i + 5, j + 6, k + 8, air);
        world.func_147465_d(i + 5, j + 6, k + 9, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 6, j + 1, k + 0, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 1, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 1, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 1, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 1, k + 4, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 1, k + 5, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 1, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 1, k + 7, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 1, k + 8, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 1, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 2, k + 0, planks, 0, 2);
        world.func_147465_d(i + 6, j + 2, k + 1, planks, 0, 2);
        world.func_147465_d(i + 6, j + 2, k + 2, stairsWoodOak, 0, 2);
        world.func_147449_b(i + 6, j + 2, k + 3, air);
        world.func_147449_b(i + 6, j + 2, k + 4, air);
        world.func_147465_d(i + 6, j + 2, k + 5, (Block)Blocks.field_150486_ae, 0, 2);
        TileEntityChest chest = new TileEntityChest();
        world.func_147455_a(i + 6, j + 2, k + 5, (TileEntity)chest);
        for (int slot = 0; slot < chest.func_70302_i_(); ++slot) {
            int num = rand.nextInt(200);
            if (num == 0) {
                chest.func_70299_a(slot, new ItemStack((Item)Items.field_151024_Q));
                continue;
            }
            if (num == 1) {
                chest.func_70299_a(slot, new ItemStack((Item)Items.field_151020_U));
                continue;
            }
            if (num == 2) {
                chest.func_70299_a(slot, new ItemStack((Item)Items.field_151161_ac));
                continue;
            }
            if (num == 3) {
                chest.func_70299_a(slot, new ItemStack((Item)Items.field_151169_ag));
                continue;
            }
            if (num == 4) {
                chest.func_70299_a(slot, new ItemStack((Item)Items.field_151028_Y));
                continue;
            }
            if (num == 5) {
                chest.func_70299_a(slot, new ItemStack(FarlandersMod.nightfallHelmet));
                continue;
            }
            if (num == 6) {
                chest.func_70299_a(slot, new ItemStack((Item)Items.field_151023_V));
                continue;
            }
            if (num == 7) {
                chest.func_70299_a(slot, new ItemStack((Item)Items.field_151163_ad));
                continue;
            }
            if (num == 8) {
                chest.func_70299_a(slot, new ItemStack((Item)Items.field_151171_ah));
                continue;
            }
            if (num == 9) {
                chest.func_70299_a(slot, new ItemStack((Item)Items.field_151030_Z));
                continue;
            }
            if (num == 10) {
                chest.func_70299_a(slot, new ItemStack((Item)Items.field_151027_R));
                continue;
            }
            if (num == 11) {
                chest.func_70299_a(slot, new ItemStack(FarlandersMod.nightfallChest));
                continue;
            }
            if (num == 12) {
                chest.func_70299_a(slot, new ItemStack((Item)Items.field_151022_W));
                continue;
            }
            if (num == 13) {
                chest.func_70299_a(slot, new ItemStack((Item)Items.field_151173_ae));
                continue;
            }
            if (num == 14) {
                chest.func_70299_a(slot, new ItemStack((Item)Items.field_151149_ai));
                continue;
            }
            if (num == 15) {
                chest.func_70299_a(slot, new ItemStack((Item)Items.field_151026_S));
                continue;
            }
            if (num == 16) {
                chest.func_70299_a(slot, new ItemStack((Item)Items.field_151165_aa));
                continue;
            }
            if (num == 17) {
                chest.func_70299_a(slot, new ItemStack(FarlandersMod.nightfallPants));
                continue;
            }
            if (num == 18) {
                chest.func_70299_a(slot, new ItemStack((Item)Items.field_151029_X));
                continue;
            }
            if (num == 19) {
                chest.func_70299_a(slot, new ItemStack((Item)Items.field_151175_af));
                continue;
            }
            if (num == 20) {
                chest.func_70299_a(slot, new ItemStack(FarlandersMod.nightfallBoots));
                continue;
            }
            if (num == 21) {
                chest.func_70299_a(slot, new ItemStack((Item)Items.field_151151_aj));
                continue;
            }
            if (num == 22) {
                chest.func_70299_a(slot, new ItemStack((Item)Items.field_151021_T));
                continue;
            }
            if (num == 23) {
                chest.func_70299_a(slot, new ItemStack((Item)Items.field_151167_ab));
                continue;
            }
            if (num == 24) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151138_bX));
                continue;
            }
            if (num == 25) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151136_bY));
                continue;
            }
            if (num == 26) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151125_bZ));
                continue;
            }
            if (num != 27) continue;
            chest.func_70299_a(slot, new ItemStack(FarlandersMod.rebelHelmet));
        }
        world.func_147465_d(i + 6, j + 2, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 2, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 3, k + 0, planks, 0, 2);
        world.func_147449_b(i + 6, j + 3, k + 1, air);
        world.func_147449_b(i + 6, j + 3, k + 2, air);
        world.func_147449_b(i + 6, j + 3, k + 3, air);
        world.func_147449_b(i + 6, j + 3, k + 4, air);
        world.func_147449_b(i + 6, j + 3, k + 5, air);
        world.func_147465_d(i + 6, j + 3, k + 6, whiteStone, 0, 2);
        world.func_147449_b(i + 6, j + 3, k + 7, air);
        world.func_147449_b(i + 6, j + 3, k + 8, air);
        world.func_147465_d(i + 6, j + 3, k + 9, fenceIron, 0, 2);
        world.func_147465_d(i + 6, j + 4, k + 0, planks, 0, 2);
        world.func_147449_b(i + 6, j + 4, k + 1, air);
        world.func_147449_b(i + 6, j + 4, k + 2, air);
        world.func_147449_b(i + 6, j + 4, k + 3, air);
        world.func_147449_b(i + 6, j + 4, k + 4, air);
        world.func_147449_b(i + 6, j + 4, k + 5, air);
        world.func_147465_d(i + 6, j + 4, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 4, k + 7, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 4, k + 8, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 4, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 5, k + 0, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 5, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 5, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 5, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 5, k + 4, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 5, k + 5, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 5, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 5, k + 7, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 5, k + 8, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 5, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 6, j + 6, k + 0, stoneSingleSlab, 0, 2);
        world.func_147449_b(i + 6, j + 6, k + 1, air);
        world.func_147449_b(i + 6, j + 6, k + 2, air);
        world.func_147449_b(i + 6, j + 6, k + 3, air);
        world.func_147449_b(i + 6, j + 6, k + 4, air);
        world.func_147449_b(i + 6, j + 6, k + 5, air);
        world.func_147449_b(i + 6, j + 6, k + 6, air);
        world.func_147449_b(i + 6, j + 6, k + 7, air);
        world.func_147449_b(i + 6, j + 6, k + 8, air);
        world.func_147465_d(i + 6, j + 6, k + 9, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 7, j + 1, k + 0, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 1, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 1, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 1, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 1, k + 4, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 1, k + 5, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 1, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 1, k + 7, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 1, k + 8, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 1, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 2, k + 0, wood, 0, 2);
        world.func_147465_d(i + 7, j + 2, k + 1, planks, 0, 2);
        world.func_147465_d(i + 7, j + 2, k + 2, planks, 0, 2);
        world.func_147465_d(i + 7, j + 2, k + 3, planks, 0, 2);
        world.func_147465_d(i + 7, j + 2, k + 4, planks, 0, 2);
        world.func_147465_d(i + 7, j + 2, k + 5, planks, 0, 2);
        world.func_147465_d(i + 7, j + 2, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 2, k + 7, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 2, k + 8, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 2, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 3, k + 0, wood, 0, 2);
        world.func_147465_d(i + 7, j + 3, k + 1, planks, 0, 2);
        world.func_147465_d(i + 7, j + 3, k + 2, thinGlass, 0, 2);
        world.func_147465_d(i + 7, j + 3, k + 3, planks, 0, 2);
        world.func_147465_d(i + 7, j + 3, k + 4, thinGlass, 0, 2);
        world.func_147465_d(i + 7, j + 3, k + 5, planks, 0, 2);
        world.func_147465_d(i + 7, j + 3, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 3, k + 7, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 3, k + 8, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 3, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 4, k + 0, wood, 0, 2);
        world.func_147465_d(i + 7, j + 4, k + 1, planks, 0, 2);
        world.func_147465_d(i + 7, j + 4, k + 2, planks, 0, 2);
        world.func_147465_d(i + 7, j + 4, k + 3, planks, 0, 2);
        world.func_147465_d(i + 7, j + 4, k + 4, planks, 0, 2);
        world.func_147465_d(i + 7, j + 4, k + 5, planks, 0, 2);
        world.func_147465_d(i + 7, j + 4, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 4, k + 7, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 4, k + 8, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 4, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 5, k + 0, wood, 0, 2);
        world.func_147465_d(i + 7, j + 5, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 5, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 5, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 5, k + 4, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 5, k + 5, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 5, k + 6, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 5, k + 7, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 5, k + 8, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 5, k + 9, whiteStone, 0, 2);
        world.func_147465_d(i + 7, j + 6, k + 0, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 7, j + 6, k + 1, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 7, j + 6, k + 2, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 7, j + 6, k + 3, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 7, j + 6, k + 4, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 7, j + 6, k + 5, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 7, j + 6, k + 6, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 7, j + 6, k + 7, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 7, j + 6, k + 8, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 7, j + 6, k + 9, stoneSingleSlab, 0, 2);
        world.func_147465_d(i + 5, j + 3, k + 2, Blocks.field_150452_aw, 0, 2);
        world.func_147465_d(i + 6, j + 2, k + 7, lavaStill, 0, 2);
        world.func_147465_d(i + 6, j + 2, k + 8, lavaStill, 0, 2);
        for (int posX = i; posX <= i + 7; ++posX) {
            for (int posZ = k; posZ <= k + 9; ++posZ) {
                int posY = j;
                boolean isFloorFinished = false;
                while (!isFloorFinished) {
                    if (world.func_147439_a(posX, posY, posZ) == air || world.func_147439_a(posX, posY, posZ) == Blocks.field_150329_H || world.func_147439_a(posX, posY, posZ) == Blocks.field_150434_aF || world.func_147439_a(posX, posY, posZ) == Blocks.field_150328_O || world.func_147439_a(posX, posY, posZ) == Blocks.field_150327_N || world.func_147439_a(posX, posY, posZ) == Blocks.field_150330_I || world.func_147439_a(posX, posY, posZ) == Blocks.field_150433_aE || world.func_147439_a(posX, posY, posZ) == Blocks.field_150355_j || world.func_147439_a(posX, posY, posZ) == Blocks.field_150353_l || world.func_147439_a(posX, posY, posZ) == Blocks.field_150338_P || world.func_147439_a(posX, posY, posZ) == Blocks.field_150337_Q || world.func_147439_a(posX, posY, posZ) == Blocks.field_150392_bi) {
                        world.func_147465_d(posX, posY, posZ, whiteStone, 0, 2);
                        --posY;
                        continue;
                    }
                    isFloorFinished = true;
                }
            }
        }
        if (FarlandersMod.farlanderSpawn == 1) {
            EntityFarlander var5 = new EntityFarlander(world, i + 2, j + 2, k + 5, true);
            var5.func_70107_b(i + 2, j + 2, k + 5);
            world.func_72838_d((Entity)var5);
        }
        if (FarlandersMod.enderGuardianSpawn == 1) {
            EntityEnderGuardian var5 = new EntityEnderGuardian(world, i + 2, j + 2, k + 6, true);
            var5.func_70107_b(i + 2, j + 2, k + 6);
            world.func_72838_d((Entity)var5);
        }
        return true;
    }
}

