/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldscan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import wtf.api.Replacer;
import wtf.init.BlockSets;
import wtf.utilities.wrappers.AdjPos;
import wtf.utilities.wrappers.CaveListWrapper;
import wtf.utilities.wrappers.CavePosition;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.utilities.wrappers.SurfacePos;

public class WorldScanner {
    public HashMap<BlockPos, CaveListWrapper> airBlocks = new HashMap();

    public ChunkScan getChunkScan(World world, ChunkCoords coords) {
        ArrayList<CaveListWrapper> caveareas = new ArrayList<CaveListWrapper>();
        SurfacePos[][] surfacepositions = new SurfacePos[16][16];
        Chunk chunk = coords.getChunk(world);
        int lastY = 70;
        int surfaceaverage = 0;
        HashMap<Integer, Boolean> xArray = new HashMap<Integer, Boolean>();
        for (int xloop = 0; xloop < 16; ++xloop) {
            HashMap<Integer, Boolean> zArray = new HashMap<Integer, Boolean>();
            int x = coords.getWorldX() + xloop;
            for (int zloop1 = 0; zloop1 < 16; ++zloop1) {
                boolean zig;
                int zloop;
                if ((xloop & 1) == 0) {
                    zloop = zloop1;
                    zig = true;
                } else {
                    zloop = 15 - zloop1;
                    zig = false;
                }
                int z = coords.getWorldZ() + zloop;
                int y = this.scanForSurface(chunk, x, lastY, z);
                surfacepositions[xloop][zloop] = y < 0 ? new SurfacePos(x, y *= -1, z).setGenerated() : new SurfacePos(x, y, z);
                lastY = y;
                surfaceaverage += y;
                int ceiling = -1;
                boolean caveStartFound = false;
                ArrayList<Object> wallPos = new ArrayList<BlockPos>();
                ArrayList<AdjPos> adjPos = new ArrayList<AdjPos>();
                --y;
                while (y > 1) {
                    CaveListWrapper cavewrapper;
                    BlockPos currentPos = new BlockPos(x, y, z);
                    BlockPos prevZpos = zig ? new BlockPos(x, y, z - 1) : new BlockPos(x, y, z + 1);
                    EnumFacing prevFaceZ = zig ? EnumFacing.NORTH : EnumFacing.SOUTH;
                    EnumFacing nextFaceZ = zig ? EnumFacing.SOUTH : EnumFacing.NORTH;
                    boolean isAir = this.isAirAndCheck(chunk, x, y, z);
                    if (!xArray.containsKey(zloop * 256 + y)) {
                        xArray.put(zloop * 256 + y, isAir);
                        if (isAir && !this.getIsAir(world, currentPos.func_177976_e()) && this.isWall(world, currentPos.func_177976_e())) {
                            wallPos.add(currentPos.func_177976_e());
                            adjPos.add(new AdjPos(currentPos, EnumFacing.WEST));
                        }
                    } else if (isAir != (Boolean)xArray.get(zloop * 256 + y)) {
                        xArray.put(zloop * 256 + y, isAir);
                        if (isAir) {
                            if (this.isWall(chunk, currentPos.func_177976_e())) {
                                wallPos.add(currentPos.func_177976_e());
                                adjPos.add(new AdjPos(currentPos, EnumFacing.WEST));
                            }
                        } else if (this.isWall(chunk, currentPos) && (cavewrapper = this.airBlocks.get(currentPos.func_177976_e())) != null) {
                            cavewrapper.addWall(currentPos, new AdjPos(currentPos.func_177976_e(), EnumFacing.EAST));
                        }
                    }
                    if (xloop == 15 && isAir && !this.getIsAir(world, currentPos.func_177974_f()) && this.isWall(world, currentPos.func_177974_f())) {
                        wallPos.add(currentPos.func_177974_f());
                        adjPos.add(new AdjPos(currentPos, EnumFacing.EAST));
                    }
                    if (!zArray.containsKey(y)) {
                        zArray.put(y, this.getIsAir(world, prevZpos));
                        if (isAir && !this.getIsAir(world, prevZpos) && this.isWall(world, prevZpos)) {
                            wallPos.add(prevZpos);
                            adjPos.add(new AdjPos(currentPos, prevFaceZ));
                        }
                    } else if (isAir != (Boolean)zArray.get(y)) {
                        zArray.put(y, isAir);
                        if (isAir) {
                            if (this.isWall(chunk, prevZpos)) {
                                wallPos.add(prevZpos);
                                adjPos.add(new AdjPos(currentPos, prevFaceZ));
                            }
                        } else if (this.isWall(chunk, currentPos) && (cavewrapper = this.airBlocks.get(prevZpos)) != null) {
                            cavewrapper.addWall(currentPos, new AdjPos(prevZpos, nextFaceZ));
                        }
                    }
                    if (zloop1 == 15 && isAir && !this.getIsAir(world, currentPos.func_177968_d()) && this.isWall(world, currentPos.func_177968_d())) {
                        wallPos.add(currentPos.func_177968_d());
                        adjPos.add(new AdjPos(currentPos, EnumFacing.SOUTH));
                    }
                    if (isAir) {
                        if (!caveStartFound && ceiling == -1) {
                            ceiling = y + 1;
                            caveStartFound = true;
                        }
                    } else {
                        if (ceiling != -1) {
                            CaveListWrapper cave = null;
                            CavePosition pos = new CavePosition(x, ceiling, y, z);
                            Iterator<CaveListWrapper> iterator = caveareas.iterator();
                            if (iterator.hasNext()) {
                                CaveListWrapper cavewrapper2 = iterator.next();
                                cave = cavewrapper2.addPos(pos, wallPos, adjPos);
                            }
                            if (cave == null) {
                                cave = new CaveListWrapper(pos, wallPos, adjPos);
                                caveareas.add(cave);
                            }
                            for (int loop = y + 1; loop < ceiling; ++loop) {
                                this.airBlocks.put(new BlockPos(x, loop, z), cave);
                            }
                            wallPos = new ArrayList();
                            adjPos = new ArrayList();
                            ceiling = -1;
                        }
                        caveStartFound = false;
                    }
                    --y;
                }
            }
        }
        return new ChunkScan(world, surfacepositions, coords.getWorldX(), coords.getWorldZ(), surfaceaverage /= 256, caveareas);
    }

    public int scanForSurface(Chunk chunk, int x, int y, int z) {
        int generated = 1;
        while (!chunk.func_177444_d(new BlockPos(x & 0xF, y, z & 0xF)) && y < 256) {
            y += 10;
        }
        while (this.isAirAndCheck(chunk, x, y, z) && y > 10) {
            --y;
        }
        while (!this.isSurfaceAndCheck(chunk, x, y, z) && y > 10) {
            generated = -1;
            --y;
        }
        return y * generated;
    }

    public boolean isAirAndCheck(Chunk chunk, int x, int y, int z) {
        Block block = chunk.func_186032_a(x & 0xF, y, z & 0xF).func_177230_c();
        Replacer replacer = BlockSets.isNonSolidAndCheckReplacement.get(block);
        if (replacer != null) {
            return replacer.isNonSolidAndReplacement(chunk, new BlockPos(x & 0xF, y, z & 0xF), block);
        }
        return false;
    }

    public boolean isWall(Chunk chunk, BlockPos pos) {
        return !this.getIsAir(chunk, pos.func_177984_a()) && !this.getIsAir(chunk, pos.func_177977_b());
    }

    public boolean isWall(World world, BlockPos pos) {
        return !this.getIsAir(world, pos.func_177984_a()) && !this.getIsAir(world, pos.func_177977_b());
    }

    public boolean getIsAir(Chunk chunk, BlockPos pos) {
        return BlockSets.nonSolidBlockSet.contains(chunk.func_177435_g(pos).func_177230_c());
    }

    public boolean getIsAir(World world, BlockPos pos) {
        return BlockSets.nonSolidBlockSet.contains(world.func_180495_p(pos).func_177230_c());
    }

    public boolean isSurfaceAndCheck(Chunk chunk, int x, int y, int z) {
        Replacer replacer;
        Block block = chunk.func_177435_g(new BlockPos(x & 0xF, y, z & 0xF)).func_177230_c();
        if (BlockSets.isNonSolidAndCheckReplacement.containsKey(block) && (replacer = BlockSets.isNonSolidAndCheckReplacement.get(block)) != null) {
            replacer.isNonSolidAndReplacement(chunk, new BlockPos(x & 0xF, y, z & 0xF), block);
        }
        return BlockSets.surfaceBlocks.contains(block);
    }
}

