/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldscan;

import java.util.HashMap;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import wtf.api.PopulationGenerator;
import wtf.api.WTFWorldGen;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.worldscan.NetherScanner;
import wtf.worldscan.WorldScanner;

public class CoreWorldGenListener {
    public static HashMap<ChunkCoords, ChunkScan> worldChunkScans = new HashMap();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void populate(PopulateChunkEvent.Post event) throws Exception {
        if (!event.getWorld().field_72995_K && event.getWorld().func_175624_G() != WorldType.field_77138_c) {
            ChunkCoords coords = new ChunkCoords(event.getChunkX(), event.getChunkZ());
            ChunkProviderServer chunkserver = (ChunkProviderServer)event.getWorld().func_72863_F();
            for (int xloop = -1; xloop < 2; ++xloop) {
                for (int zloop = -1; zloop < 2; ++zloop) {
                    int adjZ;
                    int adjX = coords.getChunkX() + xloop;
                    if (!chunkserver.func_73149_a(adjX, adjZ = coords.getChunkZ() + zloop) || !event.getWorld().func_72964_e(adjX, adjZ).func_177419_t()) continue;
                    CoreWorldGenListener.doScanIfAdjArePopulated(event.getWorld(), chunkserver, event.getRand(), new ChunkCoords(adjX, adjZ));
                }
            }
        }
    }

    public static void doScanIfAdjArePopulated(World world, ChunkProviderServer chunkserver, Random random, ChunkCoords coords) throws Exception {
        for (int xloop = -1; xloop < 2; ++xloop) {
            for (int zloop = -1; zloop < 2; ++zloop) {
                int adjZ;
                int adjX = coords.getChunkX() + xloop;
                if (chunkserver.func_73149_a(adjX, adjZ = coords.getChunkZ() + zloop) && world.func_72964_e(adjX, adjZ).func_177419_t()) continue;
                return;
            }
        }
        CoreWorldGenListener.doChunk(world, random, coords);
    }

    public static void doChunk(World world, Random random, ChunkCoords coords) throws Exception {
        WorldScanner scanner = null;
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                scanner = new WorldScanner();
                break;
            }
            case -1: {
                scanner = new NetherScanner();
                break;
            }
        }
        if (scanner != null) {
            ChunkScan scan = scanner.getChunkScan(world, coords);
            worldChunkScans.put(coords, scan);
            for (PopulationGenerator generator : WTFWorldGen.getGenerators()) {
                generator.generate(world, coords, random, scan);
            }
        }
    }

    public static ChunkScan getChunkScan(World world, ChunkCoords coords) throws Exception {
        ChunkScan scan = worldChunkScans.get(coords);
        if (scan == null && coords.exists(world)) {
            WorldScanner scanner = new WorldScanner();
            scan = scanner.getChunkScan(world, coords);
            worldChunkScans.put(coords, scan);
        }
        if (worldChunkScans.size() > 1000) {
            System.out.println("Clearing World Scans");
            worldChunkScans.clear();
        }
        return scan;
    }
}

