/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.trees.types;

import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import wtf.worldgen.trees.TreeVars;

public class SwampTree
extends TreeVars {
    public SwampTree(World world) {
        super(world, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), Blocks.field_150362_t.func_176223_P());
        this.leafRad = 3.0;
        this.leafYMax = 2.0;
        this.leafYMin = -1.0;
        this.vines = 6;
        this.leafYMax = 3.0;
        this.topLimitDown = 1.5707963267948966;
    }

    @Override
    public int getBranchesPerNode(double scale) {
        return this.random.nextInt(3) + 4;
    }

    @Override
    public double getBranchRotation(double scale, double numBranches) {
        return Math.PI / numBranches;
    }

    @Override
    public double getBranchSeperation(double scale) {
        return this.random.nextInt(4) + 2;
    }

    @Override
    public double getBranchPitch(double scale) {
        return 0.35;
    }

    @Override
    public double getBranchLength(double scale, double trunkHeight, double nodeHeight) {
        double taper = 1.0 - nodeHeight / trunkHeight;
        return trunkHeight / 2.0 + trunkHeight / 2.0 * taper;
    }

    @Override
    public double getTrunkHeight(double scale) {
        return 8.0 + 8.0 * scale + (double)this.random.nextInt(8);
    }

    @Override
    public double getRootLength(double trunkHeight) {
        return trunkHeight / 3.0;
    }

    @Override
    public double getTrunkDiameter(double scale) {
        return MathHelper.func_76143_f((double)(1.1 + scale));
    }

    @Override
    public int getTrunkColumnHeight(double trunkHeight, double currentRadius, double maxRadius) {
        if (currentRadius > 1.0) {
            double thirdHeight = trunkHeight / 3.0;
            double rad = 1.0 - currentRadius / maxRadius;
            return (int)(thirdHeight + thirdHeight * rad + (double)this.random.nextInt(5) - 2.0);
        }
        return MathHelper.func_76143_f((double)trunkHeight);
    }

    @Override
    public double getLowestBranchRatio() {
        return 0.15;
    }

    @Override
    public int getNumRoots(double trunkDiameter) {
        return MathHelper.func_76128_c((double)(this.PId2 * (trunkDiameter + 1.0)));
    }
}

