/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.trees.types;

import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import wtf.blocks.BlockFoxfire;
import wtf.init.WTFBlocks;
import wtf.worldgen.trees.TreeVars;

public class RootsOnly
extends TreeVars {
    public final int size;

    public RootsOnly(World world, IBlockState wood, int size) {
        super(world, wood, wood, null);
        this.size = size;
        if (wood.hashCode() == Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.DARK_OAK).hashCode()) {
            this.rootDecoRate = 0.05f;
            this.decoDown = WTFBlocks.foxfire.func_176223_P().func_177226_a((IProperty)BlockFoxfire.HANGING, (Comparable)Boolean.valueOf(true));
            this.decoUp = WTFBlocks.foxfire.func_176223_P();
        }
    }

    @Override
    public int getBranchesPerNode(double scale) {
        return 4;
    }

    @Override
    public double getBranchRotation(double scale, double numBranches) {
        return Math.PI / numBranches;
    }

    @Override
    public double getBranchSeperation(double scale) {
        return 2.0;
    }

    @Override
    public double getBranchPitch(double scale) {
        return 0.5;
    }

    @Override
    public double getLowestBranchRatio() {
        return 0.5;
    }

    @Override
    public double getBranchLength(double scale, double trunkHeight, double nodeHeight) {
        return 5.0;
    }

    @Override
    public double getTrunkHeight(double scale) {
        return this.size;
    }

    @Override
    public double getRootLength(double trunkHeight) {
        int length = (int)(trunkHeight / 4.0);
        return length > 1 ? (double)length : 2.0;
    }

    @Override
    public double getTrunkDiameter(double scale) {
        return 1.0;
    }

    @Override
    public int getTrunkColumnHeight(double trunkHeight, double currentRadius, double maxRadius) {
        return this.size;
    }

    @Override
    public int getNumRoots(double trunkDiameter) {
        return this.random.nextInt(2) + 3;
    }
}

