/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.trees.types;

import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import wtf.worldgen.trees.TreeVars;

public class RedwoodTree
extends TreeVars {
    public RedwoodTree(World world) {
        super(world, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.SPRUCE));
        this.leaftype = TreeVars.LeafStyle.SPRUCE;
        this.topLimitDown = 2.0;
        this.topLimitUp = 0.0;
        this.topLimitIncrement = 0.39269908169872414;
    }

    @Override
    public int getBranchesPerNode(double scale) {
        return (int)(15.0 + 15.0 * scale);
    }

    @Override
    public double getBranchRotation(double scale, double numBranches) {
        return Math.PI / (numBranches + 1.0);
    }

    @Override
    public double getBranchSeperation(double scale) {
        return 1.0;
    }

    @Override
    public double getBranchPitch(double scale) {
        return -0.2;
    }

    @Override
    public double getBranchLength(double scale, double trunkHeight, double nodeHeight) {
        double taper = 1.0 - nodeHeight / trunkHeight;
        return trunkHeight / 3.0 * taper * (double)(2.0f + this.random.nextFloat());
    }

    @Override
    public double getTrunkHeight(double scale) {
        return (double)(33 + this.random.nextInt(33)) + 33.0 * scale;
    }

    @Override
    public double getRootLength(double trunkHeight) {
        return trunkHeight / 4.0;
    }

    @Override
    public double getTrunkDiameter(double scale) {
        return (double)(this.random.nextInt(4) + 4) + scale * 4.0;
    }

    @Override
    public int getTrunkColumnHeight(double trunkHeight, double currentRadius, double maxRadius) {
        if (currentRadius > 1.0) {
            double thirdHeight = trunkHeight / 3.0;
            double rad = 1.0 - currentRadius / maxRadius;
            return (int)(thirdHeight + 2.0 * (thirdHeight * rad) + (double)this.random.nextInt(5) - 2.0);
        }
        return MathHelper.func_76143_f((double)trunkHeight);
    }

    @Override
    public double getLowestBranchRatio() {
        return 0.8;
    }

    @Override
    public int getNumRoots(double trunkDiameter) {
        return this.random.nextInt(4) + 4;
    }
}

