/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.trees.types;

import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import wtf.worldgen.trees.TreeVars;

public class JungleTree
extends TreeVars {
    public JungleTree(World world) {
        super(world, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE));
        this.leafYMin = 0.0;
        this.leafYMax = 2.0;
        this.leafRad = 3.5;
        this.airGenerate = true;
        this.airGenHeight = 3.0;
        this.growDense = false;
        this.cocoa = true;
        this.rootFinalAngle = 0.5;
        this.vines = 3;
        this.rootInitialAngle = 1.0;
        this.rootIncrementAngle = 0.3f;
        this.genBuffer = -6;
    }

    @Override
    public int getBranchesPerNode(double scale) {
        return (int)MathHelper.func_151237_a((double)this.random.nextInt(2), (double)1.0, (double)2.0);
    }

    @Override
    public double getBranchRotation(double scale, double numBranches) {
        return numBranches;
    }

    @Override
    public double getBranchSeperation(double scale) {
        return this.random.nextInt(4) + 4;
    }

    @Override
    public double getBranchPitch(double scale) {
        return 0.5;
    }

    @Override
    public double getBranchLength(double scale, double trunkHeight, double nodeHeight) {
        double taper = 1.0 - nodeHeight / trunkHeight;
        return trunkHeight / 2.0 * taper;
    }

    @Override
    public double getTrunkHeight(double scale) {
        return (double)(16 + this.random.nextInt(16)) + 16.0 * scale;
    }

    @Override
    public double getRootLength(double trunkHeight) {
        return trunkHeight / 4.0;
    }

    @Override
    public double getTrunkDiameter(double scale) {
        return 2.0;
    }

    @Override
    public int getTrunkColumnHeight(double trunkHeight, double currentRadius, double maxRadius) {
        return (int)trunkHeight;
    }

    @Override
    public double getLowestBranchRatio() {
        return (double)(this.random.nextFloat() / 2.0f) + 0.25;
    }

    @Override
    public int getNumRoots(double trunkDiameter) {
        return MathHelper.func_76128_c((double)(this.PId2 * (trunkDiameter + 1.0)));
    }
}

