/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.trees.types;

import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import wtf.blocks.BlockFoxfire;
import wtf.init.WTFBlocks;
import wtf.worldgen.trees.TreeVars;

public class DarkOakTree
extends TreeVars {
    public DarkOakTree(World world) {
        super(world, Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.DARK_OAK), Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.DARK_OAK), Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)BlockPlanks.EnumType.DARK_OAK));
        this.leafRad = 4.0;
        this.leafYMax = 4.0;
        this.leafYMin = -2.0;
        this.rootDecoRate = 0.01f;
        this.decoDown = WTFBlocks.foxfire.func_176223_P().func_177226_a((IProperty)BlockFoxfire.HANGING, (Comparable)Boolean.valueOf(true));
        this.decoUp = WTFBlocks.foxfire.func_176223_P();
        this.genBuffer = -10;
        this.rootInitialAngle = 1.35;
        this.rootLevel = 2.0;
        this.rootWall = true;
    }

    @Override
    public int getBranchesPerNode(double scale) {
        return 10;
    }

    @Override
    public double getBranchRotation(double scale, double numBranches) {
        return Math.PI / numBranches;
    }

    @Override
    public double getBranchSeperation(double scale) {
        return 3.0;
    }

    @Override
    public double getBranchPitch(double scale) {
        return 0.0;
    }

    @Override
    public double getBranchLength(double scale, double trunkHeight, double nodeHeight) {
        double taper = 1.0 - nodeHeight / trunkHeight;
        return trunkHeight / 2.0 + trunkHeight / 2.0 * taper;
    }

    @Override
    public double getTrunkHeight(double scale) {
        return (double)(6 + this.random.nextInt(8)) + 8.0 * scale;
    }

    @Override
    public double getRootLength(double trunkHeight) {
        return trunkHeight / 3.0;
    }

    @Override
    public double getTrunkDiameter(double scale) {
        return 1.5 + 2.0 * scale;
    }

    @Override
    public int getTrunkColumnHeight(double trunkHeight, double currentRadius, double maxRadius) {
        if (currentRadius > 1.0) {
            double thirdHeight = trunkHeight / 3.0;
            double rad = 1.0 - currentRadius / maxRadius;
            return (int)(thirdHeight + thirdHeight * rad + (double)this.random.nextInt(5) - 2.0);
        }
        return MathHelper.func_76143_f((double)trunkHeight);
    }

    @Override
    public double getLowestBranchRatio() {
        return 1.0;
    }

    @Override
    public int getNumRoots(double trunkDiameter) {
        return 4;
    }
}

