/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.trees.types;

import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;
import wtf.worldgen.trees.TreeVars;

public class BigTree
extends TreeVars {
    public BigTree(World world, IBlockState wood, IBlockState branch, IBlockState leaf) {
        super(world, wood, branch, leaf);
        this.topLimitDown = 1.5707963267948966;
        this.genBuffer = 1;
    }

    @Override
    public double getBranchLength(double scale, double trunkHeight, double nodeHeight) {
        double taper = 1.0 - nodeHeight / trunkHeight;
        double halfLength = trunkHeight / 4.0;
        return halfLength * taper + halfLength;
    }

    @Override
    public double getTrunkHeight(double scale) {
        return (double)(8 + this.random.nextInt(8)) + 8.0 * scale;
    }

    @Override
    public double getTrunkDiameter(double scale) {
        return 2.0;
    }

    @Override
    public int getBranchesPerNode(double scale) {
        return this.random.nextInt(3) + 3;
    }

    @Override
    public double getBranchRotation(double scale, double numBranches) {
        return Math.PI * 2 / (numBranches + 1.0);
    }

    @Override
    public double getBranchSeperation(double scale) {
        return 2.0;
    }

    @Override
    public double getBranchPitch(double scale) {
        return 0.5;
    }

    @Override
    public double getRootLength(double trunkHeight) {
        return trunkHeight / 4.0;
    }

    @Override
    public int getTrunkColumnHeight(double trunkHeight, double currentRadius, double maxRadius) {
        return (int)trunkHeight;
    }

    @Override
    public double getLowestBranchRatio() {
        return (double)(this.random.nextFloat() / 2.0f) + 0.25;
    }

    @Override
    public int getNumRoots(double trunkDiameter) {
        return this.random.nextInt(3) + 3;
    }
}

