/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.trees;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wtf.init.WTFBlocks;
import wtf.utilities.Simplex;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkDividedHashMap;
import wtf.utilities.wrappers.ChunkScan;
import wtf.worldgen.trees.TreeVars;

public class TreePos {
    public final Random random;
    public final World world;
    public final BlockPos pos;
    public final double oriX;
    public final double y;
    public final double oriZ;
    public final TreeVars type;
    public final double trunkDiameter;
    public final double trunkRadius;
    public final double trunkHeight;
    public final double rootLevel;
    public final double scale;
    public static Simplex simplex;
    public ChunkScan chunkscan;
    Block[] groundArray = new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150351_n, WTFBlocks.mossyDirt};
    public HashSet<Block> groundBlocks = new HashSet<Block>(Arrays.asList(this.groundArray));
    public HashMap<BlockPos, IBlockState> trunkBlocks = new HashMap();
    private HashMap<BlockPos, IBlockState> leafBlocks = new HashMap();
    private HashMap<BlockPos, IBlockState> rootBlocks = new HashMap();
    private HashMap<BlockPos, IBlockState> decoBlocks = new HashMap();
    int airHash = Blocks.field_150350_a.hashCode();

    public TreePos(World world, Random random, ChunkScan chunkscan, BlockPos pos, TreeVars tree) {
        this.world = world;
        this.random = random;
        this.pos = pos;
        this.oriX = (pos.func_177958_n() & 1) == 0 ? (double)pos.func_177958_n() + 0.5 : (double)pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.oriZ = (pos.func_177952_p() & 1) == 0 ? (double)pos.func_177952_p() + 0.5 : (double)pos.func_177952_p();
        this.type = tree;
        if (simplex == null) {
            simplex = new Simplex((int)world.func_72905_C());
        }
        this.scale = simplex.noise(pos.func_177958_n() / 100, pos.func_177952_p() / 100) * 0.5 + 0.5;
        this.trunkHeight = tree.getTrunkHeight(this.scale);
        this.trunkDiameter = tree.getTrunkDiameter(this.scale);
        this.trunkRadius = this.trunkDiameter / 2.0;
        this.rootLevel = !tree.airGenerate ? (tree.rootLevel == 0.0 ? (double)random.nextInt(2) : tree.rootLevel) : tree.airGenHeight;
        this.chunkscan = chunkscan;
    }

    public void setTrunk(BlockPos pos) {
        this.trunkBlocks.put(pos, this.type.wood);
    }

    public void setRoot(BlockPos pos) {
        this.rootBlocks.put(pos, this.type.wood.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE));
    }

    public void setBranch(BlockPos pos, BlockLog.EnumAxis axis) {
        this.rootBlocks.put(pos, this.type.branch.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)axis));
    }

    public void setLeaf(BlockPos pos) {
        if (this.world.func_180495_p(pos).func_177230_c().hashCode() == this.airHash) {
            this.leafBlocks.put(pos, this.type.leaf.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void setDeco(BlockPos pos, IBlockState state) {
        this.decoBlocks.put(pos, state);
    }

    public void placeBlocks() {
        ChunkDividedHashMap masterMap = new ChunkDividedHashMap(this.world, new ChunkCoords(this.pos));
        masterMap.putAll(this.decoBlocks);
        masterMap.putAll(this.leafBlocks);
        masterMap.putAll(this.rootBlocks);
        masterMap.putAll(this.trunkBlocks);
        masterMap.setBlockSet();
    }

    public boolean inTrunk(BlockPos pos) {
        return this.trunkBlocks.containsKey(pos);
    }
}

