/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.trees;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.Loader;
import rtg.world.WorldTypeRTG;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.gen.feature.tree.rtg.TreeRTG;
import wtf.utilities.wrappers.ChunkScan;
import wtf.worldgen.OverworldGen;

public class RTGCompat {
    static ArrayList<TreeRTG> rtgtrees = new ArrayList();

    public static boolean RTG(World world) {
        return Loader.isModLoaded((String)"RTG") && world.func_72912_H().func_76067_t() instanceof WorldTypeRTG;
    }

    public static TreeRTG getRTGTree(Random random, Biome biome) {
        RealisticBiomeBase rb = RealisticBiomeBase.getBiome((int)Biome.func_185362_a((Biome)biome));
        ArrayList biomeTrees = rb.rtgTrees;
        if (biomeTrees.size() > 0) {
            TreeRTG rtgtree = (TreeRTG)biomeTrees.get(random.nextInt(biomeTrees.size()));
            int size = rtgtree.maxTrunkSize - rtgtree.minTrunkSize > 4 ? rtgtree.maxTrunkSize - rtgtree.minTrunkSize : 4;
            rtgtree.trunkSize = random.nextInt(size) + rtgtree.minTrunkSize;
            size = rtgtree.maxCrownSize - rtgtree.minCrownSize;
            int n = rtgtree.crownSize = size > 0 ? random.nextInt(size) + rtgtree.minCrownSize : 2;
            if (rtgtree.noLeaves) {
                rtgtree.noLeaves = false;
            }
            return rtgtree;
        }
        return null;
    }

    public static boolean tryRTGRoots(World world, BlockPos pos, Random random, ChunkScan chunkscan, WorldGenerator oldTree) {
        if (OverworldGen.RTG && oldTree instanceof TreeRTG) {
            OverworldGen.addRoots(world, pos, random, chunkscan, ((TreeRTG)oldTree).trunkSize);
            return true;
        }
        return false;
    }

    public static WorldGenerator getNonSpruceRTG(Biome parentBiome, Random random, Boolean doReplace) {
        if (rtgtrees.size() < 1) {
            RealisticBiomeBase rb = RealisticBiomeBase.getBiome((int)Biome.func_185362_a((Biome)parentBiome));
            ArrayList biomeTrees = rb.rtgTrees;
            IBlockState[] leaflist = new IBlockState[]{Blocks.field_150362_t.func_176223_P(), Blocks.field_150362_t.func_176203_a(2), Blocks.field_150361_u.func_176203_a(1)};
            HashSet<IBlockState> leaves = new HashSet<IBlockState>(Arrays.asList(leaflist));
            for (TreeRTG rtgtree : biomeTrees) {
                if (leaves.contains(rtgtree.leavesBlock)) {
                    int size = rtgtree.maxTrunkSize - rtgtree.minTrunkSize > 4 ? rtgtree.maxTrunkSize - rtgtree.minTrunkSize : 4;
                    rtgtree.trunkSize = random.nextInt(size) + rtgtree.minTrunkSize;
                    size = rtgtree.maxCrownSize - rtgtree.minCrownSize;
                    int n = rtgtree.crownSize = size > 0 ? random.nextInt(size) + rtgtree.minCrownSize : 2;
                }
                if (rtgtree.noLeaves) {
                    rtgtree.noLeaves = false;
                }
                rtgtrees.add(rtgtree);
            }
        }
        return (WorldGenerator)rtgtrees.get(random.nextInt(rtgtrees.size()));
    }
}

