/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.trees;

import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import wtf.init.BlockSets;
import wtf.worldgen.trees.TreePos;
import wtf.worldgen.trees.components.Branch;
import wtf.worldgen.trees.components.ColumnTrunk;
import wtf.worldgen.trees.components.Root;

public class GenTree {
    private static final float PIx2 = (float)Math.PI * 2;
    private static final float PId2 = 1.5707964f;
    private static final float PId4 = 0.7853982f;
    static int airHash = Blocks.field_150350_a.hashCode();
    static Material[] replaceables = new Material[]{Material.field_151579_a, Material.field_151570_A, Material.field_151572_C, Material.field_151577_b, Material.field_151584_j, Material.field_151582_l, Material.field_151585_k, Material.field_151588_w, Material.field_151598_x, Material.field_151578_c, Material.field_151595_p, Material.field_151586_h, Material.field_151597_y};
    protected static HashSet<Material> rootReplaceable = new HashSet<Material>(Arrays.asList(replaceables));

    public static boolean tryGenerate(TreePos tree) throws Exception {
        if (!tree.chunkscan.checkPositionForTreeGen(tree.world, tree)) {
            return false;
        }
        if (GenTree.genTrunk(tree)) {
            float offset = GenTree.genTop(tree, tree.random.nextFloat() * ((float)Math.PI * 2));
            GenTree.doBranches(tree, offset);
            GenTree.genMainRoots(tree);
            tree.placeBlocks();
            tree.chunkscan.setGenerated(tree.pos, (int)((double)tree.type.genBuffer + tree.trunkRadius + tree.type.getBranchLength(tree.scale, tree.trunkHeight, tree.trunkHeight / 2.0) + tree.type.leafRad / 2.0));
            return true;
        }
        return false;
    }

    public static boolean genRootsOnly(TreePos tree) {
        GenTree.genMainRoots(tree);
        tree.placeBlocks();
        return true;
    }

    protected static boolean genTrunk(TreePos tree) {
        int startloop = tree.trunkDiameter > 1.0 ? MathHelper.func_76128_c((double)(-tree.trunkRadius)) : 0;
        int finishLoop = MathHelper.func_76143_f((double)tree.trunkRadius);
        for (int loopX = startloop; loopX < finishLoop; ++loopX) {
            for (int loopZ = startloop; loopZ < finishLoop; ++loopZ) {
                double currentRadius = Math.sqrt(loopX * loopX + loopZ * loopZ);
                if (!(tree.trunkRadius <= 1.0) && !(currentRadius <= tree.trunkRadius)) continue;
                double startHeight = tree.y + (double)tree.type.getTrunkColumnHeight(tree.trunkHeight, currentRadius, tree.trunkRadius);
                ColumnTrunk column = new ColumnTrunk(tree.oriX + (double)loopX, tree.oriZ + (double)loopZ, startHeight);
                BlockPos pos = column.currentPos();
                while (BlockSets.nonSolidBlockSet.contains(GenTree.getBlockState(tree, pos).func_177230_c()) && (double)pos.func_177956_o() > tree.y - 4.0) {
                    if (!tree.type.airGenerate || (double)(pos.func_177956_o() - tree.pos.func_177956_o()) > tree.type.airGenHeight) {
                        tree.setTrunk(pos);
                    }
                    pos = column.nextPos();
                }
                if (!(Math.abs(column.currentY - tree.y) > 2.0)) continue;
                return false;
            }
        }
        return true;
    }

    public static float genTop(TreePos tree, float offset) {
        for (double topLoop = tree.type.topLimitUp; topLoop < tree.type.topLimitDown; topLoop += tree.type.topLimitIncrement) {
            int branches = tree.type.getBranchesPerNode(tree.scale);
            offset = (float)((double)offset + tree.type.getBranchRotation(tree.scale, branches));
            for (int loopMultiBranches = 0; loopMultiBranches < branches; ++loopMultiBranches) {
                double offSetForBranch = offset + (float)Math.PI * 2 / (float)branches * (float)loopMultiBranches;
                double sinTop = Math.sin(topLoop);
                double vecY = Math.cos(topLoop);
                double vecX = Math.cos(offSetForBranch) * sinTop;
                double vecZ = Math.sin(offSetForBranch) * sinTop;
                Branch branch = new Branch(tree.oriX, tree.trunkHeight + tree.y, tree.oriZ, vecX, vecY, vecZ, tree.type.getBranchLength(tree.scale, tree.trunkHeight, tree.trunkHeight));
                GenTree.genBranch(tree, branch);
                offset = (float)((double)offset + tree.type.getBranchRotation(tree.scale, branches));
            }
        }
        return offset;
    }

    public static void doBranches(TreePos tree, float offset) {
        int lowestBranch = MathHelper.func_76128_c((double)(tree.trunkHeight * tree.type.getLowestBranchRatio()));
        for (double nodeHeight = tree.trunkHeight - tree.type.getBranchSeperation(tree.scale); nodeHeight > (double)lowestBranch; nodeHeight -= tree.type.getBranchSeperation(tree.scale)) {
            int branches = tree.type.getBranchesPerNode(tree.scale);
            for (int loopMultiBranches = 0; loopMultiBranches < branches; ++loopMultiBranches) {
                float offSetForBranch = offset + (float)Math.PI * 2 / (float)branches * (float)loopMultiBranches;
                float vecX = MathHelper.func_76134_b((float)offSetForBranch);
                float vecZ = MathHelper.func_76126_a((float)offSetForBranch);
                Branch branch = new Branch(tree.oriX, nodeHeight + tree.y, tree.oriZ, vecX, tree.type.getBranchPitch(tree.scale), vecZ, tree.type.getBranchLength(tree.scale, tree.trunkHeight, nodeHeight));
                GenTree.genBranch(tree, branch);
                offset = (float)((double)offset + tree.type.getBranchRotation(tree.scale, branches));
            }
            offset += 0.7853982f;
        }
    }

    public static void genMainRoots(TreePos tree) {
        double offset = tree.random.nextDouble() * 6.2831854820251465;
        for (double angleDown = tree.type.rootInitialAngle; angleDown > tree.type.rootFinalAngle; angleDown -= tree.type.rootIncrementAngle) {
            int numRoots = tree.type.getNumRoots(tree.trunkDiameter);
            for (int loopMultiBranches = 0; loopMultiBranches < numRoots; ++loopMultiBranches) {
                double offSetForBranch = offset + Math.PI / (double)numRoots * (double)loopMultiBranches;
                double vecY = Math.cos(angleDown);
                double sinY = Math.sin(angleDown);
                double vecX = Math.cos(offSetForBranch) * sinY;
                double vecZ = Math.sin(offSetForBranch) * sinY;
                Root root = new Root(tree.oriX, tree.y + tree.rootLevel + tree.type.airGenHeight, tree.oriZ, vecX, vecY, vecZ, tree.type.getRootLength(tree.trunkHeight));
                while (tree.inTrunk(root.lateralNext())) {
                }
                while (root.hasNext()) {
                    BlockPos pos = root.pos();
                    tree.setRoot(pos);
                    if (tree.type.rootWall) {
                        int loop = 1;
                        while (BlockSets.nonSolidBlockSet.contains(GenTree.getBlockState(tree, pos.func_177979_c(loop)).func_177230_c()) && (double)loop > tree.type.airGenHeight + 1.0) {
                            tree.setRoot(pos.func_177979_c(loop));
                            ++loop;
                        }
                    } else if (tree.random.nextFloat() < tree.type.rootDecoRate) {
                        if (tree.random.nextBoolean()) {
                            BlockPos decoPos = pos.func_177977_b();
                            if (GenTree.getBlockState(tree, decoPos).func_177230_c().hashCode() == airHash) {
                                tree.setDeco(pos.func_177977_b(), tree.type.decoDown);
                            }
                        } else {
                            BlockPos decoPos = pos.func_177984_a();
                            if (GenTree.getBlockState(tree, decoPos).func_177230_c().hashCode() == airHash) {
                                tree.setDeco(pos.func_177984_a(), tree.type.decoUp);
                            }
                        }
                    }
                    if (GenTree.canReplaceRoot(tree, pos.func_177977_b())) {
                        root.growDown(tree);
                        continue;
                    }
                    if (!tree.groundBlocks.contains(tree.world.func_180495_p(pos.func_177977_b()))) {
                        root.growLateral();
                        continue;
                    }
                    root.next();
                }
                offset += 0.7853981852531433;
            }
        }
    }

    protected static boolean genBranch(TreePos tree, Branch branch) {
        while (tree.inTrunk(branch.pos())) {
            branch.next();
        }
        if (tree.type.cocoa && (double)tree.random.nextFloat() < 0.3) {
            GenTree.genCocoa(tree, branch);
        }
        BlockPos pos = branch.pos();
        while (branch.hasNext()) {
            if (!GenTree.canReplace(tree, pos)) {
                return false;
            }
            switch (tree.type.leaftype) {
                case BASIC: {
                    tree.setBranch(pos, branch.axis);
                    break;
                }
                case SPRUCE: {
                    if (branch.length - (double)branch.count > 3.0) {
                        tree.setBranch(pos, branch.axis);
                    }
                    tree.setLeaf(pos.func_177984_a());
                    tree.setLeaf(pos.func_177974_f());
                    tree.setLeaf(pos.func_177976_e());
                    tree.setLeaf(pos.func_177978_c());
                    tree.setLeaf(pos.func_177968_d());
                    break;
                }
            }
            pos = branch.next();
        }
        if (!GenTree.canReplace(tree, pos)) {
            return false;
        }
        switch (tree.type.leaftype) {
            case BASIC: {
                GenTree.genLeafNode(tree, branch.pos());
                break;
            }
            case SPRUCE: {
                tree.setLeaf(pos);
                break;
            }
        }
        return true;
    }

    public static void genLeafNode(TreePos tree, BlockPos pos) {
        double height = (double)pos.func_177956_o() - tree.y;
        double taper = MathHelper.func_151237_a((double)(tree.type.leafTaper * (tree.trunkHeight - height) / tree.trunkHeight), (double)tree.type.leafTaper, (double)1.0);
        double radius = MathHelper.func_151237_a((double)(tree.type.leafRad * taper), (double)1.0, (double)tree.type.leafRad);
        double ymin = tree.type.leafYMin;
        double ymax = tree.type.leafYMax;
        for (double yloop = ymin; yloop < ymax; yloop += 1.0) {
            double sliceRadSq = (radius + 1.0) * (radius + 1.0) - yloop * yloop;
            double slicedRadSqSmall = radius * radius - yloop * yloop;
            if (!(sliceRadSq > 0.0)) continue;
            for (double xloop = -radius; xloop < radius + 1.0; xloop += 1.0) {
                for (double zloop = -radius; zloop < radius + 1.0; zloop += 1.0) {
                    double xzDistanceSq = xloop * xloop + zloop * zloop;
                    BlockPos leafPos = new BlockPos(xloop + (double)pos.func_177958_n(), yloop + (double)pos.func_177956_o(), zloop + (double)pos.func_177952_p());
                    if (xzDistanceSq < slicedRadSqSmall) {
                        tree.setLeaf(leafPos);
                        continue;
                    }
                    if (!(xzDistanceSq < sliceRadSq) || !tree.random.nextBoolean()) continue;
                    tree.setLeaf(leafPos);
                    if (tree.type.vines <= 0 || !(MathHelper.func_76132_a((double)xloop, (double)zloop) > yloop) || !tree.random.nextBoolean()) continue;
                    GenTree.genVine(tree, leafPos, xloop, zloop);
                }
            }
        }
    }

    protected static void genVine(TreePos tree, BlockPos pos, double xloop, double zloop) {
        IBlockState block = null;
        if (Math.abs(xloop) > Math.abs(zloop)) {
            if (xloop > 0.0) {
                block = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(true));
                pos = pos.func_177974_f();
            } else {
                block = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(true));
                pos = pos.func_177976_e();
            }
        } else if (zloop > 0.0) {
            block = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(true));
            pos = pos.func_177968_d();
        } else {
            block = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(true));
            pos = pos.func_177978_c();
        }
        for (int loop = tree.random.nextInt(tree.type.vines) + 1; loop > -1 && GenTree.getBlockState(tree, pos.func_177979_c(loop)).func_177230_c().hashCode() == tree.airHash; --loop) {
            tree.setDeco(pos.func_177979_c(loop), block);
        }
    }

    protected static void genCocoa(TreePos tree, Branch branch) {
        BlockPos pos = branch.pos().func_177977_b();
        if (Math.abs(branch.vecX) > Math.abs(branch.vecZ)) {
            if (branch.vecX > 0.0) {
                if (tree.trunkBlocks.containsKey(pos.func_177976_e())) {
                    tree.setDeco(pos, Blocks.field_150375_by.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.WEST));
                }
            } else if (tree.trunkBlocks.containsKey(new BlockPos((Vec3i)pos.func_177974_f()))) {
                tree.setDeco(pos, Blocks.field_150375_by.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.EAST));
            }
        } else if (branch.vecZ > 0.0) {
            if (tree.trunkBlocks.containsKey(pos.func_177968_d())) {
                tree.setDeco(pos, Blocks.field_150375_by.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.SOUTH));
            }
        } else if (tree.trunkBlocks.containsKey(pos.func_177978_c())) {
            tree.setDeco(pos, Blocks.field_150375_by.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH));
        }
    }

    protected static boolean canReplace(TreePos tree, BlockPos pos) {
        IBlockState state = GenTree.getBlockState(tree, pos);
        if (BlockSets.treeReplaceableBlocks.contains(GenTree.getBlockState(tree, pos).func_177230_c())) {
            return true;
        }
        return tree.type.growDense && state.func_185904_a().hashCode() == Material.field_151584_j.hashCode();
    }

    protected static boolean canReplaceRoot(TreePos tree, BlockPos pos) {
        return rootReplaceable.contains(tree.world.func_180495_p(pos).func_185904_a());
    }

    protected static IBlockState getBlockState(TreePos tree, BlockPos pos) {
        return tree.world.func_180495_p(pos);
    }
}

