/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.subcaves.mob;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import wtf.utilities.wrappers.CaveListWrapper;
import wtf.utilities.wrappers.CavePosition;
import wtf.worldgen.AbstractDungeonType;
import wtf.worldgen.caves.CaveBiomeGenMethods;

public class DungeonClassicSpider
extends AbstractDungeonType {
    public DungeonClassicSpider(String name) {
        super(name, 0, 0, false);
    }

    @Override
    public boolean canGenerateAt(CaveBiomeGenMethods gen, CaveListWrapper cave) {
        return this.isSize(cave, 7) && this.isHeight(cave, 5);
    }

    @Override
    public void generateCenter(CaveBiomeGenMethods gen, Random rand, CavePosition pos, float depth) {
        int center = pos.getFloorPos().func_177956_o() + (pos.getCeilingPos().func_177956_o() - pos.getFloorPos().func_177956_o()) / 2;
        for (int xloop = -1; xloop < 2; ++xloop) {
            for (int yloop = -1; yloop < 2; ++yloop) {
                block2: for (int zloop = -1; zloop < 2; ++zloop) {
                    if (!rand.nextBoolean()) continue;
                    int xweb = pos.x + xloop;
                    int yweb = center + yloop;
                    int zweb = pos.z + zloop;
                    BlockPos web = new BlockPos(xweb, yweb, zweb);
                    int count = 0;
                    while (true) {
                        if (gen.getBlockState(web).func_177230_c().hashCode() != CaveBiomeGenMethods.airHash || count >= 8) continue block2;
                        ++count;
                        gen.replaceBlock(web, Blocks.field_150321_G.func_176223_P());
                        web = new BlockPos(xweb += xloop, yweb += yloop, zweb += pos.z + zloop);
                    }
                }
            }
        }
        gen.spawnVanillaSpawner(new BlockPos(pos.x, center, pos.z), "Spider", 3);
    }

    @Override
    public void generateCeiling(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        gen.replaceBlock(pos, Blocks.field_150341_Y.func_176223_P());
    }

    @Override
    public void generateFloor(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        gen.replaceBlock(pos, Blocks.field_150341_Y.func_176223_P());
    }

    @Override
    public void generateWall(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth, int height) {
        gen.replaceBlock(pos, Blocks.field_150341_Y.func_176223_P());
    }

    @Override
    public void generateCeilingAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
    }

    @Override
    public void generateFloorAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
    }
}

