/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.subcaves.mob;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import wtf.init.BlockSets;
import wtf.utilities.wrappers.CaveListWrapper;
import wtf.utilities.wrappers.CavePosition;
import wtf.worldgen.AbstractDungeonType;
import wtf.worldgen.caves.CaveBiomeGenMethods;

public class DungeonClassicMob
extends AbstractDungeonType {
    private IBlockState block = null;
    private BlockSets.Modifier modifier = null;
    private final String mob;
    private int spawnRate = 4;
    private IBlockState stripe = null;

    public DungeonClassicMob(String name, IBlockState state, String mobspawner) {
        super(name, 0, 0, false);
        this.block = state;
        this.mob = mobspawner;
    }

    public DungeonClassicMob(String name, BlockSets.Modifier modifier, String mobspawner) {
        super(name, 0, 0, false);
        this.modifier = modifier;
        this.mob = mobspawner;
    }

    public DungeonClassicMob(String name, int ceilingAddonPercentChance, int floorAddonPercentChance, IBlockState state, String mobspawner) {
        super(name, ceilingAddonPercentChance, floorAddonPercentChance, false);
        this.block = state;
        this.mob = mobspawner;
    }

    @Override
    public boolean canGenerateAt(CaveBiomeGenMethods gen, CaveListWrapper cave) {
        return this.isSize(cave, 7) && this.isHeight(cave, 4);
    }

    @Override
    public void generateCenter(CaveBiomeGenMethods gen, Random rand, CavePosition pos, float depth) {
        gen.spawnVanillaSpawner(pos.getFloorPos().func_177984_a(), this.mob, this.spawnRate);
    }

    @Override
    public void generateCeiling(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if (this.block != null) {
            gen.replaceBlock(pos, this.block);
        } else if (this.modifier != null) {
            gen.transformBlock(pos, this.modifier);
        }
    }

    @Override
    public void generateFloor(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if (this.block != null) {
            gen.replaceBlock(pos, this.block);
        } else if (this.modifier != null) {
            gen.transformBlock(pos, this.modifier);
        }
    }

    @Override
    public void generateWall(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth, int height) {
        if (this.stripe != null && height == 3) {
            gen.replaceBlock(pos, this.stripe);
        } else if (this.block != null) {
            gen.replaceBlock(pos, this.block);
        } else if (this.modifier != null) {
            gen.transformBlock(pos, this.modifier);
        }
    }

    public DungeonClassicMob setSpawnRate(int rate) {
        this.spawnRate = rate;
        return this;
    }

    public DungeonClassicMob setStripe(IBlockState state) {
        this.stripe = state;
        return this;
    }

    @Override
    public void generateCeilingAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
    }

    @Override
    public void generateFloorAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
    }
}

