/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.subcaves.ambient;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import wtf.blocks.AnimatedBlock;
import wtf.init.BlockSets;
import wtf.utilities.wrappers.CaveListWrapper;
import wtf.utilities.wrappers.CavePosition;
import wtf.worldgen.AbstractDungeonType;
import wtf.worldgen.caves.CaveBiomeGenMethods;

public class DungeonTypeRain
extends AbstractDungeonType {
    public DungeonTypeRain(String name, int ceilingAddonPercentChance, int floorAddonPercentChance) {
        super(name, ceilingAddonPercentChance, floorAddonPercentChance, false);
    }

    @Override
    public boolean canGenerateAt(CaveBiomeGenMethods gen, CaveListWrapper cave) {
        return this.isSize(cave, 5) && this.isHeight(cave, 3);
    }

    @Override
    public void generateCeilingAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        gen.genStalactite(pos, depth, false);
    }

    @Override
    public void generateCenter(CaveBiomeGenMethods gen, Random rand, CavePosition pos, float depth) {
    }

    @Override
    public void generateCeiling(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if (gen.transformBlock(pos, BlockSets.Modifier.WATER_DRIP) && random.nextBoolean()) {
            ((AnimatedBlock)gen.getBlockState(pos).func_177230_c()).setFast(gen.chunk.func_177412_p(), pos);
        } else {
            int var = random.nextInt(3);
            switch (var) {
                case 0: {
                    gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
                    break;
                }
                case 1: {
                    gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
                    break;
                }
                case 2: {
                    gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
                    gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
                }
            }
        }
    }

    @Override
    public void generateFloor(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        int var = random.nextInt(3);
        boolean water = random.nextBoolean();
        switch (var) {
            case 0: {
                if (water) {
                    gen.setWaterPatch(pos);
                    gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
                    break;
                }
                gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
                break;
            }
            case 1: {
                if (water) {
                    gen.setWaterPatch(pos);
                    gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
                    break;
                }
                gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
                break;
            }
            case 2: {
                if (water) {
                    gen.setWaterPatch(pos);
                    gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
                    gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
                    break;
                }
                gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
                gen.transformBlock(pos.func_177977_b(), BlockSets.Modifier.MOSSY);
            }
        }
    }

    @Override
    public void generateWall(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth, int height) {
        int var = random.nextInt(3);
        switch (var) {
            case 0: {
                gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
                break;
            }
            case 1: {
                gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
                break;
            }
            case 2: {
                gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
                gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
            }
        }
    }

    @Override
    public void generateFloorAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
    }
}

