/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.subbiomes;

import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomePlains;
import net.minecraft.world.gen.feature.WorldGenerator;
import wtf.config.OverworldGenConfig;
import wtf.utilities.wrappers.ChunkScan;
import wtf.worldgen.subbiomes.SubBiome;
import wtf.worldgen.trees.WorldGenCustomTree;
import wtf.worldgen.trees.types.PoplarTree;

public class SubBiomeMeadow
extends BiomePlains
implements SubBiome {
    Random random = new Random();
    WorldGenerator poplar = null;

    public SubBiomeMeadow(Biome.BiomeProperties properties) {
        super(false, properties);
        this.field_76760_I.field_76832_z = 6;
    }

    @Override
    public void resetTopBlock(World world, BlockPos pos) {
        if ((double)this.random.nextFloat() < 0.05) {
            world.func_175718_b(2005, pos, 0);
        }
    }

    @Override
    public double scale() {
        return OverworldGenConfig.meadowSize / 100;
    }

    @Override
    public double freq() {
        return OverworldGenConfig.meadowPercent / 100;
    }

    @Override
    public Biome getBiome() {
        return this;
    }

    @Override
    public byte getID() {
        return (byte)OverworldGenConfig.meadowID;
    }

    @Override
    public Biome getParentBiome() {
        return Biomes.field_76772_c;
    }

    @Override
    public WorldGenerator getTree(ChunkScan chunkscan, boolean doReplace, Random random) {
        if (this.poplar == null) {
            this.poplar = new WorldGenCustomTree(chunkscan, new PoplarTree(chunkscan.world));
        }
        return this.poplar;
    }
}

