/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.subbiomes;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeSwamp;
import net.minecraft.world.gen.feature.WorldGenerator;
import wtf.config.OverworldGenConfig;
import wtf.utilities.wrappers.ChunkScan;
import wtf.worldgen.subbiomes.SubBiome;
import wtf.worldgen.trees.WorldGenCustomTree;
import wtf.worldgen.trees.types.Mangrove;

public class SubBiomeMangroveSwamp
extends BiomeSwamp
implements SubBiome {
    private final Biome parentBiome;
    private byte ID = (byte)-1;
    WorldGenCustomTree mangrove = null;

    public SubBiomeMangroveSwamp(Biome.BiomeProperties properties, Biome parentBiome) {
        super(properties);
        this.parentBiome = parentBiome;
        this.field_76760_I.field_76832_z = 10;
    }

    @Override
    public void resetTopBlock(World world, BlockPos pos) {
    }

    @Override
    public double scale() {
        return OverworldGenConfig.mangroveSize;
    }

    @Override
    public double freq() {
        return (double)OverworldGenConfig.mangrovePercent / 100.0;
    }

    @Override
    public Biome getBiome() {
        return this;
    }

    @Override
    public byte getID() {
        if (this.ID == -1) {
            this.ID = (byte)Biome.func_185362_a((Biome)this);
        }
        return this.ID;
    }

    @Override
    public Biome getParentBiome() {
        return this.parentBiome;
    }

    @Override
    public WorldGenerator getTree(ChunkScan chunkscan, boolean doReplace, Random random) {
        if (chunkscan.getWaterList().size() > 64) {
            if (this.mangrove == null) {
                this.mangrove = new WorldGenCustomTree(chunkscan, new Mangrove(chunkscan.world));
            }
            return this.mangrove;
        }
        return this.func_150567_a(random);
    }
}

