/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.caves.types;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import wtf.init.BlockSets;
import wtf.utilities.wrappers.SurfacePos;
import wtf.worldgen.AbstractCaveType;
import wtf.worldgen.caves.CaveBiomeGenMethods;

public class CaveTypeWet
extends AbstractCaveType {
    public CaveTypeWet(String name, int ceilingAddonPercentChance, int floorAddonPercentChance) {
        super(name, ceilingAddonPercentChance, floorAddonPercentChance);
    }

    @Override
    public void generateCeiling(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        double noise = this.getNoise(pos, 6.0, 0.2f);
        if ((double)random.nextFloat() < 0.25) {
            gen.transformBlock(pos, BlockSets.Modifier.WATER_DRIP);
        }
        if (random.nextBoolean() && noise < (double)(3.0f * depth)) {
            gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
        }
    }

    @Override
    public void generateFloor(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        double noise = this.getNoise(pos, 6.0, 0.2f);
        if (noise < 2.0) {
            gen.setWaterPatch(pos);
        }
        if (random.nextBoolean() && noise < (double)(3.0f * depth)) {
            gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
        }
    }

    @Override
    public void generateCeilingAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        gen.genStalactite(pos, depth, false);
    }

    @Override
    public void generateFloorAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        gen.genStalagmite(pos, depth, false);
    }

    @Override
    public void generateWall(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth, int height) {
        double noise = this.getNoise(pos, 6.0, 0.2f);
        if (random.nextBoolean() && noise < (double)(3.0f * depth)) {
            gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
        }
    }

    @Override
    public void setTopBlock(CaveBiomeGenMethods gen, Random random, SurfacePos pos) {
    }
}

