/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.caves.types;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import wtf.init.BlockSets;
import wtf.worldgen.AbstractCaveType;
import wtf.worldgen.caves.CaveBiomeGenMethods;

public class CaveTypeVolcanic
extends AbstractCaveType {
    public CaveTypeVolcanic(String name, int ceilingAddonPercentChance, int floorAddonPercentChance) {
        super(name, ceilingAddonPercentChance, floorAddonPercentChance);
    }

    @Override
    public void generateCeiling(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if (this.getNoise(pos, 5.0, 0.1f) < 1.0) {
            gen.transformBlock(pos, BlockSets.Modifier.LAVA_DRIP);
        }
    }

    @Override
    public void generateFloor(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        double noise = this.getNoise(pos, 8.0, 0.05f);
        if (noise < 2.0) {
            gen.setLavaPatch(pos);
            gen.transformBlock(pos, BlockSets.Modifier.LAVA_CRUST);
        } else if (noise < 3.0) {
            gen.transformBlock(pos, BlockSets.Modifier.LAVA_CRUST);
        } else if (noise < 4.0) {
            gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
        }
    }

    @Override
    public void generateCeilingAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        gen.setCeilingAddon(pos, BlockSets.Modifier.COBBLE);
    }

    @Override
    public void generateFloorAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if (this.getNoise(pos.func_177977_b(), 5.0, 0.1f) >= 2.0) {
            gen.setFloorAddon(pos, BlockSets.Modifier.COBBLE);
        }
    }

    @Override
    public void generateWall(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth, int height) {
        if (this.getNoise(pos, 5.0, 0.1f) >= 2.0) {
            gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
        }
    }

    public void generateAdjacentWall(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth, int height) {
    }
}

