/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.caves.types;

import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import wtf.init.BlockSets;
import wtf.utilities.wrappers.AdjPos;
import wtf.utilities.wrappers.ChunkScan;
import wtf.worldgen.AbstractCaveType;
import wtf.worldgen.caves.CaveBiomeGenMethods;
import wtf.worldgen.trees.TreeVars;

public class CaveTypeSwamp
extends AbstractCaveType {
    TreeVars mangrove = null;

    public CaveTypeSwamp(String name, int ceilingAddonPercentChance, int floorAddonPercentChance) {
        super(name, ceilingAddonPercentChance, floorAddonPercentChance);
    }

    @Override
    public void generateCeiling(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if ((double)random.nextFloat() < 0.25) {
            gen.transformBlock(pos, BlockSets.Modifier.WATER_DRIP);
        }
    }

    @Override
    public void generateFloor(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        double noise = this.getNoise(pos, 5.0, 0.33f);
        double mossNoise = this.getNoise(pos, 5.0, 2.0f);
        if (noise < 2.5) {
            gen.setWaterPatch(pos);
        }
        if (mossNoise < (double)(2.0f * depth) && random.nextBoolean()) {
            gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
        }
        if (mossNoise < (double)(3.0f * depth)) {
            gen.transformBlock(pos.func_177977_b(), BlockSets.Modifier.MOSSY);
        }
    }

    @Override
    public void generateCeilingAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if (this.getNoise(pos, 5.0, 1.0f) < (double)(depth * 3.0f) && !gen.isChunkEdge(pos) && gen.setCeilingAddon(pos, BlockSets.Modifier.COBBLE)) {
            int loop;
            for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                gen.GenVines(pos.func_177974_f().func_177979_c(loop), EnumFacing.WEST);
            }
            for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                gen.GenVines(pos.func_177976_e().func_177979_c(loop), EnumFacing.EAST);
            }
            for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                gen.GenVines(pos.func_177978_c().func_177979_c(loop), EnumFacing.SOUTH);
            }
            for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                gen.GenVines(pos.func_177968_d().func_177979_c(loop), EnumFacing.NORTH);
            }
        } else {
            gen.genStalactite(pos, depth, false);
        }
    }

    @Override
    public void generateFloorAddons(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth) {
        if (this.getNoise(pos, 5.0, 1.0f) < (double)(depth * 3.0f) && !gen.isChunkEdge(pos) && gen.setFloorAddon(pos, BlockSets.Modifier.COBBLE)) {
            gen.GenVines(pos.func_177974_f(), EnumFacing.WEST);
            gen.GenVines(pos.func_177976_e(), EnumFacing.EAST);
            gen.GenVines(pos.func_177978_c(), EnumFacing.SOUTH);
            gen.GenVines(pos.func_177968_d(), EnumFacing.NORTH);
        } else {
            gen.genStalactite(pos, depth, false);
        }
    }

    @Override
    public void generateWall(CaveBiomeGenMethods gen, Random random, BlockPos pos, float depth, int height) {
        double mossNoise = this.getNoise(pos, 5.0, 2.0f);
        if (mossNoise < (double)(2.0f * depth) && random.nextBoolean()) {
            gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
        }
        if (mossNoise < (double)(3.0f * depth)) {
            gen.transformBlock(pos.func_177977_b(), BlockSets.Modifier.MOSSY);
        }
    }

    @Override
    public void generateAdjacentWall(CaveBiomeGenMethods gen, Random random, AdjPos pos, float depth, int height) {
        if (this.getNoise(pos, 5.0, 1.0f) < (double)depth * 1.5) {
            gen.GenVines(pos, pos.getFace(random));
        }
    }

    @Override
    public TreeVars getTreeType(World world, ChunkScan scan, WorldGenAbstractTree oldTree) {
        double noise = this.getNoise(scan.surface[8][8], 1.0, 0.1f);
        return super.getTreeType(world, scan, oldTree);
    }
}

